/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.functions;

import java.util.Collection;
import java.util.Map;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.WindowConfig;

public class FunctionConfig {
    private String runtimeFlags;
    private String tenant;
    private String namespace;
    private String name;
    private String className;
    private Collection<String> inputs;
    private Map<String, String> customSerdeInputs;
    private String topicsPattern;
    private Map<String, String> customSchemaInputs;
    private Map<String, String> customSchemaOutputs;
    private Map<String, ConsumerConfig> inputSpecs;
    private String output;
    private ProducerConfig producerConfig;
    private String outputSchemaType;
    private String outputSerdeClassName;
    private String logTopic;
    private ProcessingGuarantees processingGuarantees;
    private Boolean retainOrdering;
    private Boolean retainKeyOrdering;
    private String batchBuilder;
    private Boolean forwardSourceMessageProperty;
    private Map<String, Object> userConfig;
    private Map<String, Object> secrets;
    private Runtime runtime;
    @Deprecated
    private Boolean autoAck;
    private Integer maxMessageRetries;
    private String deadLetterTopic;
    private String subName;
    private Integer parallelism;
    private Resources resources;
    private String fqfn;
    private WindowConfig windowConfig;
    private Long timeoutMs;
    private String jar;
    private String py;
    private String go;
    private String functionType;
    private Boolean cleanupSubscription;
    private String customRuntimeOptions;
    private Integer maxPendingAsyncRequests;
    private Boolean exposePulsarAdminClientEnabled;
    private SubscriptionInitialPosition subscriptionPosition;

    private static SubscriptionInitialPosition $default$subscriptionPosition() {
        return SubscriptionInitialPosition.Latest;
    }

    public static FunctionConfigBuilder builder() {
        return new FunctionConfigBuilder();
    }

    public FunctionConfigBuilder toBuilder() {
        return new FunctionConfigBuilder().runtimeFlags(this.runtimeFlags).tenant(this.tenant).namespace(this.namespace).name(this.name).className(this.className).inputs(this.inputs).customSerdeInputs(this.customSerdeInputs).topicsPattern(this.topicsPattern).customSchemaInputs(this.customSchemaInputs).customSchemaOutputs(this.customSchemaOutputs).inputSpecs(this.inputSpecs).output(this.output).producerConfig(this.producerConfig).outputSchemaType(this.outputSchemaType).outputSerdeClassName(this.outputSerdeClassName).logTopic(this.logTopic).processingGuarantees(this.processingGuarantees).retainOrdering(this.retainOrdering).retainKeyOrdering(this.retainKeyOrdering).batchBuilder(this.batchBuilder).forwardSourceMessageProperty(this.forwardSourceMessageProperty).userConfig(this.userConfig).secrets(this.secrets).runtime(this.runtime).autoAck(this.autoAck).maxMessageRetries(this.maxMessageRetries).deadLetterTopic(this.deadLetterTopic).subName(this.subName).parallelism(this.parallelism).resources(this.resources).fqfn(this.fqfn).windowConfig(this.windowConfig).timeoutMs(this.timeoutMs).jar(this.jar).py(this.py).go(this.go).functionType(this.functionType).cleanupSubscription(this.cleanupSubscription).customRuntimeOptions(this.customRuntimeOptions).maxPendingAsyncRequests(this.maxPendingAsyncRequests).exposePulsarAdminClientEnabled(this.exposePulsarAdminClientEnabled).subscriptionPosition(this.subscriptionPosition);
    }

    public String getRuntimeFlags() {
        return this.runtimeFlags;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public Collection<String> getInputs() {
        return this.inputs;
    }

    public Map<String, String> getCustomSerdeInputs() {
        return this.customSerdeInputs;
    }

    public String getTopicsPattern() {
        return this.topicsPattern;
    }

    public Map<String, String> getCustomSchemaInputs() {
        return this.customSchemaInputs;
    }

    public Map<String, String> getCustomSchemaOutputs() {
        return this.customSchemaOutputs;
    }

    public Map<String, ConsumerConfig> getInputSpecs() {
        return this.inputSpecs;
    }

    public String getOutput() {
        return this.output;
    }

    public ProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public String getOutputSchemaType() {
        return this.outputSchemaType;
    }

    public String getOutputSerdeClassName() {
        return this.outputSerdeClassName;
    }

    public String getLogTopic() {
        return this.logTopic;
    }

    public ProcessingGuarantees getProcessingGuarantees() {
        return this.processingGuarantees;
    }

    public Boolean getRetainOrdering() {
        return this.retainOrdering;
    }

    public Boolean getRetainKeyOrdering() {
        return this.retainKeyOrdering;
    }

    public String getBatchBuilder() {
        return this.batchBuilder;
    }

    public Boolean getForwardSourceMessageProperty() {
        return this.forwardSourceMessageProperty;
    }

    public Map<String, Object> getUserConfig() {
        return this.userConfig;
    }

    public Map<String, Object> getSecrets() {
        return this.secrets;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    @Deprecated
    public Boolean getAutoAck() {
        return this.autoAck;
    }

    public Integer getMaxMessageRetries() {
        return this.maxMessageRetries;
    }

    public String getDeadLetterTopic() {
        return this.deadLetterTopic;
    }

    public String getSubName() {
        return this.subName;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getFqfn() {
        return this.fqfn;
    }

    public WindowConfig getWindowConfig() {
        return this.windowConfig;
    }

    public Long getTimeoutMs() {
        return this.timeoutMs;
    }

    public String getJar() {
        return this.jar;
    }

    public String getPy() {
        return this.py;
    }

    public String getGo() {
        return this.go;
    }

    public String getFunctionType() {
        return this.functionType;
    }

    public Boolean getCleanupSubscription() {
        return this.cleanupSubscription;
    }

    public String getCustomRuntimeOptions() {
        return this.customRuntimeOptions;
    }

    public Integer getMaxPendingAsyncRequests() {
        return this.maxPendingAsyncRequests;
    }

    public Boolean getExposePulsarAdminClientEnabled() {
        return this.exposePulsarAdminClientEnabled;
    }

    public SubscriptionInitialPosition getSubscriptionPosition() {
        return this.subscriptionPosition;
    }

    public void setRuntimeFlags(String runtimeFlags) {
        this.runtimeFlags = runtimeFlags;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setInputs(Collection<String> inputs) {
        this.inputs = inputs;
    }

    public void setCustomSerdeInputs(Map<String, String> customSerdeInputs) {
        this.customSerdeInputs = customSerdeInputs;
    }

    public void setTopicsPattern(String topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setCustomSchemaInputs(Map<String, String> customSchemaInputs) {
        this.customSchemaInputs = customSchemaInputs;
    }

    public void setCustomSchemaOutputs(Map<String, String> customSchemaOutputs) {
        this.customSchemaOutputs = customSchemaOutputs;
    }

    public void setInputSpecs(Map<String, ConsumerConfig> inputSpecs) {
        this.inputSpecs = inputSpecs;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setProducerConfig(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }

    public void setOutputSchemaType(String outputSchemaType) {
        this.outputSchemaType = outputSchemaType;
    }

    public void setOutputSerdeClassName(String outputSerdeClassName) {
        this.outputSerdeClassName = outputSerdeClassName;
    }

    public void setLogTopic(String logTopic) {
        this.logTopic = logTopic;
    }

    public void setProcessingGuarantees(ProcessingGuarantees processingGuarantees) {
        this.processingGuarantees = processingGuarantees;
    }

    public void setRetainOrdering(Boolean retainOrdering) {
        this.retainOrdering = retainOrdering;
    }

    public void setRetainKeyOrdering(Boolean retainKeyOrdering) {
        this.retainKeyOrdering = retainKeyOrdering;
    }

    public void setBatchBuilder(String batchBuilder) {
        this.batchBuilder = batchBuilder;
    }

    public void setForwardSourceMessageProperty(Boolean forwardSourceMessageProperty) {
        this.forwardSourceMessageProperty = forwardSourceMessageProperty;
    }

    public void setUserConfig(Map<String, Object> userConfig) {
        this.userConfig = userConfig;
    }

    public void setSecrets(Map<String, Object> secrets) {
        this.secrets = secrets;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    @Deprecated
    public void setAutoAck(Boolean autoAck) {
        this.autoAck = autoAck;
    }

    public void setMaxMessageRetries(Integer maxMessageRetries) {
        this.maxMessageRetries = maxMessageRetries;
    }

    public void setDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public void setFqfn(String fqfn) {
        this.fqfn = fqfn;
    }

    public void setWindowConfig(WindowConfig windowConfig) {
        this.windowConfig = windowConfig;
    }

    public void setTimeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public void setPy(String py) {
        this.py = py;
    }

    public void setGo(String go) {
        this.go = go;
    }

    public void setFunctionType(String functionType) {
        this.functionType = functionType;
    }

    public void setCleanupSubscription(Boolean cleanupSubscription) {
        this.cleanupSubscription = cleanupSubscription;
    }

    public void setCustomRuntimeOptions(String customRuntimeOptions) {
        this.customRuntimeOptions = customRuntimeOptions;
    }

    public void setMaxPendingAsyncRequests(Integer maxPendingAsyncRequests) {
        this.maxPendingAsyncRequests = maxPendingAsyncRequests;
    }

    public void setExposePulsarAdminClientEnabled(Boolean exposePulsarAdminClientEnabled) {
        this.exposePulsarAdminClientEnabled = exposePulsarAdminClientEnabled;
    }

    public void setSubscriptionPosition(SubscriptionInitialPosition subscriptionPosition) {
        this.subscriptionPosition = subscriptionPosition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionConfig)) {
            return false;
        }
        FunctionConfig other = (FunctionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$retainOrdering = this.getRetainOrdering();
        Boolean other$retainOrdering = other.getRetainOrdering();
        if (this$retainOrdering == null ? other$retainOrdering != null : !((Object)this$retainOrdering).equals(other$retainOrdering)) {
            return false;
        }
        Boolean this$retainKeyOrdering = this.getRetainKeyOrdering();
        Boolean other$retainKeyOrdering = other.getRetainKeyOrdering();
        if (this$retainKeyOrdering == null ? other$retainKeyOrdering != null : !((Object)this$retainKeyOrdering).equals(other$retainKeyOrdering)) {
            return false;
        }
        Boolean this$forwardSourceMessageProperty = this.getForwardSourceMessageProperty();
        Boolean other$forwardSourceMessageProperty = other.getForwardSourceMessageProperty();
        if (this$forwardSourceMessageProperty == null ? other$forwardSourceMessageProperty != null : !((Object)this$forwardSourceMessageProperty).equals(other$forwardSourceMessageProperty)) {
            return false;
        }
        Boolean this$autoAck = this.getAutoAck();
        Boolean other$autoAck = other.getAutoAck();
        if (this$autoAck == null ? other$autoAck != null : !((Object)this$autoAck).equals(other$autoAck)) {
            return false;
        }
        Integer this$maxMessageRetries = this.getMaxMessageRetries();
        Integer other$maxMessageRetries = other.getMaxMessageRetries();
        if (this$maxMessageRetries == null ? other$maxMessageRetries != null : !((Object)this$maxMessageRetries).equals(other$maxMessageRetries)) {
            return false;
        }
        Integer this$parallelism = this.getParallelism();
        Integer other$parallelism = other.getParallelism();
        if (this$parallelism == null ? other$parallelism != null : !((Object)this$parallelism).equals(other$parallelism)) {
            return false;
        }
        Long this$timeoutMs = this.getTimeoutMs();
        Long other$timeoutMs = other.getTimeoutMs();
        if (this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs)) {
            return false;
        }
        Boolean this$cleanupSubscription = this.getCleanupSubscription();
        Boolean other$cleanupSubscription = other.getCleanupSubscription();
        if (this$cleanupSubscription == null ? other$cleanupSubscription != null : !((Object)this$cleanupSubscription).equals(other$cleanupSubscription)) {
            return false;
        }
        Integer this$maxPendingAsyncRequests = this.getMaxPendingAsyncRequests();
        Integer other$maxPendingAsyncRequests = other.getMaxPendingAsyncRequests();
        if (this$maxPendingAsyncRequests == null ? other$maxPendingAsyncRequests != null : !((Object)this$maxPendingAsyncRequests).equals(other$maxPendingAsyncRequests)) {
            return false;
        }
        Boolean this$exposePulsarAdminClientEnabled = this.getExposePulsarAdminClientEnabled();
        Boolean other$exposePulsarAdminClientEnabled = other.getExposePulsarAdminClientEnabled();
        if (this$exposePulsarAdminClientEnabled == null ? other$exposePulsarAdminClientEnabled != null : !((Object)this$exposePulsarAdminClientEnabled).equals(other$exposePulsarAdminClientEnabled)) {
            return false;
        }
        String this$runtimeFlags = this.getRuntimeFlags();
        String other$runtimeFlags = other.getRuntimeFlags();
        if (this$runtimeFlags == null ? other$runtimeFlags != null : !this$runtimeFlags.equals(other$runtimeFlags)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Collection<String> this$inputs = this.getInputs();
        Collection<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, String> this$customSerdeInputs = this.getCustomSerdeInputs();
        Map<String, String> other$customSerdeInputs = other.getCustomSerdeInputs();
        if (this$customSerdeInputs == null ? other$customSerdeInputs != null : !((Object)this$customSerdeInputs).equals(other$customSerdeInputs)) {
            return false;
        }
        String this$topicsPattern = this.getTopicsPattern();
        String other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        Map<String, String> this$customSchemaInputs = this.getCustomSchemaInputs();
        Map<String, String> other$customSchemaInputs = other.getCustomSchemaInputs();
        if (this$customSchemaInputs == null ? other$customSchemaInputs != null : !((Object)this$customSchemaInputs).equals(other$customSchemaInputs)) {
            return false;
        }
        Map<String, String> this$customSchemaOutputs = this.getCustomSchemaOutputs();
        Map<String, String> other$customSchemaOutputs = other.getCustomSchemaOutputs();
        if (this$customSchemaOutputs == null ? other$customSchemaOutputs != null : !((Object)this$customSchemaOutputs).equals(other$customSchemaOutputs)) {
            return false;
        }
        Map<String, ConsumerConfig> this$inputSpecs = this.getInputSpecs();
        Map<String, ConsumerConfig> other$inputSpecs = other.getInputSpecs();
        if (this$inputSpecs == null ? other$inputSpecs != null : !((Object)this$inputSpecs).equals(other$inputSpecs)) {
            return false;
        }
        String this$output = this.getOutput();
        String other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        ProducerConfig this$producerConfig = this.getProducerConfig();
        ProducerConfig other$producerConfig = other.getProducerConfig();
        if (this$producerConfig == null ? other$producerConfig != null : !((Object)this$producerConfig).equals(other$producerConfig)) {
            return false;
        }
        String this$outputSchemaType = this.getOutputSchemaType();
        String other$outputSchemaType = other.getOutputSchemaType();
        if (this$outputSchemaType == null ? other$outputSchemaType != null : !this$outputSchemaType.equals(other$outputSchemaType)) {
            return false;
        }
        String this$outputSerdeClassName = this.getOutputSerdeClassName();
        String other$outputSerdeClassName = other.getOutputSerdeClassName();
        if (this$outputSerdeClassName == null ? other$outputSerdeClassName != null : !this$outputSerdeClassName.equals(other$outputSerdeClassName)) {
            return false;
        }
        String this$logTopic = this.getLogTopic();
        String other$logTopic = other.getLogTopic();
        if (this$logTopic == null ? other$logTopic != null : !this$logTopic.equals(other$logTopic)) {
            return false;
        }
        ProcessingGuarantees this$processingGuarantees = this.getProcessingGuarantees();
        ProcessingGuarantees other$processingGuarantees = other.getProcessingGuarantees();
        if (this$processingGuarantees == null ? other$processingGuarantees != null : !((Object)((Object)this$processingGuarantees)).equals((Object)other$processingGuarantees)) {
            return false;
        }
        String this$batchBuilder = this.getBatchBuilder();
        String other$batchBuilder = other.getBatchBuilder();
        if (this$batchBuilder == null ? other$batchBuilder != null : !this$batchBuilder.equals(other$batchBuilder)) {
            return false;
        }
        Map<String, Object> this$userConfig = this.getUserConfig();
        Map<String, Object> other$userConfig = other.getUserConfig();
        if (this$userConfig == null ? other$userConfig != null : !((Object)this$userConfig).equals(other$userConfig)) {
            return false;
        }
        Map<String, Object> this$secrets = this.getSecrets();
        Map<String, Object> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        Runtime this$runtime = this.getRuntime();
        Runtime other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)((Object)this$runtime)).equals((Object)other$runtime)) {
            return false;
        }
        String this$deadLetterTopic = this.getDeadLetterTopic();
        String other$deadLetterTopic = other.getDeadLetterTopic();
        if (this$deadLetterTopic == null ? other$deadLetterTopic != null : !this$deadLetterTopic.equals(other$deadLetterTopic)) {
            return false;
        }
        String this$subName = this.getSubName();
        String other$subName = other.getSubName();
        if (this$subName == null ? other$subName != null : !this$subName.equals(other$subName)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$fqfn = this.getFqfn();
        String other$fqfn = other.getFqfn();
        if (this$fqfn == null ? other$fqfn != null : !this$fqfn.equals(other$fqfn)) {
            return false;
        }
        WindowConfig this$windowConfig = this.getWindowConfig();
        WindowConfig other$windowConfig = other.getWindowConfig();
        if (this$windowConfig == null ? other$windowConfig != null : !((Object)this$windowConfig).equals(other$windowConfig)) {
            return false;
        }
        String this$jar = this.getJar();
        String other$jar = other.getJar();
        if (this$jar == null ? other$jar != null : !this$jar.equals(other$jar)) {
            return false;
        }
        String this$py = this.getPy();
        String other$py = other.getPy();
        if (this$py == null ? other$py != null : !this$py.equals(other$py)) {
            return false;
        }
        String this$go = this.getGo();
        String other$go = other.getGo();
        if (this$go == null ? other$go != null : !this$go.equals(other$go)) {
            return false;
        }
        String this$functionType = this.getFunctionType();
        String other$functionType = other.getFunctionType();
        if (this$functionType == null ? other$functionType != null : !this$functionType.equals(other$functionType)) {
            return false;
        }
        String this$customRuntimeOptions = this.getCustomRuntimeOptions();
        String other$customRuntimeOptions = other.getCustomRuntimeOptions();
        if (this$customRuntimeOptions == null ? other$customRuntimeOptions != null : !this$customRuntimeOptions.equals(other$customRuntimeOptions)) {
            return false;
        }
        SubscriptionInitialPosition this$subscriptionPosition = this.getSubscriptionPosition();
        SubscriptionInitialPosition other$subscriptionPosition = other.getSubscriptionPosition();
        return !(this$subscriptionPosition == null ? other$subscriptionPosition != null : !this$subscriptionPosition.equals(other$subscriptionPosition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $retainOrdering = this.getRetainOrdering();
        result = result * 59 + ($retainOrdering == null ? 43 : ((Object)$retainOrdering).hashCode());
        Boolean $retainKeyOrdering = this.getRetainKeyOrdering();
        result = result * 59 + ($retainKeyOrdering == null ? 43 : ((Object)$retainKeyOrdering).hashCode());
        Boolean $forwardSourceMessageProperty = this.getForwardSourceMessageProperty();
        result = result * 59 + ($forwardSourceMessageProperty == null ? 43 : ((Object)$forwardSourceMessageProperty).hashCode());
        Boolean $autoAck = this.getAutoAck();
        result = result * 59 + ($autoAck == null ? 43 : ((Object)$autoAck).hashCode());
        Integer $maxMessageRetries = this.getMaxMessageRetries();
        result = result * 59 + ($maxMessageRetries == null ? 43 : ((Object)$maxMessageRetries).hashCode());
        Integer $parallelism = this.getParallelism();
        result = result * 59 + ($parallelism == null ? 43 : ((Object)$parallelism).hashCode());
        Long $timeoutMs = this.getTimeoutMs();
        result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
        Boolean $cleanupSubscription = this.getCleanupSubscription();
        result = result * 59 + ($cleanupSubscription == null ? 43 : ((Object)$cleanupSubscription).hashCode());
        Integer $maxPendingAsyncRequests = this.getMaxPendingAsyncRequests();
        result = result * 59 + ($maxPendingAsyncRequests == null ? 43 : ((Object)$maxPendingAsyncRequests).hashCode());
        Boolean $exposePulsarAdminClientEnabled = this.getExposePulsarAdminClientEnabled();
        result = result * 59 + ($exposePulsarAdminClientEnabled == null ? 43 : ((Object)$exposePulsarAdminClientEnabled).hashCode());
        String $runtimeFlags = this.getRuntimeFlags();
        result = result * 59 + ($runtimeFlags == null ? 43 : $runtimeFlags.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Collection<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, String> $customSerdeInputs = this.getCustomSerdeInputs();
        result = result * 59 + ($customSerdeInputs == null ? 43 : ((Object)$customSerdeInputs).hashCode());
        String $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        Map<String, String> $customSchemaInputs = this.getCustomSchemaInputs();
        result = result * 59 + ($customSchemaInputs == null ? 43 : ((Object)$customSchemaInputs).hashCode());
        Map<String, String> $customSchemaOutputs = this.getCustomSchemaOutputs();
        result = result * 59 + ($customSchemaOutputs == null ? 43 : ((Object)$customSchemaOutputs).hashCode());
        Map<String, ConsumerConfig> $inputSpecs = this.getInputSpecs();
        result = result * 59 + ($inputSpecs == null ? 43 : ((Object)$inputSpecs).hashCode());
        String $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        ProducerConfig $producerConfig = this.getProducerConfig();
        result = result * 59 + ($producerConfig == null ? 43 : ((Object)$producerConfig).hashCode());
        String $outputSchemaType = this.getOutputSchemaType();
        result = result * 59 + ($outputSchemaType == null ? 43 : $outputSchemaType.hashCode());
        String $outputSerdeClassName = this.getOutputSerdeClassName();
        result = result * 59 + ($outputSerdeClassName == null ? 43 : $outputSerdeClassName.hashCode());
        String $logTopic = this.getLogTopic();
        result = result * 59 + ($logTopic == null ? 43 : $logTopic.hashCode());
        ProcessingGuarantees $processingGuarantees = this.getProcessingGuarantees();
        result = result * 59 + ($processingGuarantees == null ? 43 : ((Object)((Object)$processingGuarantees)).hashCode());
        String $batchBuilder = this.getBatchBuilder();
        result = result * 59 + ($batchBuilder == null ? 43 : $batchBuilder.hashCode());
        Map<String, Object> $userConfig = this.getUserConfig();
        result = result * 59 + ($userConfig == null ? 43 : ((Object)$userConfig).hashCode());
        Map<String, Object> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        Runtime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)((Object)$runtime)).hashCode());
        String $deadLetterTopic = this.getDeadLetterTopic();
        result = result * 59 + ($deadLetterTopic == null ? 43 : $deadLetterTopic.hashCode());
        String $subName = this.getSubName();
        result = result * 59 + ($subName == null ? 43 : $subName.hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $fqfn = this.getFqfn();
        result = result * 59 + ($fqfn == null ? 43 : $fqfn.hashCode());
        WindowConfig $windowConfig = this.getWindowConfig();
        result = result * 59 + ($windowConfig == null ? 43 : ((Object)$windowConfig).hashCode());
        String $jar = this.getJar();
        result = result * 59 + ($jar == null ? 43 : $jar.hashCode());
        String $py = this.getPy();
        result = result * 59 + ($py == null ? 43 : $py.hashCode());
        String $go = this.getGo();
        result = result * 59 + ($go == null ? 43 : $go.hashCode());
        String $functionType = this.getFunctionType();
        result = result * 59 + ($functionType == null ? 43 : $functionType.hashCode());
        String $customRuntimeOptions = this.getCustomRuntimeOptions();
        result = result * 59 + ($customRuntimeOptions == null ? 43 : $customRuntimeOptions.hashCode());
        SubscriptionInitialPosition $subscriptionPosition = this.getSubscriptionPosition();
        result = result * 59 + ($subscriptionPosition == null ? 43 : $subscriptionPosition.hashCode());
        return result;
    }

    public String toString() {
        return "FunctionConfig(runtimeFlags=" + this.getRuntimeFlags() + ", tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", className=" + this.getClassName() + ", inputs=" + this.getInputs() + ", customSerdeInputs=" + this.getCustomSerdeInputs() + ", topicsPattern=" + this.getTopicsPattern() + ", customSchemaInputs=" + this.getCustomSchemaInputs() + ", customSchemaOutputs=" + this.getCustomSchemaOutputs() + ", inputSpecs=" + this.getInputSpecs() + ", output=" + this.getOutput() + ", producerConfig=" + this.getProducerConfig() + ", outputSchemaType=" + this.getOutputSchemaType() + ", outputSerdeClassName=" + this.getOutputSerdeClassName() + ", logTopic=" + this.getLogTopic() + ", processingGuarantees=" + (Object)((Object)this.getProcessingGuarantees()) + ", retainOrdering=" + this.getRetainOrdering() + ", retainKeyOrdering=" + this.getRetainKeyOrdering() + ", batchBuilder=" + this.getBatchBuilder() + ", forwardSourceMessageProperty=" + this.getForwardSourceMessageProperty() + ", userConfig=" + this.getUserConfig() + ", secrets=" + this.getSecrets() + ", runtime=" + (Object)((Object)this.getRuntime()) + ", autoAck=" + this.getAutoAck() + ", maxMessageRetries=" + this.getMaxMessageRetries() + ", deadLetterTopic=" + this.getDeadLetterTopic() + ", subName=" + this.getSubName() + ", parallelism=" + this.getParallelism() + ", resources=" + this.getResources() + ", fqfn=" + this.getFqfn() + ", windowConfig=" + this.getWindowConfig() + ", timeoutMs=" + this.getTimeoutMs() + ", jar=" + this.getJar() + ", py=" + this.getPy() + ", go=" + this.getGo() + ", functionType=" + this.getFunctionType() + ", cleanupSubscription=" + this.getCleanupSubscription() + ", customRuntimeOptions=" + this.getCustomRuntimeOptions() + ", maxPendingAsyncRequests=" + this.getMaxPendingAsyncRequests() + ", exposePulsarAdminClientEnabled=" + this.getExposePulsarAdminClientEnabled() + ", subscriptionPosition=" + this.getSubscriptionPosition() + ")";
    }

    public FunctionConfig() {
        this.subscriptionPosition = FunctionConfig.$default$subscriptionPosition();
    }

    public FunctionConfig(String runtimeFlags, String tenant, String namespace, String name, String className, Collection<String> inputs, Map<String, String> customSerdeInputs, String topicsPattern, Map<String, String> customSchemaInputs, Map<String, String> customSchemaOutputs, Map<String, ConsumerConfig> inputSpecs, String output, ProducerConfig producerConfig, String outputSchemaType, String outputSerdeClassName, String logTopic, ProcessingGuarantees processingGuarantees, Boolean retainOrdering, Boolean retainKeyOrdering, String batchBuilder, Boolean forwardSourceMessageProperty, Map<String, Object> userConfig, Map<String, Object> secrets, Runtime runtime, Boolean autoAck, Integer maxMessageRetries, String deadLetterTopic, String subName, Integer parallelism, Resources resources, String fqfn, WindowConfig windowConfig, Long timeoutMs, String jar, String py, String go, String functionType, Boolean cleanupSubscription, String customRuntimeOptions, Integer maxPendingAsyncRequests, Boolean exposePulsarAdminClientEnabled, SubscriptionInitialPosition subscriptionPosition) {
        this.runtimeFlags = runtimeFlags;
        this.tenant = tenant;
        this.namespace = namespace;
        this.name = name;
        this.className = className;
        this.inputs = inputs;
        this.customSerdeInputs = customSerdeInputs;
        this.topicsPattern = topicsPattern;
        this.customSchemaInputs = customSchemaInputs;
        this.customSchemaOutputs = customSchemaOutputs;
        this.inputSpecs = inputSpecs;
        this.output = output;
        this.producerConfig = producerConfig;
        this.outputSchemaType = outputSchemaType;
        this.outputSerdeClassName = outputSerdeClassName;
        this.logTopic = logTopic;
        this.processingGuarantees = processingGuarantees;
        this.retainOrdering = retainOrdering;
        this.retainKeyOrdering = retainKeyOrdering;
        this.batchBuilder = batchBuilder;
        this.forwardSourceMessageProperty = forwardSourceMessageProperty;
        this.userConfig = userConfig;
        this.secrets = secrets;
        this.runtime = runtime;
        this.autoAck = autoAck;
        this.maxMessageRetries = maxMessageRetries;
        this.deadLetterTopic = deadLetterTopic;
        this.subName = subName;
        this.parallelism = parallelism;
        this.resources = resources;
        this.fqfn = fqfn;
        this.windowConfig = windowConfig;
        this.timeoutMs = timeoutMs;
        this.jar = jar;
        this.py = py;
        this.go = go;
        this.functionType = functionType;
        this.cleanupSubscription = cleanupSubscription;
        this.customRuntimeOptions = customRuntimeOptions;
        this.maxPendingAsyncRequests = maxPendingAsyncRequests;
        this.exposePulsarAdminClientEnabled = exposePulsarAdminClientEnabled;
        this.subscriptionPosition = subscriptionPosition;
    }

    public static class FunctionConfigBuilder {
        private String runtimeFlags;
        private String tenant;
        private String namespace;
        private String name;
        private String className;
        private Collection<String> inputs;
        private Map<String, String> customSerdeInputs;
        private String topicsPattern;
        private Map<String, String> customSchemaInputs;
        private Map<String, String> customSchemaOutputs;
        private Map<String, ConsumerConfig> inputSpecs;
        private String output;
        private ProducerConfig producerConfig;
        private String outputSchemaType;
        private String outputSerdeClassName;
        private String logTopic;
        private ProcessingGuarantees processingGuarantees;
        private Boolean retainOrdering;
        private Boolean retainKeyOrdering;
        private String batchBuilder;
        private Boolean forwardSourceMessageProperty;
        private Map<String, Object> userConfig;
        private Map<String, Object> secrets;
        private Runtime runtime;
        private Boolean autoAck;
        private Integer maxMessageRetries;
        private String deadLetterTopic;
        private String subName;
        private Integer parallelism;
        private Resources resources;
        private String fqfn;
        private WindowConfig windowConfig;
        private Long timeoutMs;
        private String jar;
        private String py;
        private String go;
        private String functionType;
        private Boolean cleanupSubscription;
        private String customRuntimeOptions;
        private Integer maxPendingAsyncRequests;
        private Boolean exposePulsarAdminClientEnabled;
        private boolean subscriptionPosition$set;
        private SubscriptionInitialPosition subscriptionPosition$value;

        FunctionConfigBuilder() {
        }

        public FunctionConfigBuilder runtimeFlags(String runtimeFlags) {
            this.runtimeFlags = runtimeFlags;
            return this;
        }

        public FunctionConfigBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public FunctionConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FunctionConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FunctionConfigBuilder className(String className) {
            this.className = className;
            return this;
        }

        public FunctionConfigBuilder inputs(Collection<String> inputs) {
            this.inputs = inputs;
            return this;
        }

        public FunctionConfigBuilder customSerdeInputs(Map<String, String> customSerdeInputs) {
            this.customSerdeInputs = customSerdeInputs;
            return this;
        }

        public FunctionConfigBuilder topicsPattern(String topicsPattern) {
            this.topicsPattern = topicsPattern;
            return this;
        }

        public FunctionConfigBuilder customSchemaInputs(Map<String, String> customSchemaInputs) {
            this.customSchemaInputs = customSchemaInputs;
            return this;
        }

        public FunctionConfigBuilder customSchemaOutputs(Map<String, String> customSchemaOutputs) {
            this.customSchemaOutputs = customSchemaOutputs;
            return this;
        }

        public FunctionConfigBuilder inputSpecs(Map<String, ConsumerConfig> inputSpecs) {
            this.inputSpecs = inputSpecs;
            return this;
        }

        public FunctionConfigBuilder output(String output) {
            this.output = output;
            return this;
        }

        public FunctionConfigBuilder producerConfig(ProducerConfig producerConfig) {
            this.producerConfig = producerConfig;
            return this;
        }

        public FunctionConfigBuilder outputSchemaType(String outputSchemaType) {
            this.outputSchemaType = outputSchemaType;
            return this;
        }

        public FunctionConfigBuilder outputSerdeClassName(String outputSerdeClassName) {
            this.outputSerdeClassName = outputSerdeClassName;
            return this;
        }

        public FunctionConfigBuilder logTopic(String logTopic) {
            this.logTopic = logTopic;
            return this;
        }

        public FunctionConfigBuilder processingGuarantees(ProcessingGuarantees processingGuarantees) {
            this.processingGuarantees = processingGuarantees;
            return this;
        }

        public FunctionConfigBuilder retainOrdering(Boolean retainOrdering) {
            this.retainOrdering = retainOrdering;
            return this;
        }

        public FunctionConfigBuilder retainKeyOrdering(Boolean retainKeyOrdering) {
            this.retainKeyOrdering = retainKeyOrdering;
            return this;
        }

        public FunctionConfigBuilder batchBuilder(String batchBuilder) {
            this.batchBuilder = batchBuilder;
            return this;
        }

        public FunctionConfigBuilder forwardSourceMessageProperty(Boolean forwardSourceMessageProperty) {
            this.forwardSourceMessageProperty = forwardSourceMessageProperty;
            return this;
        }

        public FunctionConfigBuilder userConfig(Map<String, Object> userConfig) {
            this.userConfig = userConfig;
            return this;
        }

        public FunctionConfigBuilder secrets(Map<String, Object> secrets) {
            this.secrets = secrets;
            return this;
        }

        public FunctionConfigBuilder runtime(Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        @Deprecated
        public FunctionConfigBuilder autoAck(Boolean autoAck) {
            this.autoAck = autoAck;
            return this;
        }

        public FunctionConfigBuilder maxMessageRetries(Integer maxMessageRetries) {
            this.maxMessageRetries = maxMessageRetries;
            return this;
        }

        public FunctionConfigBuilder deadLetterTopic(String deadLetterTopic) {
            this.deadLetterTopic = deadLetterTopic;
            return this;
        }

        public FunctionConfigBuilder subName(String subName) {
            this.subName = subName;
            return this;
        }

        public FunctionConfigBuilder parallelism(Integer parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public FunctionConfigBuilder resources(Resources resources) {
            this.resources = resources;
            return this;
        }

        public FunctionConfigBuilder fqfn(String fqfn) {
            this.fqfn = fqfn;
            return this;
        }

        public FunctionConfigBuilder windowConfig(WindowConfig windowConfig) {
            this.windowConfig = windowConfig;
            return this;
        }

        public FunctionConfigBuilder timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public FunctionConfigBuilder jar(String jar) {
            this.jar = jar;
            return this;
        }

        public FunctionConfigBuilder py(String py) {
            this.py = py;
            return this;
        }

        public FunctionConfigBuilder go(String go) {
            this.go = go;
            return this;
        }

        public FunctionConfigBuilder functionType(String functionType) {
            this.functionType = functionType;
            return this;
        }

        public FunctionConfigBuilder cleanupSubscription(Boolean cleanupSubscription) {
            this.cleanupSubscription = cleanupSubscription;
            return this;
        }

        public FunctionConfigBuilder customRuntimeOptions(String customRuntimeOptions) {
            this.customRuntimeOptions = customRuntimeOptions;
            return this;
        }

        public FunctionConfigBuilder maxPendingAsyncRequests(Integer maxPendingAsyncRequests) {
            this.maxPendingAsyncRequests = maxPendingAsyncRequests;
            return this;
        }

        public FunctionConfigBuilder exposePulsarAdminClientEnabled(Boolean exposePulsarAdminClientEnabled) {
            this.exposePulsarAdminClientEnabled = exposePulsarAdminClientEnabled;
            return this;
        }

        public FunctionConfigBuilder subscriptionPosition(SubscriptionInitialPosition subscriptionPosition) {
            this.subscriptionPosition$value = subscriptionPosition;
            this.subscriptionPosition$set = true;
            return this;
        }

        public FunctionConfig build() {
            SubscriptionInitialPosition subscriptionPosition$value = this.subscriptionPosition$value;
            if (!this.subscriptionPosition$set) {
                subscriptionPosition$value = FunctionConfig.$default$subscriptionPosition();
            }
            return new FunctionConfig(this.runtimeFlags, this.tenant, this.namespace, this.name, this.className, this.inputs, this.customSerdeInputs, this.topicsPattern, this.customSchemaInputs, this.customSchemaOutputs, this.inputSpecs, this.output, this.producerConfig, this.outputSchemaType, this.outputSerdeClassName, this.logTopic, this.processingGuarantees, this.retainOrdering, this.retainKeyOrdering, this.batchBuilder, this.forwardSourceMessageProperty, this.userConfig, this.secrets, this.runtime, this.autoAck, this.maxMessageRetries, this.deadLetterTopic, this.subName, this.parallelism, this.resources, this.fqfn, this.windowConfig, this.timeoutMs, this.jar, this.py, this.go, this.functionType, this.cleanupSubscription, this.customRuntimeOptions, this.maxPendingAsyncRequests, this.exposePulsarAdminClientEnabled, subscriptionPosition$value);
        }

        public String toString() {
            return "FunctionConfig.FunctionConfigBuilder(runtimeFlags=" + this.runtimeFlags + ", tenant=" + this.tenant + ", namespace=" + this.namespace + ", name=" + this.name + ", className=" + this.className + ", inputs=" + this.inputs + ", customSerdeInputs=" + this.customSerdeInputs + ", topicsPattern=" + this.topicsPattern + ", customSchemaInputs=" + this.customSchemaInputs + ", customSchemaOutputs=" + this.customSchemaOutputs + ", inputSpecs=" + this.inputSpecs + ", output=" + this.output + ", producerConfig=" + this.producerConfig + ", outputSchemaType=" + this.outputSchemaType + ", outputSerdeClassName=" + this.outputSerdeClassName + ", logTopic=" + this.logTopic + ", processingGuarantees=" + (Object)((Object)this.processingGuarantees) + ", retainOrdering=" + this.retainOrdering + ", retainKeyOrdering=" + this.retainKeyOrdering + ", batchBuilder=" + this.batchBuilder + ", forwardSourceMessageProperty=" + this.forwardSourceMessageProperty + ", userConfig=" + this.userConfig + ", secrets=" + this.secrets + ", runtime=" + (Object)((Object)this.runtime) + ", autoAck=" + this.autoAck + ", maxMessageRetries=" + this.maxMessageRetries + ", deadLetterTopic=" + this.deadLetterTopic + ", subName=" + this.subName + ", parallelism=" + this.parallelism + ", resources=" + this.resources + ", fqfn=" + this.fqfn + ", windowConfig=" + this.windowConfig + ", timeoutMs=" + this.timeoutMs + ", jar=" + this.jar + ", py=" + this.py + ", go=" + this.go + ", functionType=" + this.functionType + ", cleanupSubscription=" + this.cleanupSubscription + ", customRuntimeOptions=" + this.customRuntimeOptions + ", maxPendingAsyncRequests=" + this.maxPendingAsyncRequests + ", exposePulsarAdminClientEnabled=" + this.exposePulsarAdminClientEnabled + ", subscriptionPosition$value=" + this.subscriptionPosition$value + ")";
        }
    }

    public static enum ProcessingGuarantees {
        ATLEAST_ONCE,
        ATMOST_ONCE,
        EFFECTIVELY_ONCE,
        MANUAL;

    }

    public static enum Runtime {
        JAVA,
        PYTHON,
        GO;

    }
}

