/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.util.Arrays;
import org.apache.pulsar.tests.ThreadDumpUtil;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.internal.thread.ThreadTimeoutException;

public class PulsarTestListener
implements ITestListener {
    public void onTestStart(ITestResult result) {
        System.out.format("------- Starting test %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
    }

    public void onTestSuccess(ITestResult result) {
        System.out.format("------- SUCCESS -- %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
    }

    public void onTestFailure(ITestResult result) {
        if (!(result.getThrowable() instanceof SkipException)) {
            System.out.format("!!!!!!!!! FAILURE-- %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
        }
        if (result.getThrowable() instanceof ThreadTimeoutException) {
            System.out.println("====== THREAD DUMPS ======");
            System.out.println(ThreadDumpUtil.buildThreadDiagnosticString());
        }
    }

    public void onTestSkipped(ITestResult result) {
        System.out.format("~~~~~~~~~ SKIPPED -- %s.%s(%s)-------\n", result.getTestClass(), result.getMethod().getMethodName(), Arrays.toString(result.getParameters()));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }
}

