/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.dbBrowser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.portals.applications.dbBrowser.ActionParameter;
import org.apache.portals.applications.dbBrowser.Browser;
import org.apache.portals.applications.dbBrowser.BrowserIterator;
import org.apache.portals.applications.dbBrowser.BrowserPortlet;
import org.apache.portals.applications.dbBrowser.DatabaseBrowserIterator;
import org.apache.portals.applications.dbBrowser.StatusMessage;
import org.apache.portals.bridges.util.PreferencesHelper;
import org.apache.portals.messaging.PortletMessaging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseBrowserPortlet
extends BrowserPortlet
implements Browser {
    private static final String COLUMNS_TITLE = "columnTitles";
    private static final String EXPORT_TYPE = "exportType";
    private static final String XML_EXPORT = "xmlExport";
    private static final String XLS_EXPORT = "xlsExport";
    protected static final String TABLE_LIST = "tableLists";
    String pathSeprator = System.getProperty("file.separator");
    String pageRoot = System.getProperty("java.io.tmpdir");
    private String[] colNames;
    private SimpleDateFormat date_output;
    private static final String DATE_OUTPUT_PATTERN = "M/d/yyyy HH:mm:ss z";
    BrowserIterator dataBaseIterator;
    private String[] BLANK_STRING_ARRAY = new String[0];
    private static final int BLOCK_SIZE = 4096;

    public BrowserIterator getLocalIterators(PortletRequest request, String sql, int windowSize) throws Exception {
        DatabaseBrowserIterator iterator;
        ArrayList resultSetList = new ArrayList();
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        Connection con = null;
        Statement selectStmt = null;
        ResultSet rs = null;
        PortletSession session = request.getPortletSession();
        try {
            int i;
            String poolname = request.getPreferences().getValue("poolname", null);
            con = poolname == null || poolname.length() == 0 ? this.getConnection(request) : this.getConnection(poolname);
            selectStmt = con.prepareStatement(sql);
            this.readSqlParameters(request);
            Iterator it = this.sqlParameters.iterator();
            int ix = 0;
            while (it.hasNext()) {
                Object object = it.next();
                selectStmt.setObject(++ix, object);
            }
            rs = selectStmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnNum = rsmd.getColumnCount();
            List userObjList = (List)session.getAttribute("user-objects");
            int userObjListSize = 0;
            if (userObjList != null) {
                userObjListSize = userObjList.size();
            }
            boolean[] columnDisplayed = new boolean[columnNum + userObjListSize];
            for (i = 1; i <= columnNum; ++i) {
                int type = rsmd.getColumnType(i);
                if (type != 2004 && type != 2005 && type != -2 && type != -4 && type != -3) {
                    resultSetTitleList.add(rsmd.getColumnName(i));
                    resultSetTypeList.add(String.valueOf(type));
                    columnDisplayed[i - 1] = true;
                    continue;
                }
                columnDisplayed[i - 1] = false;
            }
            for (i = columnNum; i < columnNum + userObjListSize; ++i) {
                ActionParameter usrObj = (ActionParameter)userObjList.get(i - columnNum);
                resultSetTitleList.add(usrObj.getName());
                resultSetTypeList.add(usrObj.getType());
                columnDisplayed[i] = true;
            }
            int index = 0;
            while (rs.next()) {
                int i2;
                ArrayList<Object> row = new ArrayList<Object>(columnNum);
                for (i2 = 1; i2 <= columnNum; ++i2) {
                    if (!columnDisplayed[i2 - 1]) continue;
                    Object obj = rs.getObject(i2);
                    if (obj == null) {
                        obj = "-";
                    }
                    row.add(obj);
                }
                for (i2 = columnNum; i2 < columnNum + userObjListSize; ++i2) {
                    ActionParameter usrObj = (ActionParameter)userObjList.get(i2 - columnNum);
                    if (!columnDisplayed[i2]) continue;
                    Class<?> c = Class.forName(usrObj.getType());
                    row.add(c.newInstance());
                    this.populate(index, i2, row);
                }
                resultSetList.add(row);
                ++index;
            }
            iterator = windowSize == -1 ? new DatabaseBrowserIterator(resultSetList, resultSetTitleList, resultSetTypeList, resultSetList.size()) : new DatabaseBrowserIterator(resultSetList, resultSetTitleList, resultSetTypeList, windowSize);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (null != selectStmt) {
                selectStmt.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != con) {
                this.closeConnection(con);
            }
        }
        return iterator;
    }

    @Override
    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList resultSetList = new ArrayList();
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        Connection con = null;
        Statement selectStmt = null;
        ResultSet rs = null;
        PortletSession session = request.getPortletSession();
        try {
            int i;
            String poolname = this.getPreference((PortletRequest)request, "poolname", null);
            con = poolname == null || poolname.length() == 0 ? this.getConnection((PortletRequest)request) : this.getConnection(poolname);
            selectStmt = con.prepareStatement(sql);
            this.readSqlParameters((PortletRequest)request);
            Iterator it = this.sqlParameters.iterator();
            int ix = 0;
            while (it.hasNext()) {
                Object object = it.next();
                selectStmt.setObject(++ix, object);
            }
            rs = selectStmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnNum = rsmd.getColumnCount();
            List userObjList = (List)session.getAttribute("user-objects");
            int userObjListSize = 0;
            if (userObjList != null) {
                userObjListSize = userObjList.size();
            }
            boolean[] columnDisplayed = new boolean[columnNum + userObjListSize];
            for (i = 1; i <= columnNum; ++i) {
                int type = rsmd.getColumnType(i);
                if (type != 2004 && type != 2005 && type != -2 && type != -4 && type != -3) {
                    resultSetTitleList.add(rsmd.getColumnName(i));
                    resultSetTypeList.add(String.valueOf(type));
                    columnDisplayed[i - 1] = true;
                    continue;
                }
                columnDisplayed[i - 1] = false;
            }
            for (i = columnNum; i < columnNum + userObjListSize; ++i) {
                ActionParameter usrObj = (ActionParameter)userObjList.get(i - columnNum);
                resultSetTitleList.add(usrObj.getName());
                resultSetTypeList.add(usrObj.getType());
                columnDisplayed[i] = true;
            }
            int index = 0;
            while (rs.next()) {
                int i2;
                ArrayList<Object> row = new ArrayList<Object>(columnNum);
                for (i2 = 1; i2 <= columnNum; ++i2) {
                    if (!columnDisplayed[i2 - 1]) continue;
                    Object obj = rs.getObject(i2);
                    if (obj == null) {
                        obj = "-";
                    }
                    row.add(obj);
                }
                for (i2 = columnNum; i2 < columnNum + userObjListSize; ++i2) {
                    ActionParameter usrObj = (ActionParameter)userObjList.get(i2 - columnNum);
                    if (!columnDisplayed[i2]) continue;
                    Class<?> c = Class.forName(usrObj.getType());
                    row.add(c.newInstance());
                    this.populate(index, i2, row);
                }
                if (this.filter(row, request)) continue;
                resultSetList.add(row);
                ++index;
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(resultSetList, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, iterator);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (null != selectStmt) {
                selectStmt.close();
            }
            if (null != rs) {
                rs.close();
            }
            if (null != con) {
                this.closeConnection(con);
            }
        }
    }

    public Connection getConnection(PortletRequest request) throws Exception {
        Connection con;
        block6: {
            con = null;
            try {
                PortletPreferences prefs = request.getPreferences();
                String dsType = prefs.getValue("DatasourceType", null);
                if (dsType == null) {
                    throw new SQLException("No DataSource provided");
                }
                if (dsType.equals("jndi")) {
                    InitialContext ctx = new InitialContext();
                    String dsName = prefs.getValue("JndiDatasource", "");
                    Context envContext = (Context)ctx.lookup("java:/comp/env");
                    DataSource ds = (DataSource)envContext.lookup(dsName);
                    con = ds.getConnection();
                    break block6;
                }
                if (dsType.equals("dbcp")) {
                    String url = prefs.getValue("JdbcConnection", "");
                    if (url.equals("jdbc:derby:JETSPEED-DEMO")) {
                        String dbpath = this.getPortletContext().getRealPath("/WEB-INF/demodb");
                        url = "jdbc:derby:" + dbpath;
                    }
                    BasicDataSource ds = new BasicDataSource();
                    ds.setDriverClassName(prefs.getValue("JdbcDriver", ""));
                    ds.setUrl(url);
                    ds.setUsername(prefs.getValue("JdbcUsername", ""));
                    ds.setPassword(prefs.getValue("JdbcPassword", ""));
                    con = ds.getConnection();
                    break block6;
                }
                throw new SQLException("No DataSource provided");
            }
            catch (Exception e) {
                throw new Exception("Failed to connect", e);
            }
        }
        return con;
    }

    private Method[] getResultMethods(List types) {
        Method[] beanMethods = new Method[types.size()];
        block7: for (int index = 0; index < beanMethods.length; ++index) {
            int type = Integer.parseInt((String)types.get(index));
            switch (type) {
                case 91: {
                    continue block7;
                }
                case 12: {
                    continue block7;
                }
                case 1: {
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
                case 6: {
                    continue block7;
                }
            }
        }
        return beanMethods;
    }

    public Connection getConnection(String poolName) {
        return null;
    }

    public void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.log.error("Cant close connection", (Throwable)e);
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String exportParam = request.getParameter(EXPORT_TYPE);
        String xlsFileName = "thedata.xls";
        String fileName = "";
        if (!StringUtils.isEmpty((String)exportParam)) {
            if (exportParam.equals(XLS_EXPORT)) {
                try {
                    this.dataBaseIterator = this.getLocalIterators((PortletRequest)request, this.getQueryString((PortletRequest)request), -1);
                    HSSFWorkbook excelWorkbook = this.generateExcel(this.dataBaseIterator.getResultSet(), this.getColumNames((PortletRequest)request), this.getTitleList((PortletRequest)request).toArray(new String[this.getTitleList((PortletRequest)request).size()]), this.getResultMethods(this.dataBaseIterator.getResultSetTypesList()));
                    if (excelWorkbook != null) {
                        response.setContentType("application/octet-stream");
                        response.setProperty("Content-Disposition", "attachment; filename=export.xls");
                        response.getPortletOutputStream().write(excelWorkbook.getBytes());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (exportParam.equals(XML_EXPORT)) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String editAction;
        Connection con = null;
        response.setContentType("text/html");
        List<String> tableList = null;
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"DatabaseBrowserPortlet", (String)"dbConnectTest");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        if ((editAction = request.getParameter("configPage")) != null && editAction.equals("configPage1")) {
            try {
                con = this.getConnection((PortletRequest)request);
                this.fillColumnDropDown(con, request);
                this.getContext(request).put("cols", (Object)this.getColNames());
                this.getContext(request).put("colTitle", (Object)this.getTitleList((PortletRequest)request));
                this.getContext(request).put("colName", (Object)this.getColumNames((PortletRequest)request));
                this.getContext(request).put("sortCols", (Object)this.getSortColums((PortletRequest)request));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection(con);
            }
            request.setAttribute("EditPage", (Object)"/WEB-INF/view/database-edit1.vm");
        } else {
            try {
                con = this.getConnection((PortletRequest)request);
                tableList = this.getTables((PortletRequest)request, con);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tableList != null && tableList.size() > 0) {
                this.getContext(request).put(TABLE_LIST, tableList);
            }
        }
        super.doEdit(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String userName = "";
        if (request.getPortletMode() == PortletMode.EDIT) {
            String test = request.getParameter("Test");
            if (test != null && test.equals("Test")) {
                Connection con = null;
                try {
                    PortletPreferences prefs = request.getPreferences();
                    PreferencesHelper.requestParamsToPreferences((ActionRequest)request);
                    prefs.store();
                    con = this.getConnection((PortletRequest)request);
                    StatusMessage msg = new StatusMessage("Connection made successfully.", "portlet-msg-success");
                    PortletMessaging.publish((PortletRequest)request, (String)"DatabaseBrowserPortlet", (String)"dbConnectTest", (Object)msg);
                    this.closeConnection(con);
                }
                catch (Exception e) {
                    try {
                        String msg = e.toString();
                        Throwable cause = e.getCause();
                        if (cause != null) {
                            msg = msg + ", " + cause.getMessage();
                        }
                        StatusMessage sm = new StatusMessage(msg, "portlet-msg-error");
                        PortletMessaging.publish((PortletRequest)request, (String)"DatabaseBrowserPortlet", (String)"dbConnectTest", (Object)sm);
                        this.closeConnection(con);
                    }
                    catch (Throwable throwable) {
                        this.closeConnection(con);
                        throw throwable;
                    }
                }
                response.setPortletMode(PortletMode.EDIT);
                return;
            }
            String editAction = request.getParameter("configPage");
            if (editAction != null) {
                if (editAction.equals("configPage1")) {
                    PortletPreferences prefs = request.getPreferences();
                    PreferencesHelper.requestParamsToPreferences((ActionRequest)request);
                    prefs.store();
                    response.setPortletMode(PortletMode.EDIT);
                    response.setRenderParameter("configPage", editAction);
                    response.setRenderParameter("tableName", request.getParameter("tableName"));
                    return;
                }
                if (editAction.equals("configPage")) {
                    response.setPortletMode(PortletMode.EDIT);
                    return;
                }
                if (editAction.equals("save")) {
                    PortletPreferences prefs = request.getPreferences();
                    PreferencesHelper.requestParamsToPreferences((ActionRequest)request);
                    prefs.store();
                    response.setPortletMode(PortletMode.VIEW);
                }
            }
        }
        super.processAction(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain(InputStream r, OutputStream w) throws IOException {
        byte[] bytes = new byte[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }

    private String[] getColNames() {
        return this.colNames;
    }

    public String[] getResultSetTitleList(RenderRequest request, String[] columnNames) {
        String[] columnsNames = request.getPreferences().getValues(COLUMNS_TITLE, columnNames);
        return columnsNames;
    }

    private void fillColumnDropDown(Connection con, RenderRequest request) {
        try {
            String tableName = !StringUtils.isEmpty((String)request.getParameter("tableName")) ? request.getParameter("tableName") : request.getPreferences().getValue("tableName", "");
            Statement stmt = con.createStatement();
            ResultSet set = stmt.executeQuery("select * from " + tableName);
            ResultSetMetaData meta = set.getMetaData();
            int ColumnCount = meta.getColumnCount();
            ArrayList<String> colums = new ArrayList<String>();
            for (int index = 1; index <= ColumnCount; ++index) {
                colums.add(meta.getColumnName(index));
            }
            this.colNames = new String[colums.size()];
            colums.toArray(this.colNames);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public List getTitleList(PortletRequest request) {
        String titles = null;
        titles = request.getPreferences().getValue(COLUMNS_TITLE, titles);
        return Arrays.asList(titles.split(","));
    }

    public String[] getColumNames(PortletRequest request) {
        String tempColumn = "";
        tempColumn = request.getPreferences().getValue("columnNames", tempColumn);
        if (StringUtils.isEmpty((String)tempColumn)) {
            return this.BLANK_STRING_ARRAY;
        }
        return tempColumn.split(",");
    }

    public String[] getSortColums(PortletRequest request) {
        String tempColumn = "";
        tempColumn = request.getPreferences().getValue("orderByColumns", tempColumn);
        if (StringUtils.isEmpty((String)tempColumn)) {
            return this.BLANK_STRING_ARRAY;
        }
        return tempColumn.split(",");
    }

    @Override
    public String getQueryString(PortletRequest request) {
        StringBuffer query = new StringBuffer();
        String table = request.getPreferences().getValue("tableName", "");
        String condtions = request.getPreferences().getValue("conditions", "");
        String orderBy = request.getPreferences().getValue("orderByColumns", "");
        String columns = request.getPreferences().getValue("columnNames", "");
        if (!StringUtils.isEmpty((String)columns)) {
            query.append("select ").append(columns).append(" from ").append(table);
        } else {
            query.append("select * from ").append(table);
        }
        if (!StringUtils.isEmpty((String)condtions)) {
            query.append(" ").append(condtions);
        }
        if (!StringUtils.isEmpty((String)orderBy)) {
            query.append(" ORDER BY ").append(orderBy);
        }
        return this.replacePlaceHolder(query.toString(), request);
    }

    private String replacePlaceHolder(String buffer, PortletRequest request) {
        String userName = "";
        userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : "guest";
        buffer = buffer.replace("$USER", "'" + userName + "'");
        return buffer;
    }

    private HSSFWorkbook generateExcel(List beanList, String[] colNames, String[] colDescs, Method[] readMethods) {
        this.date_output = new SimpleDateFormat(DATE_OUTPUT_PATTERN);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("export");
        this.addColumnHeaders(sheet, colDescs);
        this.addColumnValues(sheet, beanList, colNames, readMethods);
        return workbook;
    }

    private void addColumnHeaders(HSSFSheet sheet, String[] colDescs) {
        HSSFRow rowHeader = sheet.createRow(0);
        for (int i = 0; i < colDescs.length; ++i) {
            this.addColumnValue(rowHeader, colDescs[i], i);
        }
    }

    private void addColumnValues(HSSFSheet sheet, List beanList, String[] colNames, Method[] readMethods) {
        int rowIndex = 0;
        Iterator beanListIter = beanList.iterator();
        List tempList = null;
        while (beanListIter.hasNext()) {
            int i;
            Object bean = beanListIter.next();
            if (bean == null) continue;
            HSSFRow row = sheet.createRow(rowIndex + 1);
            if (bean instanceof ArrayList) {
                tempList = (List)bean;
                for (i = 0; i < tempList.size(); ++i) {
                    String colVal = this.columnValueToString(tempList.get(i));
                    this.addColumnValue(row, colVal, i);
                }
            } else {
                for (i = 0; i < colNames.length; ++i) {
                    String colName = colNames[i];
                    Method colReadMethod = readMethods[i];
                    String colVal = "";
                    if (colReadMethod != null) {
                        try {
                            Object colValObj = colReadMethod.invoke(bean, colName);
                            colVal = this.columnValueToString(colValObj);
                        }
                        catch (Exception ex) {
                            colVal = "";
                        }
                    }
                    this.addColumnValue(row, colVal, i);
                }
            }
            ++rowIndex;
        }
    }

    private void addColumnValue(HSSFRow rowHeader, String value, int index) {
        HSSFCell cell = rowHeader.createCell((short)index);
        cell.setEncoding((short)1);
        if (value == null) {
            value = "";
        }
        cell.setCellValue(value);
    }

    protected String columnValueToString(Object colValObj) {
        String colVal = null;
        colVal = colValObj == null ? "" : (colValObj instanceof Date ? this.date_output.format((Date)colValObj) : colValObj.toString());
        return colVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanUserFolder(String userName) {
        String folderName = "";
        DatabaseBrowserPortlet databaseBrowserPortlet = this;
        synchronized (databaseBrowserPortlet) {
            folderName = this.getUserFolder(userName, false);
            File dir = new File(folderName);
            if (dir.exists()) {
                dir.delete();
            }
            dir = new File(folderName);
            dir.mkdir();
        }
        return folderName;
    }

    private String getUserFolder(String userName, boolean fullPath) {
        if (this.pathSeprator == null || this.pathSeprator.equals("")) {
            this.pathSeprator = "/";
        }
        if (fullPath) {
            return userName + this.pathSeprator;
        }
        return this.pageRoot + this.pathSeprator + userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTables(PortletRequest request, Connection conn) {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            String databaseName = conn.getMetaData().getDatabaseProductName();
            databaseName = databaseName.toLowerCase();
            String query = this.getCatalogQuery(databaseName);
            if (query == null) {
                rs = conn.getMetaData().getTables(null, null, "%", null);
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    if (schema != null && schema.equalsIgnoreCase("SYS")) continue;
                    list.add(rs.getString("TABLE_NAME"));
                }
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e2) {}
        }
        return list;
    }

    private String getCatalogQuery(String databaseName) {
        String dataBaseQuery = null;
        if (databaseName.equals("oracle")) {
            dataBaseQuery = "SELECT table_name FROM user_tables";
        } else if (databaseName.equals("sqlserver")) {
            dataBaseQuery = "Select name from sys.objects where type='U'";
        }
        return dataBaseQuery;
    }
}

