/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.dbBrowser;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.apache.portals.applications.dbBrowser.BrowserIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBrowserIterator
implements BrowserIterator {
    private static final long serialVersionUID = 1L;
    protected transient Logger log = LoggerFactory.getLogger(DatabaseBrowserIterator.class);
    private static final String VELOCITY_NULL_ENTRY = "-";
    int top = 0;
    int index = 0;
    int bottom = -1;
    int windowSize = -1;
    int rsListSize = -1;
    boolean ascendingOrder = true;
    String sortColumnName = null;
    List rsList;
    List rsTitleList;
    List rsTypeList;

    public DatabaseBrowserIterator(List result, List columnTitles, List columnTypes, int pageSize) {
        this.rsList = result;
        this.rsTitleList = columnTitles;
        this.rsTypeList = columnTypes;
        this.windowSize = pageSize;
        this.rsListSize = result.size();
        this.setBottom();
    }

    public List getResultSet() {
        return this.rsList;
    }

    public int getResultSetSize() {
        return this.rsListSize;
    }

    public List getResultSetTitleList() {
        return this.rsTitleList;
    }

    public List getResultSetTypesList() {
        return this.rsTypeList;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int start) {
        this.index = this.top = start;
        this.setBottom();
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    private void setBottom() {
        this.bottom = this.top + this.windowSize;
        if (this.bottom > this.rsListSize) {
            this.bottom = this.rsListSize;
        }
    }

    public boolean hasNext() {
        return this.index <= this.rsListSize && this.index < this.bottom;
    }

    public Object next() {
        ++this.index;
        return this.rsList.get(this.index - 1);
    }

    public void remove() {
        this.log.info("The remove operation is not supported.");
    }

    public void sort(String columnName) {
        if (columnName != null) {
            if (this.sortColumnName != null && this.sortColumnName.equals(columnName)) {
                this.ascendingOrder = !this.ascendingOrder;
            } else {
                this.ascendingOrder = true;
                this.sortColumnName = columnName;
            }
            Collections.sort(this.rsList, this);
        }
    }

    public int compare(Object obj1, Object obj2) {
        int idx = this.rsTitleList.indexOf(this.sortColumnName);
        int order = 0;
        if (idx != -1) {
            Object col1 = null;
            Object col2 = null;
            if (obj1 instanceof String) {
                col1 = obj1;
                col2 = obj2;
            } else if (obj1 instanceof List) {
                col1 = ((List)obj1).get(idx);
                col2 = ((List)obj2).get(idx);
            }
            if (col1.equals(VELOCITY_NULL_ENTRY)) {
                order = col2.equals(VELOCITY_NULL_ENTRY) ? 0 : -1;
            } else if (col2.equals(VELOCITY_NULL_ENTRY)) {
                order = 1;
            } else {
                int type = Integer.parseInt((String)this.rsTypeList.get(idx));
                switch (type) {
                    case 2: {
                        order = ((BigDecimal)col1).compareTo((BigDecimal)col2);
                        break;
                    }
                    case 3: {
                        order = ((BigDecimal)col1).compareTo((BigDecimal)col2);
                        break;
                    }
                    case -6: {
                        order = ((Byte)col1).compareTo((Byte)col2);
                        break;
                    }
                    case 5: {
                        order = ((Short)col1).compareTo((Short)col2);
                        break;
                    }
                    case 4: {
                        order = ((Integer)col1).compareTo((Integer)col2);
                        break;
                    }
                    case -5: {
                        order = ((Long)col1).compareTo((Long)col2);
                        break;
                    }
                    case 7: {
                        order = ((Float)col1).compareTo((Float)col2);
                        break;
                    }
                    case 6: {
                        order = ((Double)col1).compareTo((Double)col2);
                        break;
                    }
                    case 8: {
                        order = ((Double)col1).compareTo((Double)col2);
                        break;
                    }
                    case 91: {
                        order = ((Date)col1).compareTo((Date)col2);
                        break;
                    }
                    case 92: {
                        order = ((Time)col1).compareTo((Time)col2);
                        break;
                    }
                    case 93: {
                        order = ((Timestamp)col1).compareTo((Timestamp)col2);
                        break;
                    }
                    case 1: {
                        order = ((String)col1).compareTo((String)col2);
                        break;
                    }
                    case 12: {
                        order = ((String)col1).compareTo((String)col2);
                        break;
                    }
                    case -1: {
                        order = ((String)col1).compareTo((String)col2);
                        break;
                    }
                    default: {
                        this.log.info("DatabaseBrowserIterator.compare DataType mapping not found in DatabaseBrowserIterator. Hence cannot sort based on provided column.");
                    }
                }
            }
        }
        if (!this.ascendingOrder) {
            order = 0 - order;
        }
        return order;
    }

    public boolean getAscendingOrder() {
        return this.ascendingOrder;
    }
}

