/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public class SectionTable {
    private static final POILogger _logger = POILogFactory.getLogger(SectionTable.class);
    private static final int SED_SIZE = 12;
    protected List<SEPX> _sections = new ArrayList<SEPX>();
    protected List<TextPiece> _text;

    public SectionTable() {
    }

    public SectionTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, TextPieceTable tpt, int mainLength) {
        int i;
        PlexOfCps sedPlex = new PlexOfCps(tableStream, offset, size, 12);
        this._text = tpt.getTextPieces();
        int length = sedPlex.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            int startAt = node.getStart();
            int endAt = node.getEnd();
            if (fileOffset == -1) {
                this._sections.add(new SEPX(sed, startAt, endAt, new byte[0]));
                continue;
            }
            short sepxSize = LittleEndian.getShort((byte[])documentStream, (int)fileOffset);
            byte[] buf = new byte[sepxSize];
            System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
            this._sections.add(new SEPX(sed, startAt, endAt, buf));
        }
        int mainEndsAt = mainLength;
        boolean matchAt = false;
        boolean matchHalf = false;
        for (i = 0; i < this._sections.size(); ++i) {
            SEPX s = this._sections.get(i);
            if (s.getEnd() == mainEndsAt) {
                matchAt = true;
                continue;
            }
            if (s.getEnd() != mainEndsAt && s.getEnd() != mainEndsAt - 1) continue;
            matchHalf = true;
        }
        if (!matchAt && matchHalf) {
            _logger.log(5, new Object[]{"Your document seemed to be mostly unicode, but the section definition was in bytes! Trying anyway, but things may well go wrong!"});
            for (i = 0; i < this._sections.size(); ++i) {
                SEPX s = this._sections.get(i);
                GenericPropertyNode node = sedPlex.getProperty(i);
                int startAt = node.getStart();
                int endAt = node.getEnd();
                s.setStart(startAt);
                s.setEnd(endAt);
            }
        }
        Collections.sort(this._sections, PropertyNode.StartComparator.instance);
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._sections.size();
        SEPX sepx = this._sections.get(listIndex);
        sepx.setEnd(sepx.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            sepx = this._sections.get(x);
            sepx.setStart(sepx.getStart() + length);
            sepx.setEnd(sepx.getEnd() + length);
        }
    }

    public List<SEPX> getSections() {
        return this._sections;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem sys, int fcMin) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        this.writeTo(docStream, tableStream);
    }

    public void writeTo(HWPFOutputStream wordDocumentStream, HWPFOutputStream tableStream) throws IOException {
        int offset = wordDocumentStream.getOffset();
        int len = this._sections.size();
        PlexOfCps plex = new PlexOfCps(12);
        for (int x = 0; x < len; ++x) {
            SEPX sepx = this._sections.get(x);
            byte[] grpprl = sepx.getGrpprl();
            byte[] shortBuf = new byte[2];
            LittleEndian.putShort((byte[])shortBuf, (int)0, (short)((short)grpprl.length));
            wordDocumentStream.write(shortBuf);
            wordDocumentStream.write(grpprl);
            SectionDescriptor sed = sepx.getSectionDescriptor();
            sed.setFc(offset);
            GenericPropertyNode property = new GenericPropertyNode(sepx.getStart(), sepx.getEnd(), sed.toByteArray());
            plex.addProperty(property);
            offset = wordDocumentStream.getOffset();
        }
        tableStream.write(plex.toByteArray());
    }
}

