/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.util.ZipArchiveThresholdInputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Removal;

@Internal
public class ZipSecureFile
extends ZipFile {
    private static final Logger LOG = LogManager.getLogger(ZipSecureFile.class);
    static double MIN_INFLATE_RATIO = 0.01;
    static final long DEFAULT_MAX_ENTRY_SIZE = 0xFFFFFFFFL;
    static final long DEFAULT_MAX_FILE_COUNT = 1000L;
    static final long DEFAULT_GRACE_ENTRY_SIZE = 102400L;
    static long MAX_ENTRY_SIZE = 0xFFFFFFFFL;
    static long MAX_FILE_COUNT = 1000L;
    static long GRACE_ENTRY_SIZE = 102400L;
    static final long DEFAULT_MAX_TEXT_SIZE = 0xA00000L;
    private static long MAX_TEXT_SIZE = 0xA00000L;
    public static final String MAX_FILE_COUNT_MSG = "The file appears to be potentially malicious. This file embeds more internal file entries than expected.\nThis may indicates that the file could pose a security risk.\nYou can adjust this limit via ZipSecureFile.setMaxFileCount() if you need to work with files which are very large.\nLimits: MAX_FILE_COUNT: %d";
    private final String fileName;

    public static void setMinInflateRatio(double ratio) {
        MIN_INFLATE_RATIO = ratio;
    }

    public static double getMinInflateRatio() {
        return MIN_INFLATE_RATIO;
    }

    public static long getMaxFileCount() {
        return MAX_FILE_COUNT;
    }

    public static void setMaxFileCount(long maxFileCount) {
        MAX_FILE_COUNT = maxFileCount;
    }

    public static void setMaxEntrySize(long maxEntrySize) {
        if (maxEntrySize < 0L) {
            throw new IllegalArgumentException("Max entry size must be greater than or equal to zero");
        }
        if (maxEntrySize > 0xFFFFFFFFL) {
            LOG.warn("setting max entry size greater than 4Gb can be risky; set to {} bytes", (Object)maxEntrySize);
        }
        MAX_ENTRY_SIZE = maxEntrySize;
    }

    public static long getMaxEntrySize() {
        return MAX_ENTRY_SIZE;
    }

    public static void setGraceEntrySize(long graceEntrySize) {
        if (graceEntrySize < 0L) {
            throw new IllegalArgumentException("Grace entry size must be greater than or equal to zero");
        }
        GRACE_ENTRY_SIZE = graceEntrySize;
    }

    public static long getGraceEntrySize() {
        return GRACE_ENTRY_SIZE;
    }

    public static void setMaxTextSize(long maxTextSize) {
        if (maxTextSize < 0L) {
            throw new IllegalArgumentException("Max text size must be greater than or equal to zero");
        }
        if (maxTextSize > 0xA00000L) {
            LOG.warn("setting max text size greater than {} can be risky; set to {} chars", (Object)0xA00000L, (Object)maxTextSize);
        }
        MAX_TEXT_SIZE = maxTextSize;
    }

    public static long getMaxTextSize() {
        return MAX_TEXT_SIZE;
    }

    public ZipSecureFile(File file) throws IOException {
        super(file);
        this.fileName = file.getAbsolutePath();
    }

    public ZipSecureFile(String name) throws IOException {
        super(name);
        this.fileName = new File(name).getAbsolutePath();
    }

    public ZipArchiveThresholdInputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        ZipArchiveThresholdInputStream zatis = new ZipArchiveThresholdInputStream(super.getInputStream(entry));
        zatis.setEntry(entry);
        return zatis;
    }

    @Removal(version="7.0.0")
    public String getName() {
        return this.fileName;
    }
}

