/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookFactory {
    public static Workbook create(POIFSFileSystem fs) throws IOException {
        return new HSSFWorkbook(fs);
    }

    public static Workbook create(NPOIFSFileSystem fs) throws IOException {
        try {
            return WorkbookFactory.create(fs, null);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Workbook create(NPOIFSFileSystem fs, String password) throws IOException, InvalidFormatException {
        DirectoryNode root = fs.getRoot();
        if (root.hasEntry("EncryptedPackage")) {
            InputStream stream = DocumentFactoryHelper.getDecryptedStream((NPOIFSFileSystem)fs, (String)password);
            OPCPackage pkg = OPCPackage.open(stream);
            return WorkbookFactory.create(pkg);
        }
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword((String)password);
        }
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(root, true);
            return hSSFWorkbook;
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public static Workbook create(OPCPackage pkg) throws IOException {
        return new XSSFWorkbook(pkg);
    }

    public static Workbook create(InputStream inp) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(inp, null);
    }

    public static Workbook create(InputStream inp, String password) throws IOException, InvalidFormatException, EncryptedDocumentException {
        byte[] header8;
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader((byte[])(header8 = IOUtils.peekFirst8Bytes((InputStream)inp)))) {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(inp);
            return WorkbookFactory.create(fs, password);
        }
        if (DocumentFactoryHelper.hasOOXMLHeader((InputStream)inp)) {
            return new XSSFWorkbook(OPCPackage.open(inp));
        }
        throw new InvalidFormatException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static Workbook create(File file) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, null);
    }

    public static Workbook create(File file, String password) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, password, false);
    }

    public static Workbook create(File file, String password, boolean readOnly) throws IOException, InvalidFormatException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(file, readOnly);
            try {
                return WorkbookFactory.create(fs, password);
            }
            catch (RuntimeException e) {
                IOUtils.closeQuietly((Closeable)fs);
                throw e;
            }
        }
        catch (OfficeXmlFileException e) {
            OPCPackage pkg = OPCPackage.open(file, readOnly ? PackageAccess.READ : PackageAccess.READ_WRITE);
            try {
                return new XSSFWorkbook(pkg);
            }
            catch (Exception ioe) {
                pkg.revert();
                if (ioe instanceof IOException) {
                    throw (IOException)ioe;
                }
                if (ioe instanceof RuntimeException) {
                    throw (RuntimeException)ioe;
                }
                throw new IOException(ioe);
            }
        }
    }
}

