/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.spreadsheet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.openxml4j.document.OpenXMLDocument;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackagingURIHelper;

public class ExcelDocument
extends OpenXMLDocument {
    public static final String MAIN_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
    public static final String SHEET_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
    public static final String SHARED_STRINGS_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
    private Document workbook;
    private List<Element> sheets;
    private PackagePart workbookPart;

    public ExcelDocument(Package container) throws Exception {
        super(container);
        this.openWorkbook();
        this.sheets = this.workbook.getRootElement().element("sheets").elements("sheet");
    }

    public Document _getWorkbook() {
        return this.workbook;
    }

    public String[] getSheetNames() {
        String[] names = new String[this.sheets.size()];
        int i = 0;
        for (Element s : this.sheets) {
            names[i] = s.attributeValue("name");
            ++i;
        }
        return names;
    }

    public Document getSheet(String sheetName) throws OpenXML4JException {
        Element sheetDef = null;
        for (Element s : this.sheets) {
            if (!s.attributeValue("name").equals(sheetName)) continue;
            sheetDef = s;
        }
        if (sheetDef == null) {
            throw new IllegalArgumentException("No sheet with name '" + sheetName + "'");
        }
        String relId = sheetDef.attributeValue("id");
        PackageRelationship rel = this.workbookPart.getRelationship(relId);
        PackagePartName relName = PackagingURIHelper.createPartName(rel.getTargetURI());
        PackagePart sheet = this.container.getPart(relName);
        if (sheet == null) {
            throw new OpenXML4JException("No part found for rel " + rel);
        }
        try {
            SAXReader reader = new SAXReader();
            return reader.read(sheet.getInputStream());
        }
        catch (DocumentException e) {
            throw new OpenXML4JException(e.getMessage());
        }
        catch (IOException io) {
            throw new OpenXML4JException(io.getMessage());
        }
    }

    public String getText() throws OpenXML4JException {
        int i;
        String[] sheetNames = this.getSheetNames();
        Document[] sheetDocs = new Document[sheetNames.length];
        for (i = 0; i < sheetDocs.length; ++i) {
            sheetDocs[i] = this.getSheet(sheetNames[i]);
        }
        for (i = 0; i < sheetDocs.length; ++i) {
        }
        return null;
    }

    private void openWorkbook() throws Exception {
        ArrayList<PackagePart> wbs = this.container.getPartsByContentType(MAIN_CONTENT_TYPE);
        if (wbs.size() != 1) {
            throw new OpenXML4JException("Expecting one entry with content type of application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml, but found " + wbs.size());
        }
        this.workbookPart = wbs.get(0);
        try {
            SAXReader reader = new SAXReader();
            this.workbook = reader.read(this.workbookPart.getInputStream());
        }
        catch (DocumentException e) {
            throw new OpenXML4JException(e.getMessage());
        }
    }
}

