/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.rawsocket;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.transport.rawsocket.RawSocketChannelFactory;
import org.apache.plc4x.java.transport.rawsocket.RawSocketTransportConfiguration;
import org.apache.plc4x.java.utils.rawsockets.netty.address.RawSocketAddress;

public class RawSocketTransport
implements Transport,
HasConfiguration<RawSocketTransportConfiguration> {
    private static final Pattern TRANSPORT_RAW_SOCKET_IP_PATTERN = Pattern.compile("^((?<ip>[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})|(?<hostname>[a-zA-Z0-9.\\-]+))(:(?<port>[0-9]{1,5}))?");
    private static final Pattern TRANSPORT_RAW_SOCKET_MAC_PATTERN = Pattern.compile("^(?<macAddress>[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2})");
    public static final String TRANSPORT_CODE = "raw";
    private RawSocketTransportConfiguration configuration;

    public String getTransportCode() {
        return TRANSPORT_CODE;
    }

    public String getTransportName() {
        return "Raw Ethernet Transport";
    }

    public void setConfiguration(RawSocketTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory createChannelFactory(String transportConfig) {
        int port;
        Matcher macMatcher = TRANSPORT_RAW_SOCKET_MAC_PATTERN.matcher(transportConfig);
        if (macMatcher.matches()) {
            String macAddressString = macMatcher.group("macAddress");
            try {
                byte[] macAddress = Hex.decodeHex((String)macAddressString.replace(":", ""));
                RawSocketAddress address = new RawSocketAddress(macAddress);
                return new RawSocketChannelFactory((SocketAddress)address);
            }
            catch (DecoderException e) {
                throw new RuntimeException(e);
            }
        }
        Matcher ipMatcher = TRANSPORT_RAW_SOCKET_IP_PATTERN.matcher(transportConfig);
        if (!ipMatcher.matches()) {
            throw new PlcRuntimeException("Invalid url for Raw socket transport");
        }
        String ip = ipMatcher.group("ip");
        String hostname = ipMatcher.group("hostname");
        String portString = ipMatcher.group("port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        } else if (this.configuration != null && this.configuration.getDefaultPort() != -1) {
            port = this.configuration.getDefaultPort();
        } else {
            throw new PlcRuntimeException("No port defined");
        }
        InetSocketAddress address = new InetSocketAddress(ip == null ? hostname : ip, port);
        return new RawSocketChannelFactory(address);
    }
}

