/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcWCHAR
extends PlcIECValue<Integer> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    public static final Integer MIN_VALUE = 0;
    public static final Integer MAX_VALUE = 65535;

    public static PlcWCHAR of(Object value) {
        if (value instanceof PlcWCHAR) {
            return (PlcWCHAR)value;
        }
        if (value instanceof Boolean) {
            return new PlcWCHAR((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcWCHAR((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcWCHAR((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcWCHAR((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcWCHAR((Long)value);
        }
        if (value instanceof Float) {
            return new PlcWCHAR((Float)value);
        }
        if (value instanceof Double) {
            return new PlcWCHAR((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcWCHAR((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcWCHAR((BigDecimal)value);
        }
        return new PlcWCHAR(value.toString());
    }

    public PlcWCHAR(Boolean value) {
        this.value = value != false ? 84 : 70;
        this.isNullable = false;
    }

    public PlcWCHAR(Byte value) {
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Character value) {
        char val = value.charValue();
        if (val < MIN_VALUE || val > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = (int)val;
        this.isNullable = false;
    }

    public PlcWCHAR(Short value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Integer value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcWCHAR(Long value) {
        if (value < (long)MIN_VALUE.intValue() || value > (long)MAX_VALUE.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Float value) {
        if (value.floatValue() < (float)MIN_VALUE.intValue() || value.floatValue() > (float)MAX_VALUE.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Double value) {
        if (value < (double)MIN_VALUE.intValue() || value > (double)MAX_VALUE.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(MIN_VALUE.intValue())) < 0 || value.compareTo(BigInteger.valueOf(MAX_VALUE.intValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = true;
    }

    public PlcWCHAR(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(MIN_VALUE.intValue())) < 0 || value.compareTo(BigDecimal.valueOf(MAX_VALUE.intValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = true;
    }

    public PlcWCHAR(String value) {
        try {
            char val;
            String s = value.trim();
            if (s.isEmpty()) {
                s = " ";
            }
            if ((val = s.charAt(0)) < MIN_VALUE || val > MAX_VALUE) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
            }
            this.value = (int)val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcWCHAR(int value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.WCHAR;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Integer)this.value).equals(0);
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Integer)this.value <= 127 && (Integer)this.value >= -128;
    }

    @Override
    public byte getByte() {
        return ((Integer)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && (Integer)this.value <= Short.MAX_VALUE && (Integer)this.value >= Short.MIN_VALUE;
    }

    @Override
    public short getShort() {
        return ((Integer)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return (Integer)this.value;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return ((Integer)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Integer)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Integer)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public Object getObject() {
        return Character.toString((char)((Integer)this.value).intValue());
    }

    public String toString() {
        return Character.toString((char)((Integer)this.value).intValue());
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        return new byte[]{(byte)((Integer)this.value >> 8 & 0xFF), (byte)((Integer)this.value & 0xFF)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((Integer)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), 16, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

