/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcUINT
extends PlcIECValue<Integer> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    public static final Integer MIN_VALUE = 0;
    public static final Integer MAX_VALUE = 65535;

    public static PlcUINT of(Object value) {
        if (value instanceof PlcUINT) {
            return (PlcUINT)value;
        }
        if (value instanceof Boolean) {
            return new PlcUINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcUINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcUINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcUINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcUINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcUINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcUINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcUINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcUINT((BigDecimal)value);
        }
        return new PlcUINT(value.toString());
    }

    public PlcUINT(Boolean value) {
        this.value = value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        this.isNullable = false;
    }

    public PlcUINT(Byte value) {
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcUINT(Short value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcUINT(Integer value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcUINT(Long value) {
        if (value < (long)MIN_VALUE.intValue() || value > (long)MAX_VALUE.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcUINT(Float value) {
        if (value.floatValue() < (float)MIN_VALUE.intValue() || value.floatValue() > (float)MAX_VALUE.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcUINT(Double value) {
        if (value < (double)MIN_VALUE.intValue() || value > (double)MAX_VALUE.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcUINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(MIN_VALUE.intValue())) < 0 || value.compareTo(BigInteger.valueOf(MAX_VALUE.intValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = true;
    }

    public PlcUINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(MIN_VALUE.intValue())) < 0 || value.compareTo(BigDecimal.valueOf(MAX_VALUE.intValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = true;
    }

    public PlcUINT(String value) {
        try {
            int val = Integer.parseInt(value.trim());
            if (val < MIN_VALUE || val > MAX_VALUE) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
    }

    public PlcUINT(int value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.UINT;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Integer)this.value).equals(0);
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Integer)this.value <= 127 && (Integer)this.value >= -128;
    }

    @Override
    public byte getByte() {
        return ((Integer)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && (Integer)this.value <= Short.MAX_VALUE && (Integer)this.value >= Short.MIN_VALUE;
    }

    @Override
    public short getShort() {
        return ((Integer)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return (Integer)this.value;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return ((Integer)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Integer)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Integer)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Integer.toString((Integer)this.value);
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        return new byte[]{(byte)((Integer)this.value >> 8 & 0xFF), (byte)((Integer)this.value & 0xFF)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeInt(this.getClass().getSimpleName(), 16, (Integer)this.value, new WithWriterArgs[0]);
    }
}

