/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcLTIME
extends PlcIECValue<Duration> {
    public static PlcLTIME of(Object value) {
        if (value instanceof PlcLTIME) {
            return (PlcLTIME)value;
        }
        if (value instanceof Duration) {
            return new PlcLTIME((Duration)value);
        }
        if (value instanceof Byte) {
            return new PlcLTIME((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLTIME((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLTIME((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLTIME((Long)value);
        }
        if (value instanceof Float) {
            return new PlcLTIME((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLTIME((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLTIME((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLTIME((BigDecimal)value);
        }
        return new PlcLTIME(Duration.parse(value.toString()));
    }

    public static PlcLTIME ofNanoseconds(long nanoseconds) {
        return new PlcLTIME(Duration.ofNanos(nanoseconds));
    }

    public static PlcLTIME ofNanoseconds(BigInteger nanoseconds) {
        return new PlcLTIME(Duration.ofNanos(nanoseconds.longValue()));
    }

    public PlcLTIME(Byte nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.byteValue());
        this.isNullable = false;
    }

    public PlcLTIME(Short nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.shortValue());
        this.isNullable = false;
    }

    public PlcLTIME(Integer nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.intValue());
        this.isNullable = false;
    }

    public PlcLTIME(Long nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds);
        this.isNullable = false;
    }

    public PlcLTIME(Float nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.longValue());
        this.isNullable = false;
    }

    public PlcLTIME(Double nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.longValue());
        this.isNullable = false;
    }

    public PlcLTIME(BigInteger nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.longValue());
        this.isNullable = false;
    }

    public PlcLTIME(BigDecimal nanoseconds) {
        this.value = Duration.ofNanos(nanoseconds.longValue());
        this.isNullable = false;
    }

    public PlcLTIME(Duration value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.LTIME;
    }

    public long getNanoseconds() {
        return ((Duration)this.value).toNanos();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return true;
    }

    @Override
    public int getInteger() {
        return (int)(((Duration)this.value).get(ChronoUnit.NANOS) / 1000000L);
    }

    @Override
    public long getLong() {
        return ((Duration)this.value).get(ChronoUnit.NANOS);
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(((Duration)this.value).get(ChronoUnit.NANOS));
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.value;
    }

    @Override
    public String getString() {
        return ((Duration)this.value).toString();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((Duration)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

