/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcLREAL
extends PlcIECValue<Double> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %f - %f for a %s Value";
    public static final Double MIN_VALUE = -1.7976931348623157E308;
    public static final Double MAX_VALUE = Double.MAX_VALUE;

    public static PlcLREAL of(Object value) {
        if (value instanceof PlcLREAL) {
            return (PlcLREAL)value;
        }
        if (value instanceof Boolean) {
            return new PlcLREAL((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcLREAL((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLREAL((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLREAL((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLREAL((Long)value);
        }
        if (value instanceof Float) {
            return new PlcLREAL((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLREAL((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLREAL((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLREAL((BigDecimal)value);
        }
        return new PlcLREAL(value.toString());
    }

    public PlcLREAL(Boolean value) {
        this.value = value != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
        this.isNullable = false;
    }

    public PlcLREAL(Byte value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Short value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Integer value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Long value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Float value) {
        this.value = value.doubleValue();
        this.isNullable = false;
    }

    public PlcLREAL(Double value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcLREAL(BigInteger value) {
        BigDecimal val = new BigDecimal(value);
        if (val.compareTo(BigDecimal.valueOf(MIN_VALUE)) < 0 || val.compareTo(BigDecimal.valueOf(MAX_VALUE)) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = val.doubleValue();
        this.isNullable = true;
    }

    public PlcLREAL(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(MIN_VALUE)) < 0 || value.compareTo(BigDecimal.valueOf(MAX_VALUE)) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
        this.value = value.doubleValue();
        this.isNullable = true;
    }

    public PlcLREAL(String value) {
        try {
            this.value = Double.parseDouble(value.trim());
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, MIN_VALUE, MAX_VALUE, this.getClass().getSimpleName()));
        }
    }

    public PlcLREAL(double value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.LREAL;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Double)this.value).equals(0.0);
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Double)this.value <= 127.0 && (Double)this.value >= -128.0;
    }

    @Override
    public byte getByte() {
        return ((Double)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && (Double)this.value <= 32767.0 && (Double)this.value >= -32768.0;
    }

    @Override
    public short getShort() {
        return ((Double)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return this.value != null && (Double)this.value <= 2.147483647E9 && (Double)this.value >= -2.147483648E9;
    }

    @Override
    public int getInteger() {
        return ((Double)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return this.value != null && (Double)this.value <= 9.223372036854776E18 && (Double)this.value >= -9.223372036854776E18;
    }

    @Override
    public long getLong() {
        return ((Double)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return this.value != null && (Double)this.value <= 3.4028234663852886E38 && (Double)this.value >= -3.4028234663852886E38;
    }

    @Override
    public float getFloat() {
        return ((Double)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return (Double)this.value;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal((Double)this.value);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Double.toString((Double)this.value);
    }

    @Override
    public byte[] getRaw() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        long longBits = Double.doubleToRawLongBits((Double)this.value);
        return new byte[]{(byte)(longBits >> 56 & 0xFFL), (byte)(longBits >> 48 & 0xFFL), (byte)(longBits >> 40 & 0xFFL), (byte)(longBits >> 32 & 0xFFL), (byte)(longBits >> 24 & 0xFFL), (byte)(longBits >> 16 & 0xFFL), (byte)(longBits >> 8 & 0xFFL), (byte)(longBits & 0xFFL)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeDouble(this.getClass().getSimpleName(), 64, (Double)this.value, new WithWriterArgs[0]);
    }
}

