/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.utils.ascii;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.utils.ascii.AsciiBox;
import org.apache.plc4x.java.spi.utils.ascii.BoxSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiBoxWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(AsciiBoxWriter.class);
    public static final AsciiBoxWriter DEFAULT = new AsciiBoxWriter();
    public static final AsciiBoxWriter LIGHT = new AsciiBoxWriter("\u256d", "\u256e", "\u2504", "\u2506", "\u2570", "\u256f");
    final BoxSet boxSet;
    final String newLine;
    final String emptyPadding;
    final int extraNameCharIndent;
    final int borderWidth;
    final int newLineCharWidth;
    final Pattern boxNameRegex;

    public AsciiBoxWriter() {
        this("\u2554", "\u2557", "\u2550", "\u2551", "\u255a", "\u255d");
    }

    public AsciiBoxWriter(String upperLeftCorner, String upperRightCorner, String horizontalLine, String verticalLine, String lowerLeftCorner, String lowerRightCorner) {
        this.boxSet = new BoxSet(upperLeftCorner, upperRightCorner, horizontalLine, verticalLine, lowerLeftCorner, lowerRightCorner);
        this.newLine = "\n";
        this.emptyPadding = " ";
        this.extraNameCharIndent = 1;
        this.borderWidth = 1;
        this.newLineCharWidth = 1;
        this.boxNameRegex = Pattern.compile("^" + upperLeftCorner + horizontalLine + "(?<name>[\\w /]+)" + horizontalLine + "*" + upperRightCorner);
    }

    public AsciiBox boxBox(String name, AsciiBox box, int charWidth) {
        AsciiBox asciiBox = this.boxString(name, box.toString(), charWidth);
        asciiBox.compressedBoxSet = this.boxSet.contributeToCompressedBoxSet(box);
        return asciiBox;
    }

    public AsciiBox boxString(String name, String data, int charWidth) {
        Objects.requireNonNull(data);
        data = data.replaceAll("\r\n", "\n");
        data = data.replaceAll("\t", "  ");
        AsciiBox rawBox = new AsciiBox(this, data);
        int longestLine = rawBox.width();
        if (charWidth < longestLine) {
            this.LOGGER.trace("Overflow by {} chars", (Object)(longestLine - charWidth));
            charWidth = longestLine + this.borderWidth + this.borderWidth;
        }
        StringBuilder boxedString = new StringBuilder();
        int namePadding = Math.max(charWidth - name.length() - this.borderWidth - this.extraNameCharIndent - this.borderWidth, 0);
        boxedString.append(this.boxSet.upperLeftCorner).append(this.boxSet.horizontalLine).append(name).append(StringUtils.repeat((String)this.boxSet.horizontalLine, (int)namePadding)).append(this.boxSet.upperRightCorner).append(this.newLine);
        charWidth = this.borderWidth + this.extraNameCharIndent + name.length() + namePadding + this.borderWidth;
        String[] stringArray = rawBox.lines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int linePadding = charWidth - 2 - line.length();
            if (linePadding < 0) {
                linePadding = 0;
            }
            int frontPadding = (int)Math.floor((double)linePadding / 2.0);
            int backPadding = (int)Math.ceil((double)linePadding / 2.0);
            boxedString.append(this.boxSet.verticalLine).append(StringUtils.repeat((String)this.emptyPadding, (int)frontPadding)).append(line).append(StringUtils.repeat((String)this.emptyPadding, (int)backPadding)).append(this.boxSet.verticalLine).append(this.newLine);
            ++n2;
        }
        int bottomPadding = namePadding + name.length() + this.extraNameCharIndent;
        boxedString.append(this.boxSet.lowerLeftCorner).append(StringUtils.repeat((String)this.boxSet.horizontalLine, (int)bottomPadding)).append(this.boxSet.lowerRightCorner);
        return new AsciiBox(this, boxedString.toString());
    }

    public AsciiBox alignBoxes(Collection<AsciiBox> boxes, int desiredWidth) {
        if (boxes.size() == 0) {
            return new AsciiBox(this, "");
        }
        int actualWidth = desiredWidth;
        for (AsciiBox box : boxes) {
            int boxWidth = box.width();
            if (boxWidth <= actualWidth) continue;
            this.LOGGER.trace("Overflow by {} chars", (Object)(boxWidth - desiredWidth));
            actualWidth = boxWidth;
        }
        this.LOGGER.trace("Working with {} chars", (Object)actualWidth);
        AsciiBox bigBox = new AsciiBox(this, "");
        LinkedList<AsciiBox> currentBoxRow = new LinkedList<AsciiBox>();
        int currentRowLength = 0;
        for (AsciiBox box : boxes) {
            if ((currentRowLength += box.width()) > actualWidth) {
                AsciiBox mergedBoxes = this.mergeHorizontal(currentBoxRow);
                bigBox = StringUtils.isBlank((CharSequence)bigBox.toString()) ? mergedBoxes : this.boxBelowBox(bigBox, mergedBoxes);
                currentRowLength = box.width();
                currentBoxRow = new LinkedList();
            }
            currentBoxRow.add(box);
        }
        if (currentBoxRow.size() > 0) {
            AsciiBox mergedBoxes = this.mergeHorizontal(currentBoxRow);
            bigBox = StringUtils.isBlank((CharSequence)bigBox.toString()) ? mergedBoxes : this.boxBelowBox(bigBox, mergedBoxes);
        }
        return bigBox;
    }

    public AsciiBox boxSideBySide(AsciiBox box1, AsciiBox box2) {
        StringBuilder aggregateBox = new StringBuilder();
        int box1Width = box1.width();
        String[] box1Lines = box1.lines();
        int box2Width = box2.width();
        String[] box2Lines = box2.lines();
        int maxRows = Math.max(box1Lines.length, box2Lines.length);
        int row = 0;
        while (row < maxRows) {
            int padding;
            boolean ranOutOfLines = false;
            if (row >= box1Lines.length) {
                ranOutOfLines = true;
                aggregateBox.append(StringUtils.repeat((String)" ", (int)box1Width));
            } else {
                String split1Row = box1Lines[row];
                padding = box1Width - split1Row.length();
                aggregateBox.append(split1Row).append(StringUtils.repeat((String)" ", (int)padding));
            }
            if (row >= box2Lines.length) {
                if (ranOutOfLines) break;
                aggregateBox.append(StringUtils.repeat((String)" ", (int)box2Width));
            } else {
                String split2Row = box2Lines[row];
                padding = box2Width - split2Row.length();
                aggregateBox.append(split2Row).append(StringUtils.repeat((String)" ", (int)padding));
            }
            if (row < maxRows - 1) {
                aggregateBox.append('\n');
            }
            ++row;
        }
        AsciiBox asciiBox = new AsciiBox(aggregateBox.toString());
        asciiBox.compressedBoxSet = BoxSet.combineCompressedBoxSets(box1, box2);
        return asciiBox;
    }

    public AsciiBox boxBelowBox(AsciiBox box1, AsciiBox box2) {
        int box2Width;
        int box1Width = box1.width();
        if (box1Width < (box2Width = box2.width())) {
            box1 = this.expandBox(box1, box2Width);
        } else if (box2Width < box1Width) {
            box2 = this.expandBox(box2, box1Width);
        }
        AsciiBox asciiBox = new AsciiBox(String.valueOf(box1.toString()) + "\n" + box2.toString());
        asciiBox.compressedBoxSet = BoxSet.combineCompressedBoxSets(box1, box2);
        return asciiBox;
    }

    AsciiBox mergeHorizontal(List<AsciiBox> boxes) {
        switch (boxes.size()) {
            case 0: {
                return new AsciiBox("");
            }
            case 1: {
                return boxes.get(0);
            }
            case 2: {
                return this.boxSideBySide(boxes.get(0), boxes.get(1));
            }
        }
        return this.boxSideBySide(boxes.get(0), this.mergeHorizontal(new ArrayList<AsciiBox>(boxes).subList(1, boxes.size())));
    }

    AsciiBox expandBox(AsciiBox box, int desiredWidth) {
        if (box.width() >= desiredWidth) {
            return box;
        }
        String[] boxLines = box.lines();
        int numberOfLine = boxLines.length;
        int boxWidth = box.width();
        String padding = StringUtils.repeat((String)" ", (int)(desiredWidth - boxWidth));
        StringBuilder newBox = new StringBuilder();
        int i = 0;
        while (i < boxLines.length) {
            String line = boxLines[i];
            newBox.append(line);
            newBox.append(padding);
            if (i < numberOfLine - 1) {
                newBox.append(this.newLine);
            }
            ++i;
        }
        AsciiBox asciiBox = new AsciiBox(this, newBox.toString());
        asciiBox.compressedBoxSet = this.boxSet.contributeToCompressedBoxSet(box);
        return asciiBox;
    }

    public boolean hasBorders(AsciiBox box) {
        if (StringUtils.isBlank((CharSequence)box.toString())) {
            return false;
        }
        return this.boxSet.upperLeftCorner.equals(box.toString().substring(0, 1));
    }

    public AsciiBox unwrap(AsciiBox box) {
        if (!this.hasBorders(box)) {
            return box;
        }
        String[] originalLines = box.lines();
        Object[] newLines = new String[originalLines.length - 2];
        String completeBoxSet = this.boxSet.contributeToCompressedBoxSet(box);
        int i = 0;
        while (i < originalLines.length) {
            String line = originalLines[i];
            if (i != 0) {
                if (i == originalLines.length - 1) break;
                String unwrappedLine = line.substring(1, line.length() - 1);
                if (!StringUtils.containsAny((CharSequence)unwrappedLine, (CharSequence)completeBoxSet.replaceAll(",", ""))) {
                    unwrappedLine = StringUtils.trim((String)unwrappedLine);
                }
                newLines[i - 1] = unwrappedLine;
            }
            ++i;
        }
        AsciiBox asciiBox = new AsciiBox(StringUtils.join((Object[])newLines, (String)this.newLine));
        asciiBox.compressedBoxSet = completeBoxSet;
        return asciiBox;
    }
}

