/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcSubscriptionRequest
implements PlcSubscriptionRequest,
Serializable {
    private final PlcSubscriber subscriber;
    private final LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>> tags;
    private final Consumer<PlcSubscriptionEvent> consumer;
    private final Map<String, Consumer<PlcSubscriptionEvent>> tagConsumers;

    public DefaultPlcSubscriptionRequest(PlcSubscriber subscriber, LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>> tags, Consumer<PlcSubscriptionEvent> consumer, Map<String, Consumer<PlcSubscriptionEvent>> tagConsumers) {
        this.subscriber = subscriber;
        this.tags = tags;
        this.consumer = consumer;
        this.tagConsumers = tagConsumers;
    }

    public CompletableFuture<PlcSubscriptionResponse> execute() {
        return this.subscriber.subscribe(this);
    }

    public int getNumberOfTags() {
        return this.tags.size();
    }

    public LinkedHashSet<String> getTagNames() {
        return new LinkedHashSet<String>(this.tags.keySet());
    }

    public PlcSubscriptionTag getTag(String tagName) {
        return this.tags.get(tagName).getTag();
    }

    public PlcResponseCode getTagResponseCode(String tagName) {
        return this.tags.get(tagName).getResponseCode();
    }

    public List<PlcSubscriptionTag> getTags() {
        return this.tags.values().stream().map(PlcTagItem::getTag).collect(Collectors.toCollection(LinkedList::new));
    }

    public Consumer<PlcSubscriptionEvent> getConsumer() {
        return this.consumer;
    }

    public Consumer<PlcSubscriptionEvent> getTagConsumer(String tagName) {
        return this.tagConsumers.get(tagName);
    }

    public Map<String, Consumer<PlcSubscriptionEvent>> getTagConsumers() {
        return this.tagConsumers;
    }

    public PlcSubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcSubscriptionRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("tags", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcTagItem<PlcSubscriptionTag>> tagEntry : this.tags.entrySet()) {
            String tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcTagItem<PlcSubscriptionTag> tag = tagEntry.getValue();
            if (!(tag instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Tag doesn't implement XmlSerializable");
            }
            ((Serializable)((Object)tag)).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("tags", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcSubscriptionRequest", new WithWriterArgs[0]);
    }

    public String toString() {
        return "DefaultPlcSubscriptionRequest{subscriber=" + this.subscriber + ", tags=" + this.tags + '}';
    }

    public static class Builder
    implements PlcSubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private final PlcTagHandler tagHandler;
        private final Map<String, BuilderItem> tags;
        private Consumer<PlcSubscriptionEvent> consumer;

        public Builder(PlcSubscriber subscriber, PlcTagHandler tagHandler) {
            this.subscriber = Objects.requireNonNull(subscriber);
            this.tagHandler = Objects.requireNonNull(tagHandler);
            this.tags = new TreeMap<String, BuilderItem>();
        }

        public PlcSubscriptionRequest.Builder setConsumer(Consumer<PlcSubscriptionEvent> consumer) {
            this.consumer = Objects.requireNonNull(consumer);
            return this;
        }

        public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval) {
            this.addCyclicTagAddress(name, tagAddress, pollingInterval, null);
            return this;
        }

        public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.CYCLIC, pollingInterval, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval) {
            this.addCyclicTag(name, tag, pollingInterval, null);
            return this;
        }

        public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CYCLIC, pollingInterval, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress) {
            this.addChangeOfStateTagAddress(name, tagAddress, null);
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.CHANGE_OF_STATE, consumer));
            return null;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag) {
            this.addChangeOfStateTag(name, tag, null);
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CHANGE_OF_STATE, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress) {
            this.addEventTagAddress(name, tagAddress, null);
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.EVENT, consumer));
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag) {
            this.addEventTag(name, tag, null);
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag, Consumer<PlcSubscriptionEvent> consumer) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.EVENT, consumer));
            return this;
        }

        public PlcSubscriptionRequest build() {
            LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>> parsedTags = new LinkedHashMap<String, PlcTagItem<PlcSubscriptionTag>>();
            LinkedHashMap<String, Consumer<PlcSubscriptionEvent>> tagConsumers = new LinkedHashMap<String, Consumer<PlcSubscriptionEvent>>();
            this.tags.forEach((name, builderItem) -> {
                PlcTag parsedTag = builderItem.tag.get();
                parsedTags.put((String)name, (PlcTagItem<PlcSubscriptionTag>)new DefaultPlcTagItem<DefaultPlcSubscriptionTag>(new DefaultPlcSubscriptionTag(builderItem.plcSubscriptionType, parsedTag, builderItem.duration)));
                if (builderItem.consumer != null) {
                    tagConsumers.put((String)name, builderItem.consumer);
                }
            });
            return new DefaultPlcSubscriptionRequest(this.subscriber, parsedTags, this.consumer, tagConsumers);
        }

        private static class BuilderItem {
            private final Supplier<PlcTag> tag;
            private final PlcSubscriptionType plcSubscriptionType;
            private final Duration duration;
            private final Consumer<PlcSubscriptionEvent> consumer;

            private BuilderItem(Supplier<PlcTag> tag, PlcSubscriptionType plcSubscriptionType, Consumer<PlcSubscriptionEvent> consumer) {
                this(tag, plcSubscriptionType, null, consumer);
            }

            private BuilderItem(Supplier<PlcTag> tag, PlcSubscriptionType plcSubscriptionType, Duration duration, Consumer<PlcSubscriptionEvent> consumer) {
                this.tag = tag;
                this.plcSubscriptionType = plcSubscriptionType;
                this.duration = duration;
                this.consumer = consumer;
            }
        }
    }
}

