/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.Message;

public class StaticHelper {
    public static int ARRAY_SIZE_IN_BYTES(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            int numBytes = 0;
            for (Object element : list) {
                if (!(element instanceof Message)) {
                    throw new RuntimeException("Array elements for array size in bytes must implement Message interface");
                }
                numBytes += ((Message)element).getLengthInBytes();
            }
            return numBytes;
        }
        if (obj.getClass().isArray() && !obj.getClass().getComponentType().isPrimitive()) {
            Object[] arr = (Object[])obj;
            int numBytes = 0;
            Object[] objectArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!(element instanceof Message)) {
                    throw new RuntimeException("Array elements for array size in bytes must implement Message interface");
                }
                numBytes += ((Message)element).getLengthInBytes();
                ++n2;
            }
            return numBytes;
        }
        throw new RuntimeException("Unable to calculate array size in bytes for type " + obj.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int COUNT(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj.getClass().getComponentType() != null && obj.getClass().getComponentType().isPrimitive()) {
                if (obj.getClass().getComponentType() == Boolean.TYPE) {
                    boolean[] arr = (boolean[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Byte.TYPE) {
                    byte[] arr = (byte[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Short.TYPE) {
                    short[] arr = (short[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Integer.TYPE) {
                    int[] arr = (int[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Long.TYPE) {
                    long[] arr = (long[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Float.TYPE) {
                    float[] arr = (float[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() != Double.TYPE) throw new PlcRuntimeException("Unable to count object of type " + obj.getClass().getName());
                double[] arr = (double[])obj;
                return arr.length;
            }
            Object[] arr = (Object[])obj;
            return arr.length;
        }
        if (!(obj instanceof Collection)) throw new PlcRuntimeException("Unable to count object of type " + obj.getClass().getName());
        Collection col = (Collection)obj;
        return col.size();
    }

    public static int STR_LEN(Object str) {
        if (str == null) {
            return 0;
        }
        if (str instanceof PlcValue) {
            PlcValue plcValue = (PlcValue)str;
            return plcValue.getString().length();
        }
        return str.toString().length();
    }

    public static <T> T CAST(Object obj, Class<T> clazz) {
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException e) {
            throw new PlcRuntimeException("Unable to cast object of type " + obj.getClass().getName() + " to " + clazz.getName());
        }
    }

    public static int CEIL(double value) {
        return (int)Math.ceil(value);
    }

    public static int PADCOUNT(Object obj, boolean hasNext) {
        return hasNext ? StaticHelper.COUNT(obj) : 0;
    }

    public static int GET_VARDUINT_LENGTH_IN_BITS(long value) {
        int curFieldLengthInBits = 0;
        long temp = value;
        do {
            curFieldLengthInBits += 8;
        } while ((temp >>>= 7) != 0L);
        return curFieldLengthInBits;
    }

    public static int GET_VARDINT_LENGTH_IN_BITS(long value) {
        int curFieldLengthInBits = 8;
        boolean positive = value >= 0L;
        long tmpValue = value;
        while (tmpValue >> 6 != (long)(positive ? 0 : -1)) {
            curFieldLengthInBits += 8;
            tmpValue >>= 7;
        }
        return curFieldLengthInBits;
    }

    public static int GET_VARDUINT_LENGTH_IN_BITS(BigInteger value) {
        int curFieldLengthInBits = 0;
        long temp = value.longValue();
        do {
            curFieldLengthInBits += 8;
        } while ((temp >>>= 7) != 0L);
        return curFieldLengthInBits;
    }
}

