/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class WriteBufferJsonBased
implements WriteBuffer,
BufferCommons,
AutoCloseable {
    public static final String PLC4X_ATTRIBUTE_FORMAT = "%s__plc4x_%s";
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final JsonGenerator generator;
    private int pos = 1;
    private int depth = 0;
    private final boolean doRenderAttr;

    public WriteBufferJsonBased() {
        this(true);
    }

    public WriteBufferJsonBased(boolean doRenderAttr) {
        this.doRenderAttr = doRenderAttr;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        JsonFactory jsonFactory = new JsonFactoryBuilder().build();
        try {
            this.generator = jsonFactory.createGenerator((OutputStream)this.byteArrayOutputStream);
            this.generator.useDefaultPrettyPrinter();
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
    }

    @Override
    public int getPos() {
        return this.pos / 8;
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        try {
            if (this.depth == 0) {
                this.generator.writeStartObject();
            }
            ++this.depth;
            if (this.isToBeRenderedAsList(writerArgs)) {
                this.generator.writeArrayFieldStart(sanitizedLogicalName);
            } else {
                if (this.generator.getOutputContext().inArray()) {
                    this.generator.writeStartObject();
                }
                this.generator.writeObjectFieldStart(sanitizedLogicalName);
            }
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "bit", 1, writerArgs);
            this.generator.writeBooleanField(sanitizedLogicalName, value);
        });
        this.move(1);
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "byte", 8, writerArgs);
            this.generator.writeStringField(sanitizedLogicalName, String.format("0x%02x", value));
        });
        this.move(8);
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        StringBuilder hexString = new StringBuilder("0x");
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            hexString.append(String.format("%02x", aByte));
            ++n2;
        }
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "byte", bytes.length * 8, writerArgs);
            this.generator.writeStringField(sanitizedLogicalName, hexString.toString());
        });
        this.move(8 * bytes.length);
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, (short)value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "uint", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, (short)value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "int", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeFloat(String logicalName, int bitLength, float value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "float", bitLength, writerArgs);
            this.generator.writeNumberField(logicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeDouble(String logicalName, int bitLength, double value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "float", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) throws SerializationException {
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "float", bitLength, writerArgs);
            this.generator.writeNumberField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void writeString(String logicalName, int bitLength, String value, WithWriterArgs ... writerArgs) throws SerializationException {
        String encoding = this.extractEncoding(writerArgs).orElse("UTF-8");
        String sanitizedLogicalName = this.sanitizeLogicalName(logicalName);
        this.wrapIfNecessary(() -> {
            this.writeAttr(sanitizedLogicalName, "string", bitLength, writerArgs);
            this.generator.writeStringField(String.format(PLC4X_ATTRIBUTE_FORMAT, sanitizedLogicalName, "encoding"), encoding);
            this.generator.writeStringField(sanitizedLogicalName, value);
        });
        this.move(bitLength);
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        try {
            if (this.isToBeRenderedAsList(writerArgs)) {
                this.generator.writeEndArray();
            } else {
                this.generator.writeEndObject();
                if (this.generator.getOutputContext().getParent().inArray()) {
                    this.generator.writeEndObject();
                }
            }
            --this.depth;
            if (this.depth == 0) {
                this.generator.writeEndObject();
                this.generator.flush();
            }
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    public void wrapIfNecessary(RunWrapped runnable) throws SerializationException {
        boolean inArray = this.generator.getOutputContext().inArray();
        if (inArray) {
            try {
                this.generator.writeStartObject();
            }
            catch (IOException e) {
                throw new SerializationException("Error opening wrap", e);
            }
        }
        try {
            runnable.run();
        }
        catch (IOException e) {
            throw new SerializationException("Error running wrap", e);
        }
        if (inArray) {
            try {
                this.generator.writeEndObject();
            }
            catch (IOException e) {
                throw new SerializationException("Error closing wrap", e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.generator.close();
    }

    public String getJsonString() {
        return this.byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }

    private void writeAttr(String logicalName, String dataType, int bitLength, WithWriterArgs ... writerArgs) throws IOException {
        if (!this.doRenderAttr) {
            return;
        }
        this.generator.writeStringField(String.format(PLC4X_ATTRIBUTE_FORMAT, logicalName, "dataType"), dataType);
        this.generator.writeNumberField(String.format(PLC4X_ATTRIBUTE_FORMAT, logicalName, "bitLength"), bitLength);
        Optional<String> stringRepresentation = this.extractAdditionalStringRepresentation(writerArgs);
        if (stringRepresentation.isPresent()) {
            this.generator.writeStringField(String.format(PLC4X_ATTRIBUTE_FORMAT, logicalName, "stringRepresentation"), stringRepresentation.get());
        }
    }

    private void move(int bits) {
        this.pos += bits;
    }

    @FunctionalInterface
    private static interface RunWrapped {
        public void run() throws IOException;
    }
}

