/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcWSTRING
extends PlcSimpleValue<String> {
    public static PlcWSTRING of(Object value) {
        if (value instanceof String) {
            return new PlcWSTRING((String)value);
        }
        return new PlcWSTRING(String.valueOf(value));
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcWSTRING(@JsonProperty(value="value") String value) {
        super(value, true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.WSTRING;
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return (String)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        try {
            Boolean.parseBoolean((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return Boolean.parseBoolean((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        try {
            Byte.parseByte((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return Byte.parseByte((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        try {
            Short.parseShort((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return Short.parseShort((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        try {
            Integer.parseInt((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return Integer.parseInt((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        try {
            Long.parseLong((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return Long.parseLong((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        try {
            new BigInteger((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return new BigInteger((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        try {
            Float.parseFloat((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return Float.parseFloat((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        try {
            Double.parseDouble((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return Double.parseDouble((String)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        try {
            new BigDecimal((String)this.value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal((String)this.value);
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return ((String)this.value).length();
    }

    @JsonIgnore
    public String toString() {
        return "\"" + (String)this.value + "\"";
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = (String)this.value;
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_16).length * 8, StandardCharsets.UTF_16.name(), valueString, new WithWriterArgs[0]);
    }
}

