/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlcValues {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlcValues.class);

    private PlcValues() {
    }

    public static PlcValue of(List<PlcValue> list) {
        return new PlcList(list);
    }

    public static PlcValue of(PlcValue ... items) {
        return new PlcList(Arrays.asList(items));
    }

    public static PlcValue of(String key, PlcValue value) {
        return new PlcStruct(Collections.singletonMap(key, value));
    }

    public static PlcValue of(Map<String, PlcValue> map) {
        return new PlcStruct(map);
    }

    public static PlcValue of(Object o) {
        if (o == null) {
            return new PlcNull();
        }
        try {
            String simpleName = o.getClass().getSimpleName();
            Class<Object> clazz = o.getClass();
            if (o instanceof List) {
                simpleName = "List";
                clazz = List.class;
            } else if (clazz.isArray()) {
                simpleName = "List";
                clazz = List.class;
                Object[] objectArray = (Object[])o;
                o = Arrays.asList(objectArray);
            }
            if (simpleName.equals("Boolean")) {
                simpleName = "Bool";
            }
            if (simpleName.startsWith("Local")) {
                simpleName = simpleName.substring(5);
            }
            Constructor<?> constructor = Class.forName(PlcValues.class.getPackage().getName() + ".Plc" + simpleName.toUpperCase()).getDeclaredConstructor(clazz);
            return (PlcValue)constructor.newInstance(o);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Cannot wrap", (Throwable)e);
            throw new PlcIncompatibleDatatypeException(o.getClass());
        }
    }
}

