/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcBYTE
extends PlcIECValue<Short> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static Short minValue = 0;
    static Short maxValue = 255;

    public static PlcBYTE of(Object value) {
        if (value instanceof Boolean) {
            return new PlcBYTE((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcBYTE((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcBYTE((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcBYTE((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcBYTE((Long)value);
        }
        if (value instanceof Float) {
            return new PlcBYTE((Float)value);
        }
        if (value instanceof Double) {
            return new PlcBYTE((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcBYTE((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcBYTE((BigDecimal)value);
        }
        return new PlcBYTE((String)value);
    }

    public PlcBYTE(Boolean value) {
        this.value = value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        this.isNullable = false;
    }

    public PlcBYTE(Byte value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcBYTE(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Long value) {
        if (value < (long)minValue.shortValue() || value > (long)maxValue.shortValue()) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Float value) {
        if (value.floatValue() < (float)minValue.shortValue() || value.floatValue() > (float)maxValue.shortValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(Double value) {
        if (value < (double)minValue.shortValue() || value > (double)maxValue.shortValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = false;
    }

    public PlcBYTE(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.shortValue())) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcBYTE(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.shortValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.shortValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.shortValue();
        this.isNullable = true;
    }

    public PlcBYTE(String value) {
        try {
            short val = Short.parseShort(value.trim());
            if (val < minValue || val > maxValue) {
                throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcBYTE(@JsonProperty(value="value") short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.BYTE;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Short)this.value).equals((short)0);
    }

    @JsonIgnore
    public boolean[] getBooleanArray() {
        boolean[] booleanValues = new boolean[8];
        BitSet bitSet = BitSet.valueOf(new long[]{((Short)this.value).shortValue()});
        for (int i = 0; i < 8; ++i) {
            booleanValues[i] = bitSet.get(i);
        }
        return booleanValues;
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Short)this.value <= 127 && (Short)this.value >= -128;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Short)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return true;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return (Short)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Short)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Short)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Short)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Short)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Short.toString((Short)this.value);
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Short)this.value & 0xFF)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeShort(this.getClass().getSimpleName(), 8, (Short)this.value, new WithWriterArgs[0]);
    }
}

