/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcWriteResponse
implements PlcWriteResponse,
Serializable {
    private final PlcWriteRequest request;
    private final Map<String, PlcResponseCode> responses;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcWriteResponse(@JsonProperty(value="request") PlcWriteRequest request, @JsonProperty(value="values") Map<String, PlcResponseCode> responses) {
        this.request = request;
        this.responses = responses;
    }

    public PlcWriteRequest getRequest() {
        return this.request;
    }

    @JsonIgnore
    public Collection<String> getFieldNames() {
        return this.request.getFieldNames();
    }

    @JsonIgnore
    public PlcField getField(String name) {
        return this.request.getField(name);
    }

    @JsonIgnore
    public PlcResponseCode getResponseCode(String name) {
        return this.responses.get(name);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcWriteResponse", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.pushContext("fields", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcResponseCode> fieldEntry : this.responses.entrySet()) {
            String fieldName = fieldEntry.getKey();
            PlcResponseCode fieldResponseCode = fieldEntry.getValue();
            String result = fieldResponseCode.name();
            writeBuffer.writeString(fieldName, result.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), result, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("fields", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcWriteResponse", new WithWriterArgs[0]);
    }
}

