/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcBrowseRequest
implements PlcBrowseRequest,
Serializable {
    private final PlcBrowser browser;
    private final LinkedHashMap<String, String> queries;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcBrowseRequest(@JsonProperty(value="browser") PlcBrowser browser, @JsonProperty(value="queries") LinkedHashMap<String, String> queries) {
        this.browser = browser;
        this.queries = queries;
    }

    @JsonIgnore
    public CompletableFuture<PlcBrowseResponse> execute() {
        return this.browser.browse(this);
    }

    @JsonIgnore
    public PlcBrowser getBrowser() {
        return this.browser;
    }

    @JsonIgnore
    public Map<String, String> getQueries() {
        return this.queries;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcBrowseRequest", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcBrowseRequest", new WithWriterArgs[0]);
    }

    public static class Builder
    implements PlcBrowseRequest.Builder {
        private final PlcBrowser browser;
        private final LinkedHashMap<String, String> queries;

        public Builder(PlcBrowser browser) {
            this.browser = browser;
            this.queries = new LinkedHashMap();
        }

        public Builder addQuery(String name, String query) {
            this.queries.put(name, query);
            return this;
        }

        public PlcBrowseRequest build() {
            return new DefaultPlcBrowseRequest(this.browser, this.queries);
        }
    }
}

