/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcBrowseItem;
import org.apache.plc4x.java.api.messages.PlcBrowseItemArrayInfo;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseItem;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultListPlcBrowseItem
extends DefaultPlcBrowseItem {
    private final List<PlcBrowseItemArrayInfo> arrayInfo;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultListPlcBrowseItem(@JsonProperty(value="address") String address, @JsonProperty(value="name") String name, @JsonProperty(value="dataType") PlcValueType dataType, @JsonProperty(value="arrayInfo") List<PlcBrowseItemArrayInfo> arrayInfo, @JsonProperty(value="readable") boolean readable, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="subscribable") boolean subscribable, @JsonProperty(value="children") List<PlcBrowseItem> children, @JsonProperty(value="options") Map<String, PlcValue> options) {
        super(address, name, dataType, readable, writable, subscribable, children, options);
        this.arrayInfo = arrayInfo;
    }

    public List<PlcBrowseItemArrayInfo> getArrayInfo() {
        return this.arrayInfo;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeString("address", this.getAddress().getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.getAddress(), new WithWriterArgs[0]);
        writeBuffer.writeString("name", this.getName().getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), this.getName(), new WithWriterArgs[0]);
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            writeBuffer.pushContext("children", new WithWriterArgs[0]);
            for (PlcBrowseItem plcBrowseItem : this.getChildren()) {
                writeBuffer.pushContext("child", new WithWriterArgs[0]);
                ((DefaultListPlcBrowseItem)plcBrowseItem).serialize(writeBuffer);
                writeBuffer.popContext("child", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("children", new WithWriterArgs[0]);
        }
        if (this.getOptions() != null && !this.getOptions().isEmpty()) {
            writeBuffer.pushContext("options", new WithWriterArgs[0]);
            for (Map.Entry entry : this.getOptions().entrySet()) {
                writeBuffer.pushContext("option", new WithWriterArgs[0]);
                writeBuffer.writeString("name", ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), (String)entry.getKey(), new WithWriterArgs[0]);
                ((DefaultListPlcBrowseItem)((Object)entry)).serialize(writeBuffer);
                writeBuffer.popContext("option", new WithWriterArgs[0]);
            }
            writeBuffer.popContext("options", new WithWriterArgs[0]);
        }
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

