/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.github.jinahya.bit.io.BufferByteOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.io.MyDefaultBitOutput;

public class WriteBufferByteBased
implements WriteBuffer {
    private final ByteBuffer bb;
    private final MyDefaultBitOutput bo;
    private ByteOrder byteOrder;

    public WriteBufferByteBased(int size) {
        this(size, ByteOrder.BIG_ENDIAN);
    }

    public WriteBufferByteBased(int size, ByteOrder byteOrder) {
        this.bb = ByteBuffer.allocate(size);
        BufferByteOutput bbo = new BufferByteOutput(this.bb);
        this.bo = new MyDefaultBitOutput(bbo);
        this.byteOrder = byteOrder;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setPos(int position) {
        this.bb.position(position);
    }

    @Deprecated
    public byte[] getData() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        return ArrayUtils.subarray((byte[])this.bb.array(), (int)0, (int)this.getPos());
    }

    @Override
    public int getPos() {
        return (int)this.bo.getPos();
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws SerializationException {
        try {
            this.bo.writeBoolean(value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing bit", e);
        }
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.writeSignedByte(logicalName, 8, value, writerArgs);
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws SerializationException {
        for (byte aByte : bytes) {
            this.writeSignedByte(logicalName, 8, aByte, writerArgs);
        }
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("unsigned byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new SerializationException("unsigned byte can only contain max 8 bits");
        }
        try {
            this.bo.writeByte(true, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing unsigned byte", e);
        }
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("unsigned short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new SerializationException("unsigned short can only contain max 16 bits");
        }
        try {
            this.bo.writeShort(true, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing unsigned short", e);
        }
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("unsigned int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new SerializationException("unsigned int can only contain max 32 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                value = Integer.reverseBytes(value) >> 16;
            }
            this.bo.writeInt(true, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing unsigned int", e);
        }
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 63) {
            throw new SerializationException("unsigned long can only contain max 63 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                value = Long.reverseBytes(value) >> 32;
            }
            this.bo.writeLong(true, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing unsigned long", e);
        }
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        block10: {
            try {
                if (bitLength == 64) {
                    if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
                            this.writeLong(logicalName, 32, value.longValue(), new WithWriterArgs[0]);
                            this.writeLong(logicalName, 32, value.shiftRight(32).longValue(), new WithWriterArgs[0]);
                        } else {
                            this.writeLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
                        }
                    } else if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
                        this.writeLong(logicalName, 32, value.shiftRight(32).longValue(), new WithWriterArgs[0]);
                        this.writeLong(logicalName, 32, value.longValue(), new WithWriterArgs[0]);
                    } else {
                        this.writeLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
                    }
                    break block10;
                }
                if (bitLength < 64) {
                    this.writeUnsignedLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
                    break block10;
                }
                throw new SerializationException("Unsigned Big Integer can only contain max 64 bits");
            }
            catch (ArithmeticException e) {
                throw new SerializationException("Error writing unsigned big integer", e);
            }
        }
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new SerializationException("byte can only contain max 8 bits");
        }
        try {
            this.bo.writeByte(false, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing signed byte", e);
        }
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new SerializationException("short can only contain max 16 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                value = Short.reverseBytes(value);
            }
            this.bo.writeShort(false, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing signed short", e);
        }
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new SerializationException("int can only contain max 32 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                value = Integer.reverseBytes(value);
            }
            this.bo.writeInt(false, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing signed int", e);
        }
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength <= 0) {
            throw new SerializationException("long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new SerializationException("long can only contain max 64 bits");
        }
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                value = Long.reverseBytes(value);
            }
            this.bo.writeLong(false, bitLength, value);
        }
        catch (IOException e) {
            throw new SerializationException("Error writing signed long", e);
        }
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws SerializationException {
        try {
            if (bitLength > 64) {
                throw new SerializationException("Big Integer can only contain max 64 bits");
            }
            this.writeLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
        }
        catch (ArithmeticException e) {
            throw new SerializationException("Error writing big integer", e);
        }
    }

    @Override
    public void writeFloat(String logicalName, int bitLength, float value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength != 32) {
            throw new UnsupportedOperationException("Error writing float: Exponent and/or Mantissa non standard size");
        }
        this.writeInt(logicalName, bitLength, Float.floatToRawIntBits(value), new WithWriterArgs[0]);
    }

    @Override
    public void writeDouble(String logicalName, int bitLength, double value, WithWriterArgs ... writerArgs) throws SerializationException {
        if (bitLength != 64) {
            throw new UnsupportedOperationException("Error writing double: Exponent and/or Mantissa non standard size");
        }
        this.writeLong(logicalName, bitLength, Double.doubleToRawLongBits(value), new WithWriterArgs[0]);
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void writeString(String logicalName, int bitLength, String encoding, String value, WithWriterArgs ... writerArgs) throws SerializationException {
        byte[] bytes;
        encoding = encoding.replaceAll("[^a-zA-Z0-9]", "");
        switch (encoding.toUpperCase()) {
            case "UTF8": {
                bytes = value.getBytes(StandardCharsets.UTF_8);
                break;
            }
            case "UTF16": 
            case "UTF16LE": 
            case "UTF16BE": {
                bytes = value.getBytes(StandardCharsets.UTF_16);
                break;
            }
            default: {
                throw new SerializationException("Unsupported encoding: " + encoding);
            }
        }
        int fixedByteLength = (int)Math.ceil((double)bitLength / 8.0);
        if (bitLength == 0) {
            fixedByteLength = bytes.length;
        }
        try {
            for (int offset = bytes.length - fixedByteLength; offset < 0; ++offset) {
                this.bo.writeByte(false, 8, (byte)0);
            }
            for (int i = offset; i < bytes.length; ++i) {
                this.bo.writeByte(false, 8, bytes[i]);
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error writing string", e);
        }
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
    }
}

