/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.io;

import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class VintIo {
    public static int getLengthInBytes(long value) {
        int numBytes = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ++numBytes;
            value >>= 7;
        }
        return numBytes;
    }

    public static void serialize(long value, WriteBuffer writeBuffer) throws SerializationException {
        VintIo.serializeInternally(value, writeBuffer, true);
    }

    private static void serializeInternally(long value, WriteBuffer writeBuffer, boolean lastByte) throws SerializationException {
        byte curValue = (byte)(value & 0x7FL | (long)(lastByte ? 0 : 128));
        long restValue = value >> 7;
        if (restValue != 0L) {
            VintIo.serializeInternally(restValue, writeBuffer, false);
        }
        writeBuffer.writeUnsignedShort(8, curValue);
    }

    public static long parse(ReadBuffer readBuffer) throws ParseException {
        short curByte;
        long curValue = 0L;
        do {
            curByte = readBuffer.readUnsignedShort(8);
            curValue |= (long)(curByte & 0x7F);
            if ((curByte & 0x80) == 0) continue;
            curValue <<= 7;
        } while ((curByte & 0x80) != 0);
        return curValue;
    }
}

