/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.io;

import java.util.function.Function;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnum;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReaderEnumDefault<T, I>
implements DataReaderEnum<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataReaderEnumDefault.class);
    private final Function<I, T> enumResolver;
    private final DataReader<I> dataReader;

    public DataReaderEnumDefault(Function<I, T> enumResolver, DataReader<I> dataReader) {
        this.enumResolver = enumResolver;
        this.dataReader = dataReader;
    }

    @Override
    public int getPos() {
        return this.dataReader.getPos();
    }

    @Override
    public void setPos(int position) {
        this.dataReader.setPos(position);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.dataReader.getByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.dataReader.setByteOrder(byteOrder);
    }

    @Override
    public T read(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        return this.read(logicalName, this.enumResolver, readerArgs);
    }

    public T read(String logicalName, Function<I, T> enumResolver, WithReaderArgs ... readerArgs) throws ParseException {
        I rawValue = this.dataReader.read(logicalName, readerArgs);
        T enumValue = enumResolver.apply(rawValue);
        if (enumValue == null) {
            LOGGER.debug("No {} enum found for value {}", (Object)logicalName, rawValue);
        }
        return enumValue;
    }

    @Override
    public void pullContext(String logicalName, WithReaderArgs ... readerArgs) {
        this.dataReader.pullContext(logicalName, readerArgs);
    }

    @Override
    public void closeContext(String logicalName, WithReaderArgs ... readerArgs) {
        this.dataReader.closeContext(logicalName, readerArgs);
    }
}

