/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.util.List;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldWriterArray<T>
implements FieldCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldWriterArray.class);

    public void writeByteArrayField(String logicalName, byte[] values, DataWriter<byte[]> dataWriter, WithWriterArgs ... writerArgs) throws SerializationException {
        LOGGER.debug("write field {}", (Object)logicalName);
        if (values != null) {
            dataWriter.write(logicalName, values, writerArgs);
        }
    }

    public void writeSimpleTypeArrayField(String logicalName, List<T> values, DataWriter<T> dataWriter, WithWriterArgs ... writerArgs) throws SerializationException {
        LOGGER.debug("write field {}", (Object)logicalName);
        this.switchSerializeByteOrderIfNecessary(() -> {
            if (values != null) {
                dataWriter.pushContext(logicalName, WithReaderWriterArgs.WithRenderAsList(true));
                for (Object value : values) {
                    dataWriter.write("value", value, writerArgs);
                }
                dataWriter.popContext(logicalName, WithReaderWriterArgs.WithRenderAsList(true));
            }
        }, dataWriter, this.extractByteOrder(writerArgs).orElse(null));
    }

    public void writeComplexTypeArrayField(String logicalName, List<? extends Message> values, WriteBuffer writeBuffer, WithWriterArgs ... writerArgs) throws SerializationException {
        LOGGER.debug("write field {}", (Object)logicalName);
        this.switchSerializeByteOrderIfNecessary(() -> {
            if (values != null) {
                writeBuffer.pushContext(logicalName, WithReaderWriterArgs.WithRenderAsList(true));
                for (Message value : values) {
                    value.serialize(writeBuffer);
                }
                writeBuffer.popContext(logicalName, WithReaderWriterArgs.WithRenderAsList(true));
            }
        }, writeBuffer, this.extractByteOrder(writerArgs).orElse(null));
    }
}

