/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.config.triggeredscraper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.scraper.config.triggeredscraper.JobConfigurationTriggeredImpl;
import org.apache.plc4x.java.scraper.config.triggeredscraper.ScraperConfigurationTriggeredImplBuilder;
import org.apache.plc4x.java.scraper.exception.ScraperConfigurationException;

public class JobConfigurationTriggeredImplBuilder {
    private final ScraperConfigurationTriggeredImplBuilder parent;
    private final String name;
    private final String triggerConfig;
    private final List<String> sources = new ArrayList<String>();
    private final Map<String, String> tags = new HashMap<String, String>();

    public JobConfigurationTriggeredImplBuilder(ScraperConfigurationTriggeredImplBuilder parent, String name, String triggerConfig) {
        if (parent == null) {
            throw new ScraperConfigurationException("parent builder cannot be null");
        }
        if (name == null || name.isEmpty()) {
            throw new ScraperConfigurationException("Job name must not be null or empty");
        }
        this.parent = parent;
        this.name = name;
        this.triggerConfig = triggerConfig;
    }

    public JobConfigurationTriggeredImplBuilder source(String alias) {
        if (alias == null || alias.isEmpty()) {
            throw new ScraperConfigurationException("source alias cannot be null or empty");
        }
        this.sources.add(alias);
        return this;
    }

    public JobConfigurationTriggeredImplBuilder tag(String alias, String tagQuery) {
        this.tags.put(alias, tagQuery);
        return this;
    }

    private JobConfigurationTriggeredImpl buildInternal() {
        return new JobConfigurationTriggeredImpl(this.name, this.triggerConfig, null, this.sources, this.tags);
    }

    public ScraperConfigurationTriggeredImplBuilder build() {
        this.parent.addJobConfiguration(this.buildInternal());
        return this.parent;
    }
}

