/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.scraper.config.triggeredscraper;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.plc4x.java.scraper.ScrapeJob;
import org.apache.plc4x.java.scraper.ScrapeJobImpl;
import org.apache.plc4x.java.scraper.config.JobConfiguration;
import org.apache.plc4x.java.scraper.config.JobConfigurationImpl;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.exception.ScraperConfigurationException;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScrapeJobImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScraperConfigurationTriggeredImpl
implements ScraperConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ScraperConfigurationTriggeredImpl.class);
    private final Map<String, String> sources;
    private final List<JobConfigurationImpl> jobConfigurations;

    @JsonCreator
    public ScraperConfigurationTriggeredImpl(@JsonProperty(value="sources", required=true) Map<String, String> sources, @JsonProperty(value="jobs", required=true) List<JobConfigurationImpl> jobConfigurations) {
        this.checkNoUnreferencedSources(sources, jobConfigurations);
        this.sources = sources;
        this.jobConfigurations = jobConfigurations;
    }

    private void checkNoUnreferencedSources(Map<String, String> sources, List<JobConfigurationImpl> jobConfigurations) {
        Set unreferencedSources = jobConfigurations.stream().flatMap(job -> job.getSources().stream()).filter(source -> !sources.containsKey(source)).collect(Collectors.toSet());
        if (!unreferencedSources.isEmpty()) {
            throw new ScraperConfigurationException("There are the following unreferenced sources: " + unreferencedSources);
        }
    }

    @Override
    public Map<String, String> getSources() {
        return this.sources;
    }

    @Override
    public List<JobConfigurationImpl> getJobConfigurations() {
        return this.jobConfigurations;
    }

    @Override
    public List<ScrapeJob> getJobs() throws ScraperException {
        return ScraperConfigurationTriggeredImpl.getJobs(this.jobConfigurations, this.sources);
    }

    public static List<ScrapeJob> getJobs(List<JobConfigurationImpl> jobConfigurations, Map<String, String> sources) throws ScraperConfigurationException {
        ArrayList<ScrapeJob> scrapeJobs = new ArrayList<ScrapeJob>();
        for (JobConfiguration jobConfiguration : jobConfigurations) {
            if (jobConfiguration.getTriggerConfig() != null) {
                logger.info("Assuming job as triggered job because triggerConfig has been set");
                scrapeJobs.add(new TriggeredScrapeJobImpl(jobConfiguration.getName(), jobConfiguration.getTriggerConfig(), ScraperConfigurationTriggeredImpl.getSourcesForAliases(jobConfiguration.getSources(), sources), jobConfiguration.getFields()));
                continue;
            }
            if (jobConfiguration.getScrapeRate() != null) {
                logger.info("Assuming job as classic job because triggerConfig has NOT been set but scrapeRate has.");
                scrapeJobs.add(new ScrapeJobImpl(jobConfiguration.getName(), jobConfiguration.getScrapeRate().intValue(), ScraperConfigurationTriggeredImpl.getSourcesForAliases(jobConfiguration.getSources(), sources), jobConfiguration.getFields()));
                continue;
            }
            logger.info("Job has lack of trigger/scheduled config");
            throw new ScraperConfigurationException(String.format("Job %s was intended to be o triggered annotation, but no triggerConfig-Field could be found. Canceling!", jobConfiguration.getName()));
        }
        return scrapeJobs;
    }

    private static Map<String, String> getSourcesForAliases(List<String> aliases, Map<String, String> sources) {
        return aliases.stream().collect(Collectors.toMap(Function.identity(), sources::get));
    }
}

