/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum SimulatedDataTypeSizes {
    BOOL(1, 1),
    BYTE(2, 1),
    WORD(3, 2),
    DWORD(4, 4),
    LWORD(5, 8),
    SINT(6, 1),
    INT(7, 2),
    DINT(8, 4),
    LINT(9, 8),
    USINT(10, 1),
    UINT(11, 2),
    UDINT(12, 4),
    ULINT(13, 8),
    REAL(14, 4),
    LREAL(15, 8),
    TIME(16, 8),
    LTIME(17, 8),
    DATE(18, 8),
    LDATE(19, 8),
    TIME_OF_DAY(20, 8),
    LTIME_OF_DAY(21, 8),
    DATE_AND_TIME(22, 8),
    LDATE_AND_TIME(23, 8),
    CHAR(24, 1),
    WCHAR(25, 2),
    STRING(26, 255),
    WSTRING(27, 127);

    private static final Map<Short, SimulatedDataTypeSizes> map;
    private final short value;
    private final short dataTypeSize;

    static {
        map = new HashMap<Short, SimulatedDataTypeSizes>();
        SimulatedDataTypeSizes[] simulatedDataTypeSizesArray = SimulatedDataTypeSizes.values();
        int n = simulatedDataTypeSizesArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulatedDataTypeSizes value = simulatedDataTypeSizesArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private SimulatedDataTypeSizes(short value, short dataTypeSize) {
        this.value = value;
        this.dataTypeSize = dataTypeSize;
    }

    public short getValue() {
        return this.value;
    }

    public short getDataTypeSize() {
        return this.dataTypeSize;
    }

    public static SimulatedDataTypeSizes firstEnumForFieldDataTypeSize(short fieldValue) {
        SimulatedDataTypeSizes[] simulatedDataTypeSizesArray = SimulatedDataTypeSizes.values();
        int n = simulatedDataTypeSizesArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulatedDataTypeSizes _val = simulatedDataTypeSizesArray[n2];
            if (_val.getDataTypeSize() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<SimulatedDataTypeSizes> enumsForFieldDataTypeSize(short fieldValue) {
        ArrayList<SimulatedDataTypeSizes> _values = new ArrayList<SimulatedDataTypeSizes>();
        SimulatedDataTypeSizes[] simulatedDataTypeSizesArray = SimulatedDataTypeSizes.values();
        int n = simulatedDataTypeSizesArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulatedDataTypeSizes _val = simulatedDataTypeSizesArray[n2];
            if (_val.getDataTypeSize() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static SimulatedDataTypeSizes enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

