/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.connection;

import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.simulated.field.SimulatedField;
import org.apache.plc4x.java.simulated.readwrite.DataItem;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedDevice {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulatedDevice.class);
    private final Random random = new SecureRandom();
    private final String name;
    private final Map<SimulatedField, PlcValue> state = new HashMap<SimulatedField, PlcValue>();
    private final Map<PlcSubscriptionHandle, ScheduledFuture<?>> cyclicSubscriptions = new HashMap();
    private final Map<PlcSubscriptionHandle, Future<?>> eventSubscriptions = new HashMap();
    private final IdentityHashMap<PlcSubscriptionHandle, Pair<SimulatedField, Consumer<PlcValue>>> changeOfStateSubscriptions = new IdentityHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ExecutorService pool = Executors.newCachedThreadPool();

    public SimulatedDevice(String name) {
        this.name = name;
    }

    public Optional<PlcValue> get(SimulatedField field) {
        LOGGER.debug("getting field {}", (Object)field);
        Objects.requireNonNull(field);
        switch (field.getType()) {
            case STATE: {
                return Optional.ofNullable(this.state.get(field));
            }
            case RANDOM: {
                return Optional.ofNullable(this.randomValue(field));
            }
            case STDOUT: {
                return Optional.empty();
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType().name());
    }

    public void set(SimulatedField field, PlcValue value) {
        LOGGER.debug("setting field {} to {}", (Object)field, (Object)value);
        Objects.requireNonNull(field);
        switch (field.getType()) {
            case STATE: {
                this.changeOfStateSubscriptions.values().stream().filter(pair -> ((SimulatedField)pair.getKey()).equals(field)).map(Pair::getValue).peek(plcValueConsumer -> LOGGER.debug("{} is getting notified with {}", plcValueConsumer, (Object)value)).forEach(baseDefaultPlcValueConsumer -> baseDefaultPlcValueConsumer.accept(value));
                this.state.put(field, value);
                return;
            }
            case STDOUT: {
                LOGGER.info("TEST PLC STDOUT [{}]: {}", (Object)field.getName(), (Object)value.toString());
                return;
            }
            case RANDOM: {
                switch (field.getPlcDataType()) {
                    case "STRING": 
                    case "WSTRING": {
                        break;
                    }
                    default: {
                        try {
                            int lengthInBits = DataItem.getLengthInBits(value, field.getPlcDataType(), field.getNumberOfElements());
                            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil((float)lengthInBits / 8.0f));
                            DataItem.staticSerialize((WriteBuffer)writeBuffer, value, field.getPlcDataType(), field.getNumberOfElements(), ByteOrder.BIG_ENDIAN);
                            break;
                        }
                        catch (SerializationException e) {
                            LOGGER.info("Write failed");
                        }
                    }
                }
                LOGGER.info("TEST PLC RANDOM [{}]: {}", (Object)field.getName(), (Object)value);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType().name());
    }

    private PlcValue randomValue(SimulatedField field) {
        short fieldDataTypeSize = field.getDataType().getDataTypeSize();
        byte[] b = new byte[fieldDataTypeSize * field.getNumberOfElements()];
        this.random.nextBytes(b);
        ReadBufferByteBased io = new ReadBufferByteBased(b);
        try {
            return DataItem.staticParse((ReadBuffer)io, field.getPlcDataType(), field.getNumberOfElements());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public void addCyclicSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, PlcSubscriptionField plcField, Duration duration) {
        LOGGER.debug("Adding cyclic subscription: {}, {}, {}, {}", new Object[]{consumer, handle, plcField, duration});
        assert (plcField instanceof DefaultPlcSubscriptionField);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            PlcField innerPlcField = ((DefaultPlcSubscriptionField)plcField).getPlcField();
            assert (innerPlcField instanceof SimulatedField);
            PlcValue baseDefaultPlcValue = this.state.get(innerPlcField);
            if (baseDefaultPlcValue == null) {
                return;
            }
            consumer.accept(baseDefaultPlcValue);
        }, duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
        this.cyclicSubscriptions.put(handle, scheduledFuture);
    }

    public void addChangeOfStateSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, PlcSubscriptionField plcField) {
        LOGGER.debug("Adding change of state subscription: {}, {}, {}", new Object[]{consumer, handle, plcField});
        this.changeOfStateSubscriptions.put(handle, (Pair<SimulatedField, Consumer<PlcValue>>)Pair.of((Object)((SimulatedField)((DefaultPlcSubscriptionField)plcField).getPlcField()), consumer));
    }

    public void addEventSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, PlcSubscriptionField plcField) {
        LOGGER.debug("Adding event subscription: {}, {}, {}", new Object[]{consumer, handle, plcField});
        assert (plcField instanceof DefaultPlcSubscriptionField);
        Future<?> submit = this.pool.submit(() -> {
            LOGGER.debug("WORKER: starting for {}, {}, {}", new Object[]{consumer, handle, plcField});
            while (!Thread.currentThread().isInterrupted()) {
                LOGGER.debug("WORKER: running for {}, {}, {}", new Object[]{consumer, handle, plcField});
                PlcField innerPlcField = ((DefaultPlcSubscriptionField)plcField).getPlcField();
                assert (innerPlcField instanceof SimulatedField);
                PlcValue baseDefaultPlcValue = this.state.get(innerPlcField);
                if (baseDefaultPlcValue == null) {
                    LOGGER.debug("WORKER: no value for {}, {}, {}", new Object[]{consumer, handle, plcField});
                    continue;
                }
                LOGGER.debug("WORKER: accepting {} for {}, {}, {}", new Object[]{baseDefaultPlcValue, consumer, handle, plcField});
                consumer.accept(baseDefaultPlcValue);
                try {
                    long sleepTime = Math.min((long)this.random.nextInt((int)TimeUnit.SECONDS.toNanos(5L)), TimeUnit.MILLISECONDS.toNanos(500L));
                    LOGGER.debug("WORKER: sleeping {} milliseconds for {}, {}, {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(sleepTime), consumer, handle, plcField});
                    TimeUnit.NANOSECONDS.sleep(sleepTime);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    LOGGER.debug("WORKER: got interrupted for {}, {}, {}", new Object[]{consumer, handle, plcField});
                    return;
                }
            }
        });
        this.eventSubscriptions.put(handle, submit);
    }

    public void removeHandles(Collection<? extends PlcSubscriptionHandle> internalPlcSubscriptionHandles) {
        LOGGER.debug("remove handles {}", internalPlcSubscriptionHandles);
        internalPlcSubscriptionHandles.forEach(handle -> {
            ScheduledFuture<?> remove = this.cyclicSubscriptions.remove(handle);
            if (remove == null) {
                LOGGER.debug("nothing to cancel {}", handle);
                return;
            }
            remove.cancel(true);
        });
        internalPlcSubscriptionHandles.forEach(handle -> {
            Future<?> remove = this.eventSubscriptions.remove(handle);
            if (remove == null) {
                LOGGER.debug("nothing to cancel {}", handle);
                return;
            }
            remove.cancel(true);
        });
        internalPlcSubscriptionHandles.forEach(this.changeOfStateSubscriptions::remove);
    }
}

