/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7light.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcTagRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCalledTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCallingTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterTpduSize;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.ControllerType;
import org.apache.plc4x.java.s7.readwrite.DataItem;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponse;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterSetupCommunication;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItemCPUFunctions;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserData;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadDataItem;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadStatusItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItemAddress;
import org.apache.plc4x.java.s7.readwrite.SzlId;
import org.apache.plc4x.java.s7.readwrite.SzlModuleTypeClass;
import org.apache.plc4x.java.s7.readwrite.SzlSublist;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringFixedLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7StringVarLengthTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7light.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7light.readwrite.tag.S7PlcTagHandler;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagItem;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcTagValueItem;
import org.apache.plc4x.java.spi.messages.utils.PlcTagItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.DefaultPlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7ProtocolLogic
extends Plc4xProtocolBase<TPKTPacket> {
    private static final Logger logger = LoggerFactory.getLogger(S7ProtocolLogic.class);
    private final AtomicInteger tpduGenerator = new AtomicInteger(10);
    private S7DriverContext s7DriverContext;
    private RequestTransactionManager tm;

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.s7DriverContext = (S7DriverContext)driverContext;
        this.tm = new RequestTransactionManager(1);
    }

    public PlcTagHandler getTagHandler() {
        return new S7PlcTagHandler();
    }

    public void close(ConversationContext<TPKTPacket> context) {
        this.tm.shutdown();
    }

    public void onConnect(ConversationContext<TPKTPacket> context) {
        logger.info("S7 Driver running in ACTIVE mode.");
        logger.debug("Sending COTP Connection Request");
        TPKTPacket packet = new TPKTPacket(this.createCOTPConnectionRequest(this.s7DriverContext.getCalledTsapId(), this.s7DriverContext.getCallingTsapId(), this.s7DriverContext.getCotpTpduSize()));
        context.sendRequest((Object)packet).onTimeout(e -> logger.info("Timeout during Connection establishing, closing channel...")).expectResponse(TPKTPacket.class, this.s7DriverContext.getReadTimeoutDuration()).unwrap(TPKTPacket::getPayload).only(COTPPacketConnectionResponse.class).handle(cotpPacketConnectionResponse -> {
            logger.debug("Got COTP Connection Response");
            logger.debug("Sending S7 Connection Request");
            context.sendRequest((Object)this.createS7ConnectionRequest((COTPPacketConnectionResponse)cotpPacketConnectionResponse)).onTimeout(e -> {
                logger.warn("Timeout during Connection establishing, closing channel...");
                context.getChannel().close();
            }).expectResponse(TPKTPacket.class, this.s7DriverContext.getReadTimeoutDuration()).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageResponseData.class).unwrap(S7Message::getParameter).only(S7ParameterSetupCommunication.class).handle(setupCommunication -> {
                logger.debug("Got S7 Connection Response");
                this.s7DriverContext.setMaxAmqCaller(setupCommunication.getMaxAmqCaller());
                this.s7DriverContext.setMaxAmqCallee(setupCommunication.getMaxAmqCallee());
                this.s7DriverContext.setPduSize(setupCommunication.getPduLength());
                this.tm.setNumberOfConcurrentRequests(this.s7DriverContext.getMaxAmqCallee());
                if (this.s7DriverContext.getControllerType() != ControllerType.ANY) {
                    context.fireConnected();
                    return;
                }
                logger.debug("Sending S7 Identification Request");
                TPKTPacket tpktPacket = this.createIdentifyRemoteMessage();
                context.sendRequest((Object)tpktPacket).onTimeout(e -> {
                    logger.warn("Timeout during Connection establishing, closing channel...");
                    context.getChannel().close();
                }).expectResponse(TPKTPacket.class, this.s7DriverContext.getReadTimeoutDuration()).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).unwrap(COTPPacket::getPayload).only(S7MessageUserData.class).unwrap(S7Message::getPayload).only(S7PayloadUserData.class).handle(payloadUserData -> {
                    logger.debug("Got S7 Identification Response");
                    this.extractControllerTypeAndFireConnected(context, (S7PayloadUserData)payloadUserData);
                });
            });
        });
    }

    public void onDisconnect(ConversationContext<TPKTPacket> context) {
        this.tm.shutdown();
        context.getChannel().close();
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        CompletableFuture<S7Message> responseFuture = request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7StringVarLengthTag) ? this.performVarLengthStringReadRequest(request) : this.performOrdinaryReadRequest(request);
        return this.toPlcReadResponse(readRequest, responseFuture);
    }

    private CompletableFuture<PlcReadResponse> toPlcReadResponse(PlcReadRequest readRequest, CompletableFuture<S7Message> responseFuture) {
        CompletableFuture<PlcReadResponse> clientFuture = new CompletableFuture<PlcReadResponse>();
        S7Message[] responseMessage = new S7Message[1];
        PlcReadRequest[] plcReadRequest = new PlcReadRequest[1];
        responseFuture.whenComplete((s7Message, throwable) -> {
            if (throwable != null) {
                clientFuture.completeExceptionally((Throwable)new PlcProtocolException("Error reading", throwable));
            } else {
                try {
                    s7MessageArray[0] = s7Message;
                    plcReadRequestArray[0] = readRequest;
                    PlcReadResponse response = (PlcReadResponse)this.decodeReadResponse(responseMessage[0], plcReadRequest[0]);
                    clientFuture.complete(response);
                }
                catch (Exception ex) {
                    logger.info(ex.toString());
                }
            }
        });
        return clientFuture;
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        CompletableFuture<S7Message> responseFuture = new CompletableFuture();
        responseFuture = request.getTagNames().stream().anyMatch(t -> request.getTag(t) instanceof S7StringVarLengthTag) ? this.performVarLengthStringWriteRequest((DefaultPlcWriteRequest)writeRequest) : this.performOrdinaryWriteRequest(request);
        return this.toPlcWriteResponse(writeRequest, responseFuture);
    }

    private CompletableFuture<PlcWriteResponse> toPlcWriteResponse(PlcWriteRequest writeRequest, CompletableFuture<S7Message> responseFuture) {
        CompletableFuture<PlcWriteResponse> clientFuture = new CompletableFuture<PlcWriteResponse>();
        responseFuture.whenComplete((s7Message, throwable) -> {
            if (throwable != null) {
                clientFuture.completeExceptionally((Throwable)new PlcProtocolException("Error writing", throwable));
            } else {
                try {
                    PlcWriteResponse response = (PlcWriteResponse)this.decodeWriteResponse((S7Message)s7Message, writeRequest);
                    clientFuture.complete(response);
                }
                catch (Exception ex) {
                    logger.info(ex.toString());
                }
            }
        });
        return clientFuture;
    }

    private CompletableFuture<S7Message> performVarLengthStringReadRequest(DefaultPlcReadRequest request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        int numVarLengthStrings = 0;
        LinkedHashMap<String, Object> updatedRequestItems = new LinkedHashMap<String, Object>(request.getNumberOfTags());
        for (String tagName : request.getTagNames()) {
            PlcTagItem plcTagItem = request.getTagItem(tagName);
            if (plcTagItem.getTag() instanceof S7StringVarLengthTag) {
                S7Tag s7Tag = (S7Tag)plcTagItem.getTag();
                TransportSize dataType = s7Tag.getDataType();
                if (dataType == TransportSize.STRING) {
                    updatedRequestItems.put(tagName, new DefaultPlcTagItem((PlcTag)new S7Tag(TransportSize.BYTE, s7Tag.getMemoryArea(), s7Tag.getBlockNumber(), s7Tag.getByteOffset(), s7Tag.getBitOffset(), 2)));
                    ++numVarLengthStrings;
                    continue;
                }
                if (dataType != TransportSize.WSTRING) continue;
                updatedRequestItems.put(tagName, new DefaultPlcTagItem((PlcTag)new S7Tag(TransportSize.BYTE, s7Tag.getMemoryArea(), s7Tag.getBlockNumber(), s7Tag.getByteOffset(), s7Tag.getBitOffset(), 4)));
                ++numVarLengthStrings;
                continue;
            }
            updatedRequestItems.put(tagName, plcTagItem);
        }
        CompletableFuture<S7Message> s7MessageCompletableFuture = this.performOrdinaryReadRequest(new DefaultPlcReadRequest(request.getReader(), updatedRequestItems));
        int finalNumVarLengthStrings = numVarLengthStrings;
        s7MessageCompletableFuture.whenComplete((s7Message, throwable1) -> {
            if (throwable1 != null) {
                future.completeExceptionally((Throwable)throwable1);
                return;
            }
            LinkedHashMap<String, DefaultPlcTagItem> varLengthStringTags = new LinkedHashMap<String, DefaultPlcTagItem>(finalNumVarLengthStrings);
            int curItem = 0;
            for (String tagName : request.getTagNames()) {
                S7VarPayloadDataItem s7VarPayloadDataItem;
                S7Tag s7tag = (S7Tag)request.getTag(tagName);
                if (s7tag instanceof S7StringVarLengthTag && (s7VarPayloadDataItem = ((S7PayloadReadVarResponse)s7Message.getPayload()).getItems().get(curItem)).getReturnCode() == DataTransportErrorCode.OK) {
                    ReadBufferByteBased rb = new ReadBufferByteBased(s7VarPayloadDataItem.getData());
                    try {
                        if (s7tag.getDataType() == TransportSize.STRING) {
                            rb.readShort(8, new WithReaderArgs[0]);
                            short stringLength = rb.readShort(8, new WithReaderArgs[0]);
                            varLengthStringTags.put(tagName, new DefaultPlcTagItem((PlcTag)new S7StringFixedLengthTag(TransportSize.STRING, s7tag.getMemoryArea(), s7tag.getBlockNumber(), s7tag.getByteOffset(), s7tag.getBitOffset(), 1, stringLength)));
                        } else if (s7tag.getDataType() == TransportSize.WSTRING) {
                            rb.readInt(16, new WithReaderArgs[0]);
                            int stringLength = rb.readInt(16, new WithReaderArgs[0]);
                            varLengthStringTags.put(tagName, new DefaultPlcTagItem((PlcTag)new S7StringFixedLengthTag(TransportSize.WSTRING, s7tag.getMemoryArea(), s7tag.getBlockNumber(), s7tag.getByteOffset(), s7tag.getBitOffset(), 1, stringLength)));
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Error parsing string size for tag {}", (Object)tagName, (Object)e);
                    }
                }
                ++curItem;
            }
            CompletableFuture<S7Message> readStringsCompletableFuture = this.performOrdinaryReadRequest(new DefaultPlcReadRequest(request.getReader(), varLengthStringTags));
            readStringsCompletableFuture.whenComplete((s7StringMessage, throwable2) -> {
                int curInitialItem = 0;
                int curVarLengthStringItem = 0;
                ArrayList<S7VarPayloadDataItem> varLengthStringItems = new ArrayList<S7VarPayloadDataItem>(request.getNumberOfTags());
                for (String tagName : request.getTagNames()) {
                    S7Tag s7tag = (S7Tag)request.getTag(tagName);
                    S7VarPayloadDataItem curResultItem = ((S7PayloadReadVarResponse)s7Message.getPayload()).getItems().get(curInitialItem);
                    if (s7tag instanceof S7StringVarLengthTag && curResultItem.getReturnCode() == DataTransportErrorCode.OK) {
                        curResultItem = ((S7PayloadReadVarResponse)s7StringMessage.getPayload()).getItems().get(curVarLengthStringItem);
                        ++curVarLengthStringItem;
                    }
                    varLengthStringItems.add(curResultItem);
                    ++curInitialItem;
                }
                future.complete(new S7MessageResponse(s7Message.getTpduReference(), s7Message.getParameter(), new S7PayloadReadVarResponse(varLengthStringItems), 0, 0));
            });
        });
        return future;
    }

    private CompletableFuture<S7Message> performOrdinaryReadRequest(DefaultPlcReadRequest request) {
        ArrayList<S7VarRequestParameterItem> requestItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfTags());
        for (PlcTag tag : request.getTags()) {
            requestItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(tag)));
        }
        S7MessageRequest requestMessage = new S7MessageRequest(this.getTpduId(), new S7ParameterReadVarRequest(requestItems), null);
        return this.sendInternal(requestMessage);
    }

    private CompletableFuture<S7Message> performVarLengthStringWriteRequest(DefaultPlcWriteRequest request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        CompletableFuture<Map<S7StringVarLengthTag, StringSizes>> stringSizesFuture = this.getStringSizes((PlcTagRequest)request);
        stringSizesFuture.whenComplete((s7StringVarLengthTagStringSizesMap, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)new PlcProtocolException("Error resolving string sizes", throwable));
            } else {
                LinkedHashMap<String, DefaultPlcTagValueItem> updatedRequestItems = new LinkedHashMap<String, DefaultPlcTagValueItem>(request.getNumberOfTags());
                for (String tagName : request.getTagNames()) {
                    PlcTag tag = request.getTag(tagName);
                    PlcValue value = request.getPlcValue(tagName);
                    if (tag instanceof S7StringVarLengthTag) {
                        S7StringVarLengthTag varLengthTag = (S7StringVarLengthTag)tag;
                        int stringLength = ((StringSizes)s7StringVarLengthTagStringSizesMap.get(varLengthTag)).getCurLength();
                        S7StringFixedLengthTag newTag = new S7StringFixedLengthTag(varLengthTag.getDataType(), varLengthTag.getMemoryArea(), varLengthTag.getBlockNumber(), varLengthTag.getByteOffset(), varLengthTag.getBitOffset(), varLengthTag.getNumberOfElements(), stringLength);
                        updatedRequestItems.put(tagName, new DefaultPlcTagValueItem((PlcTag)newTag, value));
                        continue;
                    }
                    updatedRequestItems.put(tagName, new DefaultPlcTagValueItem(tag, value));
                }
                CompletableFuture<S7Message> s7MessageCompletableFuture = this.performOrdinaryWriteRequest(new DefaultPlcWriteRequest(request.getWriter(), updatedRequestItems));
                s7MessageCompletableFuture.whenComplete((s7Message, throwable1) -> {
                    if (throwable1 != null) {
                        future.completeExceptionally((Throwable)throwable1);
                    } else {
                        future.complete((S7Message)s7Message);
                    }
                });
            }
        });
        return future;
    }

    private CompletableFuture<S7Message> performOrdinaryWriteRequest(DefaultPlcWriteRequest request) {
        ArrayList<S7VarRequestParameterItem> parameterItems = new ArrayList<S7VarRequestParameterItem>(request.getNumberOfTags());
        ArrayList<S7VarPayloadDataItem> payloadItems = new ArrayList<S7VarPayloadDataItem>(request.getNumberOfTags());
        for (String tagName : request.getTagNames()) {
            S7Tag tag = (S7Tag)request.getTag(tagName);
            PlcValue plcValue = request.getPlcValue(tagName);
            parameterItems.add(new S7VarRequestParameterItemAddress(this.encodeS7Address(tag)));
            payloadItems.add(this.serializePlcValue(tag, plcValue));
        }
        return this.sendInternal(new S7MessageRequest(this.getTpduId(), new S7ParameterWriteVarRequest(parameterItems), new S7PayloadWriteVarRequest(payloadItems)));
    }

    private CompletableFuture<S7Message> sendInternal(S7Message request) {
        CompletableFuture<S7Message> future = new CompletableFuture<S7Message>();
        int tpduId = request.getTpduReference();
        TPKTPacket tpktPacket = new TPKTPacket(new COTPPacketData(null, request, true, 0));
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            ConversationContext.ContextHandler contextHandler = this.conversationContext.sendRequest((Object)tpktPacket).onTimeout(new TransactionErrorCallback(future, transaction)).onError(new TransactionErrorCallback(future, transaction)).expectResponse(TPKTPacket.class, this.s7DriverContext.getReadTimeoutDuration()).unwrap(TPKTPacket::getPayload).only(COTPPacketData.class).check(p -> p.getPayload() != null).unwrap(COTPPacket::getPayload).check(p -> p.getTpduReference() == tpduId).handle(p -> {
                transaction.endRequest();
                try {
                    future.complete((S7Message)p);
                }
                catch (Exception e) {
                    logger.warn("Error sending 'write' message: '{}'", (Object)e.getMessage(), (Object)e);
                }
            });
        });
        return future;
    }

    private void extractControllerTypeAndFireConnected(ConversationContext<TPKTPacket> context, S7PayloadUserData payloadUserData) {
        for (S7PayloadUserDataItem item : payloadUserData.getItems()) {
            if (!(item instanceof S7PayloadUserDataItemCpuFunctionReadSzlResponse)) continue;
            S7PayloadUserDataItemCpuFunctionReadSzlResponse readSzlResponseItem = (S7PayloadUserDataItemCpuFunctionReadSzlResponse)item;
            ByteBuf szlItem = Unpooled.wrappedBuffer((byte[])readSzlResponseItem.getItems());
            String articleNumber = szlItem.toString(2, 20, Charset.defaultCharset());
            this.s7DriverContext.setControllerType(this.decodeControllerType(articleNumber));
            context.fireConnected();
        }
    }

    private TPKTPacket createIdentifyRemoteMessage() {
        S7MessageUserData identifyRemoteMessage = new S7MessageUserData(1, new S7ParameterUserData(Collections.singletonList(new S7ParameterUserDataItemCPUFunctions(17, 4, 4, 1, 0, null, null, null))), new S7PayloadUserData(Collections.singletonList(new S7PayloadUserDataItemCpuFunctionReadSzlRequest(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, 12, new SzlId(SzlModuleTypeClass.CPU, 0, SzlSublist.MODULE_IDENTIFICATION), 0))));
        COTPPacketData cotpPacketData = new COTPPacketData(null, identifyRemoteMessage, true, 2);
        return new TPKTPacket(cotpPacketData);
    }

    private TPKTPacket createS7ConnectionRequest(COTPPacketConnectionResponse cotpPacketConnectionResponse) {
        for (COTPParameter parameter : cotpPacketConnectionResponse.getParameters()) {
            if (parameter instanceof COTPParameterCalledTsap) {
                COTPParameterCalledTsap cotpParameterCalledTsap = (COTPParameterCalledTsap)parameter;
                this.s7DriverContext.setCalledTsapId(cotpParameterCalledTsap.getTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterCallingTsap) {
                COTPParameterCallingTsap cotpParameterCallingTsap = (COTPParameterCallingTsap)parameter;
                if (cotpParameterCallingTsap.getTsapId() == this.s7DriverContext.getCallingTsapId()) continue;
                this.s7DriverContext.setCallingTsapId(cotpParameterCallingTsap.getTsapId());
                logger.warn("Switching calling TSAP id to '{}'", (Object)this.s7DriverContext.getCallingTsapId());
                continue;
            }
            if (parameter instanceof COTPParameterTpduSize) {
                COTPParameterTpduSize cotpParameterTpduSize = (COTPParameterTpduSize)parameter;
                this.s7DriverContext.setCotpTpduSize(cotpParameterTpduSize.getTpduSize());
                continue;
            }
            logger.warn("Got unknown parameter type '{}'", (Object)parameter.getClass().getName());
        }
        S7ParameterSetupCommunication s7ParameterSetupCommunication = new S7ParameterSetupCommunication(this.s7DriverContext.getMaxAmqCaller(), this.s7DriverContext.getMaxAmqCallee(), this.s7DriverContext.getPduSize());
        S7MessageRequest s7Message = new S7MessageRequest(0, s7ParameterSetupCommunication, null);
        COTPPacketData cotpPacketData = new COTPPacketData(null, s7Message, true, 0);
        return new TPKTPacket(cotpPacketData);
    }

    private COTPPacketConnectionRequest createCOTPConnectionRequest(int calledTsapId, int callingTsapId, COTPTpduSize cotpTpduSize) {
        return new COTPPacketConnectionRequest(Arrays.asList(new COTPParameterCallingTsap(callingTsapId), new COTPParameterCalledTsap(calledTsapId), new COTPParameterTpduSize(cotpTpduSize)), null, 0, 15, COTPProtocolClass.CLASS_0);
    }

    private PlcResponse decodeReadResponse(S7Message responseMessage, PlcReadRequest plcReadRequest) throws PlcProtocolException {
        S7Message messageResponse;
        short errorCode;
        short errorClass;
        HashMap<String, DefaultPlcResponseItem> values = new HashMap<String, DefaultPlcResponseItem>();
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            messageResponse = (S7MessageResponse)responseMessage;
            errorClass = ((S7MessageResponse)messageResponse).getErrorClass();
            errorCode = ((S7MessageResponse)messageResponse).getErrorCode();
        } else if (responseMessage instanceof S7MessageUserData) {
            messageResponse = (S7MessageUserData)responseMessage;
            Iterator parameters = (S7ParameterUserData)messageResponse.getParameter();
            S7ParameterUserDataItemCPUFunctions parameterItem = (S7ParameterUserDataItemCPUFunctions)((S7ParameterUserData)((Object)parameters)).getItems().get(0);
            errorClass = 0;
            errorCode = parameterItem.getErrorCode().shortValue();
        } else {
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcReadRequest.getTagNames()) {
                    DefaultPlcResponseItem result = new DefaultPlcResponseItem(PlcResponseCode.ACCESS_DENIED, (Object)new PlcNull());
                    values.put(tagName, result);
                }
                return new DefaultPlcReadResponse(plcReadRequest, values);
            }
            if (errorClass == 133 && errorCode == 0) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that we sent a too large packet or would be receiving a too large one. Please report this, as this is most probably a bug.");
                for (String tagName : plcReadRequest.getTagNames()) {
                    DefaultPlcResponseItem result = new DefaultPlcResponseItem(PlcResponseCode.ACCESS_DENIED, (Object)new PlcNull());
                    values.put(tagName, result);
                }
                return new DefaultPlcReadResponse(plcReadRequest, values);
            }
            logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://github.com/apache/plc4x/issues and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcReadRequest.getTagNames()) {
                DefaultPlcResponseItem result = new DefaultPlcResponseItem(PlcResponseCode.INTERNAL_ERROR, (Object)new PlcNull());
                values.put(tagName, result);
            }
            return new DefaultPlcReadResponse(plcReadRequest, values);
        }
        S7PayloadReadVarResponse payload = (S7PayloadReadVarResponse)responseMessage.getPayload();
        if (plcReadRequest.getNumberOfTags() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        List<S7VarPayloadDataItem> payloadItems = payload.getItems();
        int index = 0;
        for (String tagName : plcReadRequest.getTagNames()) {
            S7Tag tag = (S7Tag)plcReadRequest.getTag(tagName);
            S7VarPayloadDataItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            PlcValue plcValue = null;
            if (responseCode == PlcResponseCode.OK) {
                try {
                    plcValue = this.parsePlcValue(tag, payloadItem.getData());
                }
                catch (Exception e) {
                    throw new PlcProtocolException("Error decoding PlcValue", (Throwable)e);
                }
            }
            DefaultPlcResponseItem result = new DefaultPlcResponseItem(responseCode, plcValue);
            values.put(tagName, result);
            ++index;
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponse decodeWriteResponse(S7Message responseMessage, PlcWriteRequest plcWriteRequest) throws PlcProtocolException {
        short errorCode;
        short errorClass;
        HashMap<String, PlcResponseCode> responses = new HashMap<String, PlcResponseCode>();
        if (responseMessage instanceof S7MessageResponseData) {
            S7MessageResponseData messageResponseData = (S7MessageResponseData)responseMessage;
            errorClass = messageResponseData.getErrorClass();
            errorCode = messageResponseData.getErrorCode();
        } else if (responseMessage instanceof S7MessageResponse) {
            S7MessageResponse messageResponse = (S7MessageResponse)responseMessage;
            errorClass = messageResponse.getErrorClass();
            errorCode = messageResponse.getErrorCode();
        } else {
            if (responseMessage instanceof S7MessageUserData) {
                String tagName = (String)plcWriteRequest.getTagNames().toArray()[0];
                responses.put(tagName, PlcResponseCode.OK);
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            throw new PlcProtocolException("Unsupported message type " + responseMessage.getClass().getName());
        }
        if (errorClass != 0 || errorCode != 0) {
            if (errorClass == 129 && errorCode == 4) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that PUT/GET is not enabled on the PLC.");
                for (String tagName : plcWriteRequest.getTagNames()) {
                    responses.put(tagName, PlcResponseCode.ACCESS_DENIED);
                }
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            if (errorClass == 133 && errorCode == 0) {
                logger.warn("Got an error response from the PLC. This particular response code usually indicates that we sent a too large packet or would be receiving a too large one. Please report this, as this is most probably a bug.");
                for (String tagName : plcWriteRequest.getTagNames()) {
                    responses.put(tagName, PlcResponseCode.INTERNAL_ERROR);
                }
                return new DefaultPlcWriteResponse(plcWriteRequest, responses);
            }
            logger.warn("Got an unknown error response from the PLC. Error Class: {}, Error Code {}. We probably need to implement explicit handling for this, so please file a bug-report on https://issues.apache.org/jira/projects/PLC4X and ideally attach a WireShark dump containing a capture of the communication.", (Object)errorClass, (Object)errorCode);
            for (String tagName : plcWriteRequest.getTagNames()) {
                responses.put(tagName, PlcResponseCode.INTERNAL_ERROR);
            }
            return new DefaultPlcWriteResponse(plcWriteRequest, responses);
        }
        S7PayloadWriteVarResponse payload = (S7PayloadWriteVarResponse)responseMessage.getPayload();
        if (plcWriteRequest.getNumberOfTags() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        List<S7VarPayloadStatusItem> payloadItems = payload.getItems();
        int index = 0;
        for (String tagName : plcWriteRequest.getTagNames()) {
            S7VarPayloadStatusItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            responses.put(tagName, responseCode);
            ++index;
        }
        return new DefaultPlcWriteResponse(plcWriteRequest, responses);
    }

    private S7VarPayloadDataItem serializePlcValue(S7Tag tag, PlcValue plcValue) {
        try {
            DataTransportSize transportSize = tag.getDataType().getDataTransportSize();
            int stringLength = tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)tag).getStringLength() : 254;
            ByteBuffer byteBuffer = null;
            if (tag.getDataType() == TransportSize.BYTE && tag.getNumberOfElements() > 1) {
                byteBuffer = ByteBuffer.allocate(tag.getNumberOfElements());
                byteBuffer.put(plcValue.getRaw());
            } else if (tag.getDataType() == TransportSize.BOOL && tag.getNumberOfElements() > 1) {
                if (!(plcValue instanceof PlcList)) {
                    throw new PlcRuntimeException(String.format("Expected a PlcList with %d PlcBOOL elements", tag.getNumberOfElements()));
                }
                PlcList plcList = (PlcList)plcValue;
                int numBytes = (tag.getNumberOfElements() + 7) / 8;
                byteBuffer = ByteBuffer.allocate(numBytes);
                int i = 0;
                while (i < tag.getNumberOfElements()) {
                    if (!(plcList.getIndex(i) instanceof PlcBOOL)) {
                        throw new PlcRuntimeException(String.format("Expected a PlcList with %d PlcBOOL elements", tag.getNumberOfElements()));
                    }
                    PlcBOOL plcBOOL = (PlcBOOL)plcList.getIndex(i);
                    if (plcBOOL.getBoolean()) {
                        int curByte = i / 8;
                        int curBit = i % 8;
                        byteBuffer.put(curByte, (byte)(1 << curBit | byteBuffer.get(curByte)));
                    }
                    ++i;
                }
                transportSize = DataTransportSize.BYTE_WORD_DWORD;
            } else {
                int i = 0;
                while (i < tag.getNumberOfElements()) {
                    int lengthInBits = DataItem.getLengthInBits(plcValue.getIndex(i), tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), stringLength);
                    if (tag.getDataType() == TransportSize.STRING) {
                        lengthInBits = Math.min(lengthInBits, stringLength * 8 + 16);
                    } else if (tag.getDataType() == TransportSize.WSTRING) {
                        lengthInBits = Math.min(lengthInBits, stringLength * 16 + 32);
                    } else if (tag.getDataType() == TransportSize.S5TIME) {
                        lengthInBits *= 8;
                    }
                    WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil((float)lengthInBits / 8.0f));
                    DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue.getIndex(i), tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), stringLength);
                    if (byteBuffer == null) {
                        byteBuffer = ByteBuffer.allocate(writeBuffer.getBytes().length * tag.getNumberOfElements());
                    }
                    byteBuffer.put(writeBuffer.getBytes());
                    ++i;
                }
            }
            if (byteBuffer != null) {
                byte[] data = byteBuffer.array();
                return new S7VarPayloadDataItem(DataTransportErrorCode.OK, transportSize, data);
            }
        }
        catch (SerializationException e) {
            logger.warn("Error serializing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
        }
        return null;
    }

    private PlcValue parsePlcValue(S7Tag tag, byte[] data) {
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data);
        try {
            int stringLength;
            int n = stringLength = tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)tag).getStringLength() : 254;
            if (tag.getNumberOfElements() == 1) {
                return DataItem.staticParse((ReadBuffer)readBuffer, tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), stringLength);
            }
            if (tag.getDataType() == TransportSize.BYTE) {
                return new PlcRawByteArray(data);
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, tag.getNumberOfElements()).mapToObj(arg_0 -> this.lambda$27((ReadBuffer)readBuffer, tag, stringLength, arg_0)).toArray(PlcValue[]::new);
            return DefaultPlcValueHandler.of((PlcTag)tag, (Object[])resultItems);
        }
        catch (ParseException e) {
            logger.warn("Error parsing tag item of type: '{}'", (Object)tag.getDataType().name(), (Object)e);
            return null;
        }
    }

    private PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case INVALID_ADDRESS: 
            case NOT_FOUND: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private ControllerType decodeControllerType(String articleNumber) {
        String model;
        if (!articleNumber.startsWith("6ES7 ")) {
            return ControllerType.ANY;
        }
        switch (model = articleNumber.substring(articleNumber.indexOf(32) + 1, articleNumber.indexOf(32) + 2)) {
            case "2": {
                return ControllerType.S7_1200;
            }
            case "5": {
                return ControllerType.S7_1500;
            }
            case "3": {
                return ControllerType.S7_300;
            }
            case "4": {
                return ControllerType.S7_400;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Looking up unknown article number {}", (Object)articleNumber);
        }
        return ControllerType.ANY;
    }

    protected S7Address encodeS7Address(PlcTag tag) {
        if (!(tag instanceof S7Tag)) {
            throw new PlcRuntimeException("Unsupported address type " + tag.getClass().getName());
        }
        S7Tag s7Tag = (S7Tag)tag;
        TransportSize transportSize = s7Tag.getDataType();
        int numElements = s7Tag.getNumberOfElements();
        if (transportSize == TransportSize.STRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)s7Tag).getStringLength() : 254;
            numElements *= stringLength + 2;
        } else if (transportSize == TransportSize.WSTRING) {
            transportSize = TransportSize.CHAR;
            int stringLength = s7Tag instanceof S7StringFixedLengthTag ? ((S7StringFixedLengthTag)s7Tag).getStringLength() : 254;
            numElements = numElements * (stringLength + 2) * 2;
        } else if (transportSize == TransportSize.BOOL && s7Tag.getNumberOfElements() > 1) {
            numElements = (s7Tag.getNumberOfElements() + 7) / 8;
            transportSize = TransportSize.BYTE;
        }
        if (transportSize.getCode() == 0) {
            numElements *= transportSize.getSizeInBytes();
            transportSize = TransportSize.BYTE;
        }
        return new S7AddressAny(transportSize, numElements, s7Tag.getBlockNumber(), s7Tag.getMemoryArea(), s7Tag.getByteOffset(), s7Tag.getBitOffset());
    }

    private int getTpduId() {
        int tpduId = this.tpduGenerator.getAndIncrement();
        if (this.tpduGenerator.get() == 65535) {
            this.tpduGenerator.set(1);
        }
        return tpduId;
    }

    protected CompletableFuture<Map<S7StringVarLengthTag, StringSizes>> getStringSizes(PlcTagRequest request) {
        CompletableFuture<Map<S7StringVarLengthTag, StringSizes>> future = new CompletableFuture<Map<S7StringVarLengthTag, StringSizes>>();
        List varLengthStringTags = request.getTags().stream().filter(plcTag -> plcTag instanceof S7StringVarLengthTag).map(plcTag -> (S7StringVarLengthTag)plcTag).collect(Collectors.toList());
        ArrayList<S7VarRequestParameterItem> stringFields = new ArrayList<S7VarRequestParameterItem>(varLengthStringTags.size());
        for (S7StringVarLengthTag varLengthStringTag : varLengthStringTags) {
            if (varLengthStringTag.getDataType() == TransportSize.STRING) {
                stringFields.add(new S7VarRequestParameterItemAddress(new S7AddressAny(TransportSize.BYTE, 2, varLengthStringTag.getBlockNumber(), MemoryArea.DATA_BLOCKS, varLengthStringTag.getByteOffset(), varLengthStringTag.getBitOffset())));
                continue;
            }
            if (varLengthStringTag.getDataType() == TransportSize.WSTRING) {
                stringFields.add(new S7VarRequestParameterItemAddress(new S7AddressAny(TransportSize.BYTE, 4, varLengthStringTag.getBlockNumber(), MemoryArea.DATA_BLOCKS, varLengthStringTag.getByteOffset(), varLengthStringTag.getBitOffset())));
                continue;
            }
            throw new PlcInvalidTagException("Only STRING and WSTRING allowed here.");
        }
        S7MessageRequest readRequest = new S7MessageRequest(this.getTpduId(), new S7ParameterReadVarRequest(stringFields), null);
        CompletableFuture<S7Message> resolveSizesRequestFuture = this.sendInternal(readRequest);
        resolveSizesRequestFuture.whenComplete((s7Message, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)new PlcProtocolException("Error resolving string sizes", throwable));
                return;
            }
            HashMap<S7StringVarLengthTag, StringSizes> stringLengths = new HashMap<S7StringVarLengthTag, StringSizes>(varLengthStringTags.size());
            S7PayloadReadVarResponse getLengthsResponse = (S7PayloadReadVarResponse)s7Message.getPayload();
            int curItemIndex = 0;
            for (S7StringVarLengthTag varLengthStringTag : varLengthStringTags) {
                S7VarPayloadDataItem s7VarPayloadDataItem = getLengthsResponse.getItems().get(curItemIndex);
                if (s7VarPayloadDataItem.getReturnCode() != DataTransportErrorCode.OK) continue;
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(s7VarPayloadDataItem.getData());
                try {
                    int actualChars;
                    int maxChars;
                    if (varLengthStringTag.getDataType() == TransportSize.STRING) {
                        maxChars = readBuffer.readUnsignedInt("maxLength", 8, new WithReaderArgs[0]);
                        actualChars = readBuffer.readUnsignedInt("maxLength", 8, new WithReaderArgs[0]);
                        stringLengths.put(varLengthStringTag, new StringSizes(maxChars, actualChars));
                        continue;
                    }
                    if (varLengthStringTag.getDataType() == TransportSize.WSTRING) {
                        maxChars = readBuffer.readUnsignedInt("maxLength", 16, new WithReaderArgs[0]);
                        actualChars = readBuffer.readUnsignedInt("maxLength", 16, new WithReaderArgs[0]);
                        stringLengths.put(varLengthStringTag, new StringSizes(maxChars, actualChars));
                        continue;
                    }
                    throw new PlcInvalidTagException("Only STRING and WSTRING allowed here.");
                }
                catch (ParseException e) {
                    throw new PlcInvalidTagException("Error parsing var-length string actual lengths.");
                }
            }
            future.complete(stringLengths);
        });
        return future;
    }

    private /* synthetic */ PlcValue lambda$27(ReadBuffer readBuffer, S7Tag s7Tag, int n, int i) {
        try {
            return DataItem.staticParse(readBuffer, s7Tag.getDataType().getDataProtocolId(), this.s7DriverContext.getControllerType(), n);
        }
        catch (ParseException e) {
            logger.warn("Error parsing tag item of type: '{}' (at position {}})", new Object[]{s7Tag.getDataType().name(), i, e});
            return null;
        }
    }

    public static class StringSizes {
        private final int maxLength;
        private final int curLength;

        public StringSizes(int maxLength, int curLength) {
            this.maxLength = maxLength;
            this.curLength = curLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getCurLength() {
            return this.curLength;
        }
    }

    static class TransactionErrorCallback<T, E extends Throwable>
    implements Consumer<TimeoutException>,
    BiConsumer<TPKTPacket, E> {
        private final CompletableFuture<T> future;
        private final RequestTransactionManager.RequestTransaction transaction;

        TransactionErrorCallback(CompletableFuture<T> future, RequestTransactionManager.RequestTransaction transaction) {
            this.future = future;
            this.transaction = transaction;
        }

        @Override
        public void accept(TimeoutException e) {
            try {
                this.transaction.endRequest();
            }
            catch (Exception ex) {
                logger.info(ex.getMessage());
            }
            this.future.completeExceptionally(e);
        }

        @Override
        public void accept(TPKTPacket tpktPacket, E e) {
            try {
                this.transaction.endRequest();
            }
            catch (Exception ex) {
                logger.info(ex.getMessage());
            }
            this.future.completeExceptionally((Throwable)e);
        }
    }
}

