/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.time.LocalTime;
import java.util.List;
import org.apache.plc4x.java.s7.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HMux;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.apache.plc4x.java.spi.events.DisconnectedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class S7HMuxImpl
extends MessageToMessageCodec<ByteBuf, ByteBuf>
implements S7HMux {
    private static final Logger logger = LoggerFactory.getLogger(S7HMuxImpl.class);
    static final AttributeKey<Boolean> IS_CONNECTED = AttributeKey.valueOf((String)"IS_CONNECTED");
    static final AttributeKey<Boolean> WAS_CONNECTED = AttributeKey.valueOf((String)"WAS_CONNECTED");
    static final AttributeKey<Boolean> IS_PRIMARY = AttributeKey.valueOf((String)"IS_PRIMARY");
    static final AttributeKey<Integer> READ_TIME_OUT = AttributeKey.valueOf((String)"READ_TIME_OUT");
    static final AttributeKey<Boolean> IS_PING_ACTIVE = AttributeKey.valueOf((String)"IS_PIN_ACTIVE");
    static final AttributeKey<Integer> PING_TIME = AttributeKey.valueOf((String)"PING_TIME");
    static final AttributeKey<Integer> RETRY_TIME = AttributeKey.valueOf((String)"RETRY_TIME");
    ChannelHandlerContext embedCtx = null;
    protected Channel embededChannel = null;
    protected Channel tcpChannel = null;
    protected Channel primaryChannel = null;
    protected Channel secondaryChannel = null;

    protected void encode(ChannelHandlerContext ctx, ByteBuf outBB, List<Object> list) {
        if (this.embedCtx == null && ctx.channel() instanceof EmbeddedChannel) {
            this.embedCtx = ctx;
        }
        if (this.tcpChannel != null && this.embedCtx == ctx) {
            this.tcpChannel.writeAndFlush((Object)outBB.copy());
        }
        list.add(outBB.copy());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf inBB, List<Object> list) throws Exception {
        this.embedCtx.fireChannelRead((Object)inBB.copy());
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        logger.debug("channelRegistered: " + ctx.name());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        logger.debug("exceptionCaught: " + ctx.name());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        logger.debug("channelWritabilityChanged: " + ctx.name());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.info(LocalTime.now() + " userEventTriggered: " + ctx.name() + " Event: " + evt);
        if (evt instanceof ConnectedEvent) {
            try {
                ChannelHandler watchdog = this.tcpChannel.pipeline().get("watchdog");
                if (watchdog != null) {
                    this.tcpChannel.pipeline().remove(watchdog);
                }
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
            try {
                if ((Integer)this.embededChannel.attr(READ_TIME_OUT).get() > 0 && ((Boolean)this.embededChannel.attr(IS_PING_ACTIVE).get()).booleanValue()) {
                    this.tcpChannel.pipeline().addFirst("watchdog", (ChannelHandler)new ReadTimeoutHandler(((Integer)this.embededChannel.attr(READ_TIME_OUT).get()).intValue()));
                }
                if (this.tcpChannel.isActive()) {
                    this.embededChannel.attr(IS_CONNECTED).set((Object)true);
                } else {
                    this.embededChannel.attr(IS_CONNECTED).set((Object)false);
                }
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
        }
        boolean cfr_ignored_0 = evt instanceof DisconnectEvent;
        super.userEventTriggered(ctx, evt);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        logger.debug(LocalTime.now() + " channelReadComplete: " + ctx.name());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        logger.debug("channelInactive: " + ctx.name());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.debug("channelActive: " + ctx.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        Channel channel;
        super.channelUnregistered(ctx);
        logger.debug("{} channelUnregistered: {}", (Object)LocalTime.now(), (Object)ctx.name());
        String strCanal = this.tcpChannel == this.primaryChannel ? "PRIMARY" : "SECONDARY";
        logger.info("Unregistered of channel: {}", (Object)strCanal);
        if (ctx == this.embedCtx) {
            return;
        }
        if (this.tcpChannel == ctx.channel()) {
            this.embededChannel.attr(IS_CONNECTED).set((Object)false);
            this.embededChannel.attr(WAS_CONNECTED).set((Object)true);
            this.embededChannel.pipeline().fireUserEventTriggered((Object)new DisconnectedEvent());
        }
        if (this.embedCtx != null) {
            logger.info(this.embedCtx.executor().toString());
        }
        if (this.tcpChannel == this.primaryChannel && this.primaryChannel == ctx.channel() && !this.primaryChannel.isActive() && this.secondaryChannel != null && this.secondaryChannel.isActive()) {
            channel = this.tcpChannel;
            synchronized (channel) {
                logger.info("Using secondary TCP channel.");
                this.tcpChannel = this.secondaryChannel;
                this.embededChannel.attr(IS_PRIMARY).set((Object)false);
                this.embededChannel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
            }
        }
        if (this.tcpChannel == this.secondaryChannel && this.secondaryChannel == ctx.channel() && !this.secondaryChannel.isActive() && this.primaryChannel != null && this.primaryChannel.isActive()) {
            channel = this.tcpChannel;
            synchronized (channel) {
                logger.info("Using primary TCP channel.");
                this.tcpChannel = this.primaryChannel;
                this.embededChannel.attr(IS_PRIMARY).set((Object)true);
                this.embededChannel.pipeline().fireUserEventTriggered((Object)new ConnectEvent());
            }
        }
    }

    @Override
    public void setEmbededhannel(Channel embeded_channel, PlcConnectionConfiguration configuration) {
        S7Configuration conf = (S7Configuration)configuration;
        this.embededChannel = embeded_channel;
        this.embededChannel.attr(IS_CONNECTED).set((Object)false);
        this.embededChannel.attr(WAS_CONNECTED).set((Object)false);
        this.embededChannel.attr(IS_PRIMARY).set((Object)true);
        this.embededChannel.attr(READ_TIME_OUT).set((Object)conf.getReadTimeout());
        this.embededChannel.attr(IS_PING_ACTIVE).set((Object)conf.getPing());
        this.embededChannel.attr(PING_TIME).set((Object)conf.getPingTime());
        this.embededChannel.attr(RETRY_TIME).set((Object)conf.getRetryTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimaryChannel(Channel primary_channel) {
        if (this.primaryChannel == null && this.tcpChannel == null) {
            if (primary_channel != null) {
                this.primaryChannel = primary_channel;
                this.tcpChannel = primary_channel;
                this.embededChannel.attr(IS_PRIMARY).set((Object)true);
            }
        } else if (this.primaryChannel == null || this.tcpChannel == this.secondaryChannel && this.tcpChannel.isActive()) {
            this.primaryChannel = primary_channel;
        } else if (!this.primaryChannel.isActive() && this.tcpChannel == this.secondaryChannel) {
            this.primaryChannel = primary_channel;
        } else {
            if (!this.primaryChannel.isActive() && this.tcpChannel == this.primaryChannel || primary_channel.isActive()) {
                Channel channel = this.tcpChannel;
                synchronized (channel) {
                    this.tcpChannel.close();
                    this.primaryChannel = primary_channel;
                    this.tcpChannel = primary_channel;
                    this.embededChannel.attr(IS_PRIMARY).set((Object)true);
                    if (this.tcpChannel.isActive()) {
                        logger.info("Reassigns the inactive primary channel and send ConnectEvent..");
                        this.embedCtx.fireUserEventTriggered((Object)new ConnectEvent());
                    }
                }
            }
            if (primary_channel.isActive()) {
                Channel channel = this.tcpChannel;
                synchronized (channel) {
                    this.tcpChannel.close();
                    this.primaryChannel = primary_channel;
                    this.tcpChannel = primary_channel;
                    this.embededChannel.attr(IS_PRIMARY).set((Object)true);
                    logger.info("Reassigns the primary channel and send ConnectEvent.");
                    if (this.tcpChannel.isActive()) {
                        this.embedCtx.fireUserEventTriggered((Object)new ConnectEvent());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecondaryChannel(Channel secondary_channel) {
        if (this.primaryChannel == null && this.tcpChannel == null) {
            if (secondary_channel != null) {
                this.secondaryChannel = secondary_channel;
                this.tcpChannel = secondary_channel;
                this.embededChannel.attr(IS_PRIMARY).set((Object)false);
            }
        } else if (this.secondaryChannel == null || this.tcpChannel == this.primaryChannel && this.tcpChannel.isActive()) {
            this.secondaryChannel = secondary_channel;
        } else if (!this.secondaryChannel.isActive() && this.tcpChannel == this.primaryChannel) {
            this.secondaryChannel = secondary_channel;
        } else if (!this.secondaryChannel.isActive() && this.tcpChannel == this.secondaryChannel || secondary_channel.isActive()) {
            Channel channel = this.tcpChannel;
            synchronized (channel) {
                this.tcpChannel.close();
                this.secondaryChannel = secondary_channel;
                this.tcpChannel = secondary_channel;
                this.embededChannel.attr(IS_PRIMARY).set((Object)false);
            }
            if (this.tcpChannel.isActive()) {
                this.embedCtx.fireUserEventTriggered((Object)new ConnectEvent());
            }
        }
    }

    @Override
    public Channel getTCPChannel() {
        return this.tcpChannel;
    }
}

