/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TPKTPacket
implements Message {
    public static final Short PROTOCOLID = 3;
    protected final COTPPacket payload;

    public TPKTPacket(COTPPacket payload) {
        this.payload = payload;
    }

    public COTPPacket getPayload() {
        return this.payload;
    }

    public short getProtocolId() {
        return PROTOCOLID;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TPKTPacket", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"protocolId", (Object)PROTOCOLID, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int len = this.getPayload().getLengthInBytes() + 4;
        FieldWriterFactory.writeImplicitField((String)"len", (Object)len, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"payload", (Object)this.payload, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("TPKTPacket", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        TPKTPacket _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static TPKTPacket staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("TPKTPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short protocolId = (Short)FieldReaderFactory.readConstField((String)"protocolId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)PROTOCOLID, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        Short reservedField0 = (Short)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (Object)0, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int len = (Integer)FieldReaderFactory.readImplicitField((String)"len", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        COTPPacket payload = (COTPPacket)FieldReaderFactory.readSimpleField((String)"payload", (DataReader)DataReaderFactory.readComplex(() -> COTPPacket.staticParse(readBuffer, len - 4), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("TPKTPacket", new WithReaderArgs[0]);
        TPKTPacket _tPKTPacket = new TPKTPacket(payload);
        return _tPKTPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TPKTPacket)) {
            return false;
        }
        TPKTPacket that = (TPKTPacket)o;
        return this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

