/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum MemoryArea {
    COUNTERS(28, "C"),
    TIMERS(29, "T"),
    DIRECT_PERIPHERAL_ACCESS(128, "D"),
    INPUTS(129, "I"),
    OUTPUTS(130, "Q"),
    FLAGS_MARKERS(131, "M"),
    DATA_BLOCKS(132, "DB"),
    INSTANCE_DATA_BLOCKS(133, "DBI"),
    LOCAL_DATA(134, "LD");

    private static final Map<Short, MemoryArea> map;
    private final short value;
    private final String shortName;

    static {
        map = new HashMap<Short, MemoryArea>();
        MemoryArea[] memoryAreaArray = MemoryArea.values();
        int n = memoryAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryArea value = memoryAreaArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private MemoryArea(short value, String shortName) {
        this.value = value;
        this.shortName = shortName;
    }

    public short getValue() {
        return this.value;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static MemoryArea firstEnumForFieldShortName(String fieldValue) {
        MemoryArea[] memoryAreaArray = MemoryArea.values();
        int n = memoryAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryArea _val = memoryAreaArray[n2];
            if (_val.getShortName().equals(fieldValue)) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<MemoryArea> enumsForFieldShortName(String fieldValue) {
        ArrayList<MemoryArea> _values = new ArrayList<MemoryArea>();
        MemoryArea[] memoryAreaArray = MemoryArea.values();
        int n = memoryAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryArea _val = memoryAreaArray[n2];
            if (_val.getShortName().equals(fieldValue)) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static MemoryArea enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

