/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.events;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.plc4x.java.api.messages.PlcMetadataKeys;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.metadata.time.TimeSource;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7Event;
import org.apache.plc4x.java.s7.events.S7EventBase;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.tag.S7SubscriptionTag;
import org.apache.plc4x.java.s7.readwrite.tag.S7Tag;
import org.apache.plc4x.java.s7.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.metadata.DefaultMetadata;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.values.DefaultPlcValueHandler;

public class S7CyclicEvent
extends S7EventBase
implements S7Event {
    private final PlcSubscriptionRequest request;
    private final Map<String, Object> map = new HashMap<String, Object>();

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesPush event) {
        super(Instant.now(), new DefaultMetadata.Builder().put(PlcMetadataKeys.TIMESTAMP_SOURCE, (Object)TimeSource.ASSUMPTION).build());
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.getTimestamp());
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            this.map.put((String)tagname, S7CyclicEvent.dataToPlcValue(tagname, request, event.getItems().get(i).getData()));
            nArray[0] = n[0] + 1;
        });
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesChangeDrivenPush event) {
        super(Instant.now(), new DefaultMetadata.Builder().put(PlcMetadataKeys.TIMESTAMP_SOURCE, (Object)TimeSource.ASSUMPTION).build());
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.getTimestamp());
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            this.map.put((String)tagname, S7CyclicEvent.dataToPlcValue(tagname, request, event.getItems().get(i).getData()));
            nArray[0] = n[0] + 1;
        });
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesSubscribeResponse event) {
        super(Instant.now(), new DefaultMetadata.Builder().put(PlcMetadataKeys.TIMESTAMP_SOURCE, (Object)TimeSource.ASSUMPTION).build());
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.getTimestamp());
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            this.map.put((String)tagname, S7CyclicEvent.dataToPlcValue(tagname, request, event.getItems().get(i).getData()));
            nArray[0] = n[0] + 1;
        });
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse event) {
        super(Instant.now(), new DefaultMetadata.Builder().put(PlcMetadataKeys.TIMESTAMP_SOURCE, (Object)TimeSource.ASSUMPTION).build());
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.getTimestamp());
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            this.map.put((String)tagname, S7CyclicEvent.dataToPlcValue(tagname, request, event.getItems().get(i).getData()));
            nArray[0] = n[0] + 1;
        });
    }

    @Override
    public Map<String, Object> getMap() {
        return this.map;
    }

    public PlcReadRequest getRequest() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcValue getAsPlcValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcValue getPlcValue(String name) {
        if (this.request.getTagNames().contains(name)) {
            PlcValue plcvalue = (PlcValue)this.map.get(name);
            plcvalue.getRaw();
            return plcvalue;
        }
        return null;
    }

    public int getNumberOfValues(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getObject(String name) {
        if ("REQUEST".equals(name)) {
            return this.request;
        }
        return null;
    }

    public Object getObject(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Object> getAllObjects(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBoolean(String name) {
        return this.isValidBoolean(name, 0);
    }

    public boolean isValidBoolean(String name, int index) {
        try {
            this.getBoolean(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, 0);
    }

    public Boolean getBoolean(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        return byteBuf.getBoolean(index);
    }

    public Collection<Boolean> getAllBooleans(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidByte(String name) {
        return this.isValidByte(name, 0);
    }

    public boolean isValidByte(String name, int index) {
        try {
            this.getByte(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Byte getByte(String name) {
        return this.getByte(name, 0);
    }

    public Byte getByte(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 1;
        return byteBuf.getByte(pos);
    }

    public Collection<Byte> getAllBytes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        byte[] array = (byte[])this.map.get(name);
        return IntStream.range(0, array.length).mapToObj(i -> array[i]).collect(Collectors.toList());
    }

    public boolean isValidShort(String name) {
        return this.isValidShort(name, 0);
    }

    public boolean isValidShort(String name, int index) {
        try {
            this.getShort(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Short getShort(String name) {
        return this.getShort(name, 0);
    }

    public Short getShort(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 2;
        return byteBuf.getShort(pos);
    }

    public Collection<Short> getAllShorts(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Short> list = new ArrayList<Short>();
        while (byteBuf.isReadable(2)) {
            list.add(byteBuf.readShort());
        }
        return list;
    }

    public boolean isValidInteger(String name) {
        return this.isValidInteger(name, 0);
    }

    public boolean isValidInteger(String name, int index) {
        try {
            this.getInteger(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public Integer getInteger(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 4;
        return byteBuf.getInt(pos);
    }

    public Collection<Integer> getAllIntegers(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (byteBuf.isReadable(4)) {
            list.add(byteBuf.readInt());
        }
        return list;
    }

    public boolean isValidBigInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBigInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigInteger getBigInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigInteger getBigInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<BigInteger> getAllBigIntegers(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidLong(String name) {
        return this.isValidLong(name, 0);
    }

    public boolean isValidLong(String name, int index) {
        try {
            this.getLong(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Long getLong(String name) {
        return this.getLong(name, 0);
    }

    public Long getLong(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 8;
        return byteBuf.getLong(pos);
    }

    public Collection<Long> getAllLongs(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Long> list = new ArrayList<Long>();
        while (byteBuf.isReadable(8)) {
            list.add(byteBuf.readLong());
        }
        return list;
    }

    public boolean isValidFloat(String name) {
        return this.isValidFloat(name, 0);
    }

    public boolean isValidFloat(String name, int index) {
        try {
            this.getFloat(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Float getFloat(String name) {
        return this.getFloat(name, 0);
    }

    public Float getFloat(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 4;
        return Float.valueOf(byteBuf.getFloat(pos));
    }

    public Collection<Float> getAllFloats(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Float> list = new ArrayList<Float>();
        while (byteBuf.isReadable(4)) {
            list.add(Float.valueOf(byteBuf.readFloat()));
        }
        return list;
    }

    public boolean isValidDouble(String name) {
        return this.isValidDouble(name, 0);
    }

    public boolean isValidDouble(String name, int index) {
        try {
            this.getDouble(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Double getDouble(String name) {
        return this.getDouble(name, 0);
    }

    public Double getDouble(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 8;
        return byteBuf.getDouble(pos);
    }

    public Collection<Double> getAllDoubles(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        ArrayList<Double> list = new ArrayList<Double>();
        while (byteBuf.isReadable(8)) {
            list.add(byteBuf.readDouble());
        }
        return list;
    }

    public boolean isValidBigDecimal(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidBigDecimal(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigDecimal getBigDecimal(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigDecimal getBigDecimal(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<BigDecimal> getAllBigDecimals(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidString(String name) {
        return this.isValidString(name, 0);
    }

    public boolean isValidString(String name, int index) {
        try {
            this.getString(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getString(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        return byteBuf.toString(Charset.defaultCharset());
    }

    public String getString(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getAllStrings(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isValidTime(String name) {
        return this.isValidTime(name, 0);
    }

    public boolean isValidTime(String name, int index) {
        try {
            this.getTime(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public LocalTime getTime(String name) {
        return this.getTime(name, 0);
    }

    public LocalTime getTime(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 4;
        int value = byteBuf.getInt(pos);
        Duration dr = StaticHelper.s7TimeToDuration(value);
        return LocalTime.of(dr.toHoursPart(), dr.toMinutesPart(), dr.toSecondsPart(), dr.toNanosPart());
    }

    public Collection<LocalTime> getAllTimes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int nitems = byteBuf.capacity() / 4;
        ArrayList<LocalTime> items = new ArrayList<LocalTime>();
        int i = 0;
        while (i < nitems) {
            items.add(this.getTime(name, i));
            ++i;
        }
        return items;
    }

    public boolean isValidDate(String name) {
        return this.isValidDate(name, 0);
    }

    public boolean isValidDate(String name, int index) {
        try {
            this.getDate(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public LocalDate getDate(String name) {
        return this.getDate(name, 0);
    }

    public LocalDate getDate(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 2;
        short value = byteBuf.getShort(pos);
        return StaticHelper.s7DateToLocalDate(value);
    }

    public Collection<LocalDate> getAllDates(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int nItems = byteBuf.capacity() / 2;
        ArrayList<LocalDate> items = new ArrayList<LocalDate>();
        int i = 0;
        while (i < nItems) {
            items.add(this.getDate(name, i));
            ++i;
        }
        return items;
    }

    public boolean isValidDateTime(String name) {
        return this.isValidDateTime(name, 0);
    }

    public boolean isValidDateTime(String name, int index) {
        try {
            this.getDateTime(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public LocalDateTime getDateTime(String name) {
        return this.getDateTime(name, 0);
    }

    public LocalDateTime getDateTime(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int pos = index * 8;
        return StaticHelper.s7DateTimeToLocalDateTime(byteBuf.slice(pos, 8));
    }

    public Collection<LocalDateTime> getAllDateTimes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])this.map.get(name)));
        int nitems = byteBuf.capacity() / 8;
        ArrayList<LocalDateTime> items = new ArrayList<LocalDateTime>();
        int i = 0;
        while (i < nitems) {
            items.add(this.getDateTime(name, i));
            ++i;
        }
        return items;
    }

    public Collection<String> getTagNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcTag getTag(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcResponseCode getResponseCode(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S7CyclicEvent other = (S7CyclicEvent)obj;
        for (String tag : this.request.getTagNames()) {
            PlcValue othervalue = other.getPlcValue(tag);
            if (othervalue == null) {
                return false;
            }
            PlcValue localvalue = this.getPlcValue(tag);
            if (Arrays.equals(localvalue.getRaw(), othervalue.getRaw())) continue;
            return false;
        }
        return true;
    }

    private static PlcValue dataToPlcValue(String tagname, PlcSubscriptionRequest request, List<Short> data) {
        int[] i = new int[1];
        byte[] buffer = new byte[data.size()];
        data.forEach(b -> {
            byArray[nArray[0]] = b.byteValue();
            nArray[0] = i[0] + 1;
        });
        ByteBuf bb = Unpooled.wrappedBuffer((byte[])buffer);
        DefaultPlcSubscriptionTag dpst = (DefaultPlcSubscriptionTag)request.getTag(tagname);
        S7SubscriptionTag subTag = (S7SubscriptionTag)dpst.getTag();
        S7Tag[] s7Tags = subTag.getS7Tags();
        PlcValue plcValue = null;
        switch (s7Tags[0].getDataType()) {
            case BOOL: {
                Object[] bools = new Boolean[s7Tags[0].getNumberOfElements()];
                int iter = 0;
                while (iter < s7Tags[0].getNumberOfElements()) {
                    bools[iter] = bb.readBoolean();
                    ++iter;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])bools);
                break;
            }
            case BYTE: {
                Object[] bytes = new Byte[bb.capacity()];
                byte[] byArray = bb.array();
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b2 = byArray[n2];
                    b2 = bb.readByte();
                    ++n2;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])bytes);
                break;
            }
            case WORD: {
                break;
            }
            case DWORD: {
                break;
            }
            case LWORD: {
                break;
            }
            case INT: {
                Object[] shorts = new Short[s7Tags[0].getNumberOfElements()];
                int iter = 0;
                while (iter < s7Tags[0].getNumberOfElements()) {
                    shorts[iter] = bb.readShort();
                    ++iter;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])shorts);
                break;
            }
            case UINT: {
                break;
            }
            case SINT: {
                break;
            }
            case USINT: {
                break;
            }
            case DINT: {
                Object[] integers;
                Object[] objectArray = integers = new Integer[bb.capacity() / 32];
                int n = integers.length;
                int n3 = 0;
                while (n3 < n) {
                    Integer di = objectArray[n3];
                    di = bb.readInt();
                    ++n3;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])integers);
                break;
            }
            case UDINT: {
                break;
            }
            case LINT: {
                Object[] longs;
                Object[] objectArray = longs = new Long[bb.capacity() / 64];
                int n = longs.length;
                int n4 = 0;
                while (n4 < n) {
                    Long l = objectArray[n4];
                    l = bb.readLong();
                    ++n4;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])longs);
                break;
            }
            case ULINT: {
                break;
            }
            case REAL: {
                Object[] floats;
                Object[] objectArray = floats = new Float[bb.capacity() / 32];
                int n = floats.length;
                int n5 = 0;
                while (n5 < n) {
                    Float f = objectArray[n5];
                    f = Float.valueOf(bb.readFloat());
                    ++n5;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])floats);
                break;
            }
            case LREAL: {
                Object[] doubles;
                Object[] objectArray = doubles = new Double[bb.capacity() / 64];
                int n = doubles.length;
                int n6 = 0;
                while (n6 < n) {
                    Double d = objectArray[n6];
                    d = bb.readDouble();
                    ++n6;
                }
                plcValue = DefaultPlcValueHandler.of((PlcTag)s7Tags[0], (Object[])doubles);
                break;
            }
            case CHAR: {
                break;
            }
            case WCHAR: {
                break;
            }
            case STRING: {
                break;
            }
            case WSTRING: {
                break;
            }
            case S5TIME: {
                break;
            }
            case TIME: {
                break;
            }
            case LTIME: {
                break;
            }
            case DATE: {
                break;
            }
            case TIME_OF_DAY: {
                break;
            }
            case TOD: {
                break;
            }
            case LTIME_OF_DAY: {
                break;
            }
            case LTOD: {
                break;
            }
            case DATE_AND_TIME: {
                break;
            }
            case DT: {
                break;
            }
            case DATE_AND_LTIME: {
                break;
            }
            case LDT: {
                break;
            }
        }
        return plcValue;
    }

    public static enum Fields {
        TYPE,
        JOBID,
        TIMESTAMP,
        ITEMSCOUNT,
        REQUEST,
        MAP,
        RETURNCODE_,
        TRANSPORTSIZE_,
        DATA_;

    }
}

