/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CycServiceItemAnyType extends CycServiceItemType implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final TransportSize transportSize;
  protected final int length;
  protected final int dbNumber;
  protected final MemoryArea memoryArea;
  protected final int address;

  public CycServiceItemAnyType(
      short byteLength,
      short syntaxId,
      TransportSize transportSize,
      int length,
      int dbNumber,
      MemoryArea memoryArea,
      int address) {
    super(byteLength, syntaxId);
    this.transportSize = transportSize;
    this.length = length;
    this.dbNumber = dbNumber;
    this.memoryArea = memoryArea;
    this.address = address;
  }

  public TransportSize getTransportSize() {
    return transportSize;
  }

  public int getLength() {
    return length;
  }

  public int getDbNumber() {
    return dbNumber;
  }

  public MemoryArea getMemoryArea() {
    return memoryArea;
  }

  public int getAddress() {
    return address;
  }

  @Override
  protected void serializeCycServiceItemTypeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CycServiceItemAnyType");

    // Enum field (transportSize)
    writeEnumField(
        "transportSize",
        "TransportSize",
        transportSize,
        new DataWriterEnumDefault<>(
            TransportSize::getCode, TransportSize::name, writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (length)
    writeSimpleField("length", length, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dbNumber)
    writeSimpleField("dbNumber", dbNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (memoryArea)
    writeSimpleEnumField(
        "memoryArea",
        "MemoryArea",
        memoryArea,
        new DataWriterEnumDefault<>(
            MemoryArea::getValue, MemoryArea::name, writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (address)
    writeSimpleField("address", address, writeUnsignedInt(writeBuffer, 24));

    writeBuffer.popContext("CycServiceItemAnyType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CycServiceItemAnyType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Enum Field (transportSize)
    lengthInBits += 8;

    // Simple field (length)
    lengthInBits += 16;

    // Simple field (dbNumber)
    lengthInBits += 16;

    // Simple field (memoryArea)
    lengthInBits += 8;

    // Simple field (address)
    lengthInBits += 24;

    return lengthInBits;
  }

  public static CycServiceItemTypeBuilder staticParseCycServiceItemTypeBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CycServiceItemAnyType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    TransportSize transportSize =
        readEnumField(
            "transportSize",
            "TransportSize",
            readEnum(TransportSize::firstEnumForFieldCode, readUnsignedShort(readBuffer, 8)));

    int length = readSimpleField("length", readUnsignedInt(readBuffer, 16));

    int dbNumber = readSimpleField("dbNumber", readUnsignedInt(readBuffer, 16));

    MemoryArea memoryArea =
        readEnumField(
            "memoryArea",
            "MemoryArea",
            new DataReaderEnumDefault<>(
                MemoryArea::enumForValue, readUnsignedShort(readBuffer, 8)));

    int address = readSimpleField("address", readUnsignedInt(readBuffer, 24));

    readBuffer.closeContext("CycServiceItemAnyType");
    // Create the instance
    return new CycServiceItemAnyTypeBuilderImpl(
        transportSize, length, dbNumber, memoryArea, address);
  }

  public static class CycServiceItemAnyTypeBuilderImpl
      implements CycServiceItemType.CycServiceItemTypeBuilder {
    private final TransportSize transportSize;
    private final int length;
    private final int dbNumber;
    private final MemoryArea memoryArea;
    private final int address;

    public CycServiceItemAnyTypeBuilderImpl(
        TransportSize transportSize, int length, int dbNumber, MemoryArea memoryArea, int address) {
      this.transportSize = transportSize;
      this.length = length;
      this.dbNumber = dbNumber;
      this.memoryArea = memoryArea;
      this.address = address;
    }

    public CycServiceItemAnyType build(short byteLength, short syntaxId) {
      CycServiceItemAnyType cycServiceItemAnyType =
          new CycServiceItemAnyType(
              byteLength, syntaxId, transportSize, length, dbNumber, memoryArea, address);
      return cycServiceItemAnyType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CycServiceItemAnyType)) {
      return false;
    }
    CycServiceItemAnyType that = (CycServiceItemAnyType) o;
    return (getTransportSize() == that.getTransportSize())
        && (getLength() == that.getLength())
        && (getDbNumber() == that.getDbNumber())
        && (getMemoryArea() == that.getMemoryArea())
        && (getAddress() == that.getAddress())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getTransportSize(),
        getLength(),
        getDbNumber(),
        getMemoryArea(),
        getAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
