/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7PayloadUserDataItemCpuFunctionAlarmQueryRequest extends S7PayloadUserDataItem
    implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionGroup() {
    return (byte) 0x04;
  }

  public Byte getCpuFunctionType() {
    return (byte) 0x04;
  }

  public Short getCpuSubfunction() {
    return (short) 0x13;
  }

  // Constant values.
  public static final Short FUNCTIONID = 0x00;
  public static final Short NUMBERMESSAGEOBJ = 0x01;
  public static final Short VARIABLESPEC = 0x12;
  public static final Short LENGTH = 0x08;

  // Properties.
  protected final SyntaxIdType syntaxId;
  protected final QueryType queryType;
  protected final AlarmType alarmType;

  public S7PayloadUserDataItemCpuFunctionAlarmQueryRequest(
      DataTransportErrorCode returnCode,
      DataTransportSize transportSize,
      int dataLength,
      SyntaxIdType syntaxId,
      QueryType queryType,
      AlarmType alarmType) {
    super(returnCode, transportSize, dataLength);
    this.syntaxId = syntaxId;
    this.queryType = queryType;
    this.alarmType = alarmType;
  }

  public SyntaxIdType getSyntaxId() {
    return syntaxId;
  }

  public QueryType getQueryType() {
    return queryType;
  }

  public AlarmType getAlarmType() {
    return alarmType;
  }

  public short getFunctionId() {
    return FUNCTIONID;
  }

  public short getNumberMessageObj() {
    return NUMBERMESSAGEOBJ;
  }

  public short getVariableSpec() {
    return VARIABLESPEC;
  }

  public short getLength() {
    return LENGTH;
  }

  @Override
  protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("S7PayloadUserDataItemCpuFunctionAlarmQueryRequest");

    // Const Field (functionId)
    writeConstField("functionId", FUNCTIONID, writeUnsignedShort(writeBuffer, 8));

    // Const Field (numberMessageObj)
    writeConstField("numberMessageObj", NUMBERMESSAGEOBJ, writeUnsignedShort(writeBuffer, 8));

    // Const Field (variableSpec)
    writeConstField("variableSpec", VARIABLESPEC, writeUnsignedShort(writeBuffer, 8));

    // Const Field (length)
    writeConstField("length", LENGTH, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (syntaxId)
    writeSimpleEnumField(
        "syntaxId",
        "SyntaxIdType",
        syntaxId,
        new DataWriterEnumDefault<>(
            SyntaxIdType::getValue, SyntaxIdType::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (queryType)
    writeSimpleEnumField(
        "queryType",
        "QueryType",
        queryType,
        new DataWriterEnumDefault<>(
            QueryType::getValue, QueryType::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x34, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (alarmType)
    writeSimpleEnumField(
        "alarmType",
        "AlarmType",
        alarmType,
        new DataWriterEnumDefault<>(
            AlarmType::getValue, AlarmType::name, writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("S7PayloadUserDataItemCpuFunctionAlarmQueryRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7PayloadUserDataItemCpuFunctionAlarmQueryRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (functionId)
    lengthInBits += 8;

    // Const Field (numberMessageObj)
    lengthInBits += 8;

    // Const Field (variableSpec)
    lengthInBits += 8;

    // Const Field (length)
    lengthInBits += 8;

    // Simple field (syntaxId)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (queryType)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (alarmType)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static S7PayloadUserDataItemBuilder staticParseS7PayloadUserDataItemBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionGroup, Byte cpuFunctionType, Short cpuSubfunction)
      throws ParseException {
    readBuffer.pullContext("S7PayloadUserDataItemCpuFunctionAlarmQueryRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short functionId =
        readConstField(
            "functionId",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQueryRequest.FUNCTIONID);

    short numberMessageObj =
        readConstField(
            "numberMessageObj",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQueryRequest.NUMBERMESSAGEOBJ);

    short variableSpec =
        readConstField(
            "variableSpec",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQueryRequest.VARIABLESPEC);

    short length =
        readConstField(
            "length",
            readUnsignedShort(readBuffer, 8),
            S7PayloadUserDataItemCpuFunctionAlarmQueryRequest.LENGTH);

    SyntaxIdType syntaxId =
        readEnumField(
            "syntaxId",
            "SyntaxIdType",
            new DataReaderEnumDefault<>(
                SyntaxIdType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    QueryType queryType =
        readEnumField(
            "queryType",
            "QueryType",
            new DataReaderEnumDefault<>(QueryType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x34);

    AlarmType alarmType =
        readEnumField(
            "alarmType",
            "AlarmType",
            new DataReaderEnumDefault<>(AlarmType::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("S7PayloadUserDataItemCpuFunctionAlarmQueryRequest");
    // Create the instance
    return new S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilderImpl(
        syntaxId, queryType, alarmType);
  }

  public static class S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilderImpl
      implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
    private final SyntaxIdType syntaxId;
    private final QueryType queryType;
    private final AlarmType alarmType;

    public S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilderImpl(
        SyntaxIdType syntaxId, QueryType queryType, AlarmType alarmType) {
      this.syntaxId = syntaxId;
      this.queryType = queryType;
      this.alarmType = alarmType;
    }

    public S7PayloadUserDataItemCpuFunctionAlarmQueryRequest build(
        DataTransportErrorCode returnCode, DataTransportSize transportSize, int dataLength) {
      S7PayloadUserDataItemCpuFunctionAlarmQueryRequest
          s7PayloadUserDataItemCpuFunctionAlarmQueryRequest =
              new S7PayloadUserDataItemCpuFunctionAlarmQueryRequest(
                  returnCode, transportSize, dataLength, syntaxId, queryType, alarmType);
      return s7PayloadUserDataItemCpuFunctionAlarmQueryRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7PayloadUserDataItemCpuFunctionAlarmQueryRequest)) {
      return false;
    }
    S7PayloadUserDataItemCpuFunctionAlarmQueryRequest that =
        (S7PayloadUserDataItemCpuFunctionAlarmQueryRequest) o;
    return (getSyntaxId() == that.getSyntaxId())
        && (getQueryType() == that.getQueryType())
        && (getAlarmType() == that.getAlarmType())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSyntaxId(), getQueryType(), getAlarmType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
