/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.field;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.s7.readwrite.AlarmType;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.field.S7Field;
import org.apache.plc4x.java.s7.readwrite.types.S7SubscriptionFieldType;

public class S7SubscriptionField
implements PlcField {
    private static final Pattern EVENT_SUBSCRIPTION_TYPE_PATTERN = Pattern.compile("(^MODE)|(^SYS)|(^USR)|(^ALM)");
    private static final Pattern EVENT_ALARM_ACK_PATTERN = Pattern.compile("(^ACK:)(((?:,{0,1})(16#[0-9a-fA-F]{8}))+)");
    private static final Pattern EVENT_ALARM_QUERY_PATTERN = Pattern.compile("(^QUERY:)((ALARM_S)|(ALARM_8))");
    private final S7SubscriptionFieldType fieldType;
    private final EventType eventtype;
    private final S7Field s7field;
    private final ArrayList<Integer> ackAlarms;
    private final AlarmType alarmQueryType;

    public S7SubscriptionField(S7SubscriptionFieldType fieldType, EventType eventtype) {
        this.fieldType = fieldType;
        this.eventtype = eventtype;
        this.s7field = null;
        this.ackAlarms = null;
        this.alarmQueryType = null;
    }

    public S7SubscriptionField(S7SubscriptionFieldType fieldType, ArrayList<Integer> ackAlarms) {
        this.fieldType = fieldType;
        this.eventtype = null;
        this.s7field = null;
        this.ackAlarms = ackAlarms;
        this.alarmQueryType = null;
    }

    public S7SubscriptionField(S7SubscriptionFieldType fieldType, AlarmType alarmQueryType) {
        this.fieldType = fieldType;
        this.eventtype = null;
        this.s7field = null;
        this.ackAlarms = null;
        this.alarmQueryType = alarmQueryType;
    }

    public S7SubscriptionField(S7SubscriptionFieldType fieldType, S7Field s7field) {
        this.fieldType = fieldType;
        this.eventtype = null;
        this.s7field = s7field;
        this.ackAlarms = null;
        this.alarmQueryType = null;
    }

    public S7SubscriptionFieldType getFieldType() {
        return this.fieldType;
    }

    public EventType getEventType() {
        return this.eventtype;
    }

    public S7Field getS7field() {
        return this.s7field;
    }

    public ArrayList<Integer> getAckAlarms() {
        return this.ackAlarms;
    }

    public AlarmType getAlarmQueryType() {
        return this.alarmQueryType;
    }

    public static boolean matches(String fieldString) {
        return EVENT_SUBSCRIPTION_TYPE_PATTERN.matcher(fieldString).matches() || EVENT_ALARM_ACK_PATTERN.matcher(fieldString).matches() || EVENT_ALARM_QUERY_PATTERN.matcher(fieldString).matches() || S7Field.matches(fieldString);
    }

    public static S7SubscriptionField of(String fieldString) {
        Matcher matcher = EVENT_SUBSCRIPTION_TYPE_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            return new S7SubscriptionField(S7SubscriptionFieldType.EVENT_SUBSCRIPTION, EventType.valueOf(fieldString));
        }
        matcher = EVENT_ALARM_ACK_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            String EventIds = matcher.group(2);
            String[] arrStrEventId = EventIds.split(",");
            ArrayList<Integer> arrEventId = new ArrayList<Integer>();
            for (String EventId : arrStrEventId) {
                EventId = EventId.replaceAll("16#", "");
                arrEventId.add(Integer.parseInt(EventId, 16));
            }
            return new S7SubscriptionField(S7SubscriptionFieldType.ALARM_ACK, arrEventId);
        }
        matcher = EVENT_ALARM_QUERY_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            return new S7SubscriptionField(S7SubscriptionFieldType.ALARM_QUERY, AlarmType.ALARM_S);
        }
        if (S7Field.matches(fieldString)) {
            S7Field s7field = S7Field.of(fieldString);
            switch (s7field.getDataType()) {
                default: 
            }
            return new S7SubscriptionField(S7SubscriptionFieldType.CYCLIC_SUBSCRIPTION, s7field);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }
}

