/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.field.S7StringField;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class S7Field
implements PlcField,
Serializable {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^%(?<memoryArea>.)(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_ADDRESS_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}).DB(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_SHORT_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}):(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>[a-zA-Z_]+)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_STRING_ADDRESS_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}).DB(?<transferSizeCode>[XBWD]?)(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numElements>\\d+)])?");
    private static final Pattern DATA_BLOCK_STRING_SHORT_PATTERN = Pattern.compile("^%DB(?<blockNumber>\\d{1,5}):(?<byteOffset>\\d{1,7})(.(?<bitOffset>[0-7]))?:(?<dataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numElements>\\d+)])?");
    private static final Pattern PLC_PROXY_ADDRESS_PATTERN = Pattern.compile("[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}");
    private static final String DATA_TYPE = "dataType";
    private static final String STRING_LENGTH = "stringLength";
    private static final String TRANSFER_SIZE_CODE = "transferSizeCode";
    private static final String BLOCK_NUMBER = "blockNumber";
    private static final String BYTE_OFFSET = "byteOffset";
    private static final String BIT_OFFSET = "bitOffset";
    private static final String NUM_ELEMENTS = "numElements";
    private static final String MEMORY_AREA = "memoryArea";
    private final TransportSize dataType;
    private final MemoryArea memoryArea;
    private final int blockNumber;
    private final int byteOffset;
    private final byte bitOffset;
    private final int numElements;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    protected S7Field(@JsonProperty(value="dataType") TransportSize dataType, @JsonProperty(value="memoryArea") MemoryArea memoryArea, @JsonProperty(value="blockNumber") int blockNumber, @JsonProperty(value="byteOffset") int byteOffset, @JsonProperty(value="bitOffset") byte bitOffset, @JsonProperty(value="numElements") int numElements) {
        this.dataType = dataType;
        this.memoryArea = memoryArea;
        this.blockNumber = blockNumber;
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.numElements = numElements;
    }

    public TransportSize getDataType() {
        return this.dataType;
    }

    public String getPlcDataType() {
        return this.dataType.toString();
    }

    public MemoryArea getMemoryArea() {
        return this.memoryArea;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public static boolean matches(String fieldString) {
        return DATA_BLOCK_STRING_ADDRESS_PATTERN.matcher(fieldString).matches() || DATA_BLOCK_STRING_SHORT_PATTERN.matcher(fieldString).matches() || DATA_BLOCK_ADDRESS_PATTERN.matcher(fieldString).matches() || DATA_BLOCK_SHORT_PATTERN.matcher(fieldString).matches() || PLC_PROXY_ADDRESS_PATTERN.matcher(fieldString).matches() || ADDRESS_PATTERN.matcher(fieldString).matches();
    }

    public Class<?> getDefaultJavaType() {
        switch (this.dataType) {
            case STRING: {
                return String.class;
            }
            case USINT: 
            case SINT: 
            case UINT: 
            case INT: 
            case DINT: {
                return Integer.class;
            }
            case UDINT: 
            case ULINT: 
            case LINT: {
                return Long.class;
            }
            case BOOL: {
                return Boolean.class;
            }
            case REAL: 
            case LREAL: {
                return Double.class;
            }
            case DATE_AND_TIME: {
                return LocalDateTime.class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case TIME_OF_DAY: {
                return LocalTime.class;
            }
        }
        throw new NotImplementedException("The response type for datatype " + (Object)((Object)this.dataType) + " is not yet implemented");
    }

    public static S7Field of(String fieldString) {
        Matcher matcher = DATA_BLOCK_STRING_ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            int stringLength = Integer.parseInt(matcher.group(STRING_LENGTH));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7Field.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            Short transferSizeCode = S7Field.getSizeCode(matcher.group(TRANSFER_SIZE_CODE));
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidFieldException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidFieldException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7StringField(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements, stringLength);
        }
        matcher = DATA_BLOCK_STRING_SHORT_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            int stringLength = Integer.parseInt(matcher.group(STRING_LENGTH));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7Field.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            return new S7StringField(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements, stringLength);
        }
        matcher = DATA_BLOCK_ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            Short transferSizeCode = S7Field.getSizeCode(matcher.group(TRANSFER_SIZE_CODE));
            int blockNumber = S7Field.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidFieldException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidFieldException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            return new S7Field(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        }
        matcher = DATA_BLOCK_SHORT_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = MemoryArea.DATA_BLOCKS;
            int blockNumber = S7Field.checkDatablockNumber(Integer.parseInt(matcher.group(BLOCK_NUMBER)));
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidFieldException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            return new S7Field(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        }
        if (PLC_PROXY_ADDRESS_PATTERN.matcher(fieldString).matches()) {
            try {
                byte[] addressData = Hex.decodeHex((String)fieldString.replaceAll("[-]", ""));
                ReadBufferByteBased rb = new ReadBufferByteBased(addressData);
                S7Address s7Address = S7Address.staticParse((ReadBuffer)rb);
                if (s7Address instanceof S7AddressAny) {
                    S7AddressAny s7AddressAny = (S7AddressAny)s7Address;
                    if (s7AddressAny.getTransportSize() != TransportSize.BOOL && s7AddressAny.getBitAddress() != 0) {
                        throw new PlcInvalidFieldException("A bit offset other than 0 is only supported for type BOOL");
                    }
                    return new S7Field(s7AddressAny.getTransportSize(), s7AddressAny.getArea(), s7AddressAny.getDbNumber(), s7AddressAny.getByteAddress(), s7AddressAny.getBitAddress(), s7AddressAny.getNumberOfElements());
                }
                throw new PlcInvalidFieldException("Unsupported address type.");
            }
            catch (DecoderException | ParseException e) {
                throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
            }
        }
        matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            TransportSize dataType = TransportSize.valueOf(matcher.group(DATA_TYPE));
            MemoryArea memoryArea = S7Field.getMemoryAreaForShortName(matcher.group(MEMORY_AREA));
            Short transferSizeCode = S7Field.getSizeCode(matcher.group(TRANSFER_SIZE_CODE));
            int byteOffset = S7Field.checkByteOffset(Integer.parseInt(matcher.group(BYTE_OFFSET)));
            byte bitOffset = 0;
            if (matcher.group(BIT_OFFSET) != null) {
                bitOffset = Byte.parseByte(matcher.group(BIT_OFFSET));
            } else if (dataType == TransportSize.BOOL) {
                throw new PlcInvalidFieldException("Expected bit offset for BOOL parameters.");
            }
            int numElements = 1;
            if (matcher.group(NUM_ELEMENTS) != null) {
                numElements = Integer.parseInt(matcher.group(NUM_ELEMENTS));
            }
            if (transferSizeCode != null && dataType.getShortName() != transferSizeCode.shortValue()) {
                throw new PlcInvalidFieldException("Transfer size code '" + transferSizeCode + "' doesn't match specified data type '" + dataType.name() + "'");
            }
            if (dataType != TransportSize.BOOL && bitOffset != 0) {
                throw new PlcInvalidFieldException("A bit offset other than 0 is only supported for type BOOL");
            }
            return new S7Field(dataType, memoryArea, 0, byteOffset, bitOffset, numElements);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }

    private static int checkDatablockNumber(int blockNumber) {
        if (blockNumber > 64000 || blockNumber < 1) {
            throw new PlcInvalidFieldException("Datablock numbers larger than 64000 or smaller than 1 are not supported.");
        }
        return blockNumber;
    }

    private static int checkByteOffset(int byteOffset) {
        if (byteOffset > 0x1FFFFF || byteOffset < 0) {
            throw new PlcInvalidFieldException("ByteOffset must be smaller than 2097151 and positive.");
        }
        return byteOffset;
    }

    protected static Short getSizeCode(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.length() > 1) {
            return null;
        }
        return value.getBytes()[0];
    }

    protected static MemoryArea getMemoryAreaForShortName(String shortName) {
        for (MemoryArea memoryArea : MemoryArea.values()) {
            if (!memoryArea.getShortName().equals(shortName)) continue;
            return memoryArea;
        }
        return null;
    }

    public String toString() {
        return "S7Field{dataType=" + (Object)((Object)this.dataType) + ", memoryArea=" + (Object)((Object)this.memoryArea) + ", blockNumber=" + this.blockNumber + ", byteOffset=" + this.byteOffset + ", bitOffset=" + this.bitOffset + ", numElements=" + this.numElements + '}';
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String memoryArea = this.getMemoryArea().name();
        writeBuffer.writeString(MEMORY_AREA, memoryArea.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), memoryArea, new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(BLOCK_NUMBER, 16, this.getBlockNumber(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(BYTE_OFFSET, 16, this.getByteOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(BIT_OFFSET, 8, (int)this.getBitOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt(NUM_ELEMENTS, 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        String dataType = this.getDataType().name();
        writeBuffer.writeString(DATA_TYPE, dataType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), dataType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

