/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.security;

import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;

public enum SecurityPolicy {
    NONE("http://opcfoundation.org/UA/SecurityPolicy#None", new MacSignatureAlgorithm(""), new EncryptionAlgorithm(""), new SignatureAlgorithm("", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"), new EncryptionAlgorithm(""), 0, 0, 0, 1, 0),
    Basic128Rsa15("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", new MacSignatureAlgorithm("HmacSHA1"), new EncryptionAlgorithm("AES/CBC/NoPadding"), new SignatureAlgorithm("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1"), new EncryptionAlgorithm("RSA/ECB/PKCS1Padding"), 20, 16, 16, 16, 16),
    Basic256("http://opcfoundation.org/UA/SecurityPolicy#Basic256", new MacSignatureAlgorithm("HmacSHA1"), new EncryptionAlgorithm("AES/CBC/NoPadding"), new SignatureAlgorithm("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1"), new EncryptionAlgorithm("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"), 20, 24, 32, 16, 32),
    Basic256Sha256("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", new MacSignatureAlgorithm("HmacSHA256"), new EncryptionAlgorithm("AES/CBC/NoPadding"), new SignatureAlgorithm("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"), new EncryptionAlgorithm("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"), 32, 32, 32, 16, 32),
    Aes128_Sha256_RsaOaep("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep", new MacSignatureAlgorithm("HmacSHA256"), new EncryptionAlgorithm("AES/CBC/NoPadding"), new SignatureAlgorithm("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"), new EncryptionAlgorithm("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"), 32, 32, 16, 16, 32),
    Aes256_Sha256_RsaPss("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss", new MacSignatureAlgorithm("HmacSHA256"), new EncryptionAlgorithm("AES/CBC/NoPadding"), new SignatureAlgorithm("SHA256withRSA/PSS", "http://opcfoundation.org/UA/security/rsa-pss-sha2-256"), new EncryptionAlgorithm("RSA/ECB/OAEPWithSHA256AndMGF1Padding"), 32, 32, 32, 16, 32);

    private final String securityPolicyUri;
    private final MacSignatureAlgorithm symmetricSignatureAlgorithm;
    private final EncryptionAlgorithm symmetricEncryptionAlgorithm;
    private final SignatureAlgorithm asymmetricSignatureAlgorithm;
    private final EncryptionAlgorithm asymmetricEncryptionAlgorithm;
    private final int symmetricSignatureSize;
    private final int signatureKeySize;
    private final int encryptionKeySize;
    private final int encryptionBlockSize;
    private final int nonceLength;

    private SecurityPolicy(String securityPolicyUri, MacSignatureAlgorithm symmetricSignatureAlgorithm, EncryptionAlgorithm symmetricEncryptionAlgorithm, SignatureAlgorithm asymmetricSignatureAlgorithm, EncryptionAlgorithm asymmetricEncryptionAlgorithm, int symmetricSignatureSize, int signatureKeySize, int encryptionKeySize, int encryptionBlockSize, int nonceLength) {
        this.securityPolicyUri = securityPolicyUri;
        this.symmetricSignatureAlgorithm = symmetricSignatureAlgorithm;
        this.symmetricEncryptionAlgorithm = symmetricEncryptionAlgorithm;
        this.asymmetricSignatureAlgorithm = asymmetricSignatureAlgorithm;
        this.asymmetricEncryptionAlgorithm = asymmetricEncryptionAlgorithm;
        this.symmetricSignatureSize = symmetricSignatureSize;
        this.signatureKeySize = signatureKeySize;
        this.encryptionKeySize = encryptionKeySize;
        this.encryptionBlockSize = encryptionBlockSize;
        this.nonceLength = nonceLength;
    }

    public static SecurityPolicy findByName(String securityPolicy) {
        return Arrays.stream(SecurityPolicy.values()).filter(v -> v.name().equalsIgnoreCase(securityPolicy)).findAny().orElseThrow();
    }

    public MacSignatureAlgorithm getSymmetricSignatureAlgorithm() {
        return this.symmetricSignatureAlgorithm;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public SignatureAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.asymmetricSignatureAlgorithm;
    }

    public EncryptionAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.asymmetricEncryptionAlgorithm;
    }

    public EncryptionAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.symmetricEncryptionAlgorithm;
    }

    public int getSymmetricSignatureSize() {
        return this.symmetricSignatureSize;
    }

    public int getSignatureKeySize() {
        return this.signatureKeySize;
    }

    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    public int getNonceLength() {
        return this.nonceLength;
    }

    public static class EncryptionAlgorithm {
        private final String name;

        EncryptionAlgorithm(String name) {
            this.name = name;
        }

        public Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
            return Cipher.getInstance(this.name);
        }
    }

    public static class MacSignatureAlgorithm {
        private final String name;

        MacSignatureAlgorithm(String name) {
            this.name = name;
        }

        public Mac getSignature() throws NoSuchAlgorithmException {
            return Mac.getInstance(this.name);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SignatureAlgorithm {
        private final String name;
        private String uri;

        SignatureAlgorithm(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        public Signature getSignature() throws NoSuchAlgorithmException {
            return Signature.getInstance(this.name);
        }

        public String getUri() {
            return this.uri;
        }
    }
}

