/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModifyMonitoredItemsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final long subscriptionId;
    protected final TimestampsToReturn timestampsToReturn;
    protected final int noOfItemsToModify;
    protected final List<ExtensionObjectDefinition> itemsToModify;

    @Override
    public String getIdentifier() {
        return "763";
    }

    public ModifyMonitoredItemsRequest(ExtensionObjectDefinition requestHeader, long subscriptionId, TimestampsToReturn timestampsToReturn, int noOfItemsToModify, List<ExtensionObjectDefinition> itemsToModify) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.timestampsToReturn = timestampsToReturn;
        this.noOfItemsToModify = noOfItemsToModify;
        this.itemsToModify = itemsToModify;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public int getNoOfItemsToModify() {
        return this.noOfItemsToModify;
    }

    public List<ExtensionObjectDefinition> getItemsToModify() {
        return this.itemsToModify;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModifyMonitoredItemsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"subscriptionId", (Object)this.subscriptionId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (Object)((Object)this.timestampsToReturn), (DataWriter)new DataWriterEnumDefault(TimestampsToReturn::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfItemsToModify", (Object)this.noOfItemsToModify, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"itemsToModify", this.itemsToModify, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ModifyMonitoredItemsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModifyMonitoredItemsRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.itemsToModify != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.itemsToModify) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.itemsToModify.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ModifyMonitoredItemsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long subscriptionId = (Long)FieldReaderFactory.readSimpleField((String)"subscriptionId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        TimestampsToReturn timestampsToReturn = (TimestampsToReturn)((Object)FieldReaderFactory.readEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (DataReader)new DataReaderEnumDefault(TimestampsToReturn::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        int noOfItemsToModify = (Integer)FieldReaderFactory.readSimpleField((String)"noOfItemsToModify", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List itemsToModify = FieldReaderFactory.readCountArrayField((String)"itemsToModify", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "757"), readBuffer), (long)noOfItemsToModify, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ModifyMonitoredItemsRequest", new WithReaderArgs[0]);
        return new ModifyMonitoredItemsRequestBuilderImpl(requestHeader, subscriptionId, timestampsToReturn, noOfItemsToModify, itemsToModify);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifyMonitoredItemsRequest)) {
            return false;
        }
        ModifyMonitoredItemsRequest that = (ModifyMonitoredItemsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionId() == that.getSubscriptionId() && this.getTimestampsToReturn() == that.getTimestampsToReturn() && this.getNoOfItemsToModify() == that.getNoOfItemsToModify() && this.getItemsToModify() == that.getItemsToModify() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), this.getNoOfItemsToModify(), this.getItemsToModify()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModifyMonitoredItemsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final long subscriptionId;
        private final TimestampsToReturn timestampsToReturn;
        private final int noOfItemsToModify;
        private final List<ExtensionObjectDefinition> itemsToModify;

        public ModifyMonitoredItemsRequestBuilderImpl(ExtensionObjectDefinition requestHeader, long subscriptionId, TimestampsToReturn timestampsToReturn, int noOfItemsToModify, List<ExtensionObjectDefinition> itemsToModify) {
            this.requestHeader = requestHeader;
            this.subscriptionId = subscriptionId;
            this.timestampsToReturn = timestampsToReturn;
            this.noOfItemsToModify = noOfItemsToModify;
            this.itemsToModify = itemsToModify;
        }

        @Override
        public ModifyMonitoredItemsRequest build() {
            ModifyMonitoredItemsRequest modifyMonitoredItemsRequest = new ModifyMonitoredItemsRequest(this.requestHeader, this.subscriptionId, this.timestampsToReturn, this.noOfItemsToModify, this.itemsToModify);
            return modifyMonitoredItemsRequest;
        }
    }
}

