/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryReadRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final ExtensionObject historyReadDetails;
    protected final TimestampsToReturn timestampsToReturn;
    protected final boolean releaseContinuationPoints;
    protected final int noOfNodesToRead;
    protected final List<ExtensionObjectDefinition> nodesToRead;

    @Override
    public String getIdentifier() {
        return "664";
    }

    public HistoryReadRequest(ExtensionObjectDefinition requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, int noOfNodesToRead, List<ExtensionObjectDefinition> nodesToRead) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = historyReadDetails;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.noOfNodesToRead = noOfNodesToRead;
        this.nodesToRead = nodesToRead;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public int getNoOfNodesToRead() {
        return this.noOfNodesToRead;
    }

    public List<ExtensionObjectDefinition> getNodesToRead() {
        return this.nodesToRead;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryReadRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"historyReadDetails", (Object)this.historyReadDetails, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (Object)((Object)this.timestampsToReturn), (DataWriter)new DataWriterEnumDefault(TimestampsToReturn::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"releaseContinuationPoints", (Object)this.releaseContinuationPoints, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfNodesToRead", (Object)this.noOfNodesToRead, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"nodesToRead", this.nodesToRead, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryReadRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.historyReadDetails.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.nodesToRead != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.nodesToRead) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToRead.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject historyReadDetails = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"historyReadDetails", (DataReader)new DataReaderComplexDefault(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        TimestampsToReturn timestampsToReturn = (TimestampsToReturn)((Object)FieldReaderFactory.readEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (DataReader)new DataReaderEnumDefault(TimestampsToReturn::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean releaseContinuationPoints = (Boolean)FieldReaderFactory.readSimpleField((String)"releaseContinuationPoints", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNodesToRead = (Integer)FieldReaderFactory.readSimpleField((String)"noOfNodesToRead", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List nodesToRead = FieldReaderFactory.readCountArrayField((String)"nodesToRead", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "637"), readBuffer), (long)noOfNodesToRead, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryReadRequest", new WithReaderArgs[0]);
        return new HistoryReadRequestBuilderImpl(requestHeader, historyReadDetails, timestampsToReturn, releaseContinuationPoints, noOfNodesToRead, nodesToRead);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryReadRequest)) {
            return false;
        }
        HistoryReadRequest that = (HistoryReadRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getHistoryReadDetails() == that.getHistoryReadDetails() && this.getTimestampsToReturn() == that.getTimestampsToReturn() && this.getReleaseContinuationPoints() == that.getReleaseContinuationPoints() && this.getNoOfNodesToRead() == that.getNoOfNodesToRead() && this.getNodesToRead() == that.getNodesToRead() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getHistoryReadDetails(), this.getTimestampsToReturn(), this.getReleaseContinuationPoints(), this.getNoOfNodesToRead(), this.getNodesToRead()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryReadRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final ExtensionObject historyReadDetails;
        private final TimestampsToReturn timestampsToReturn;
        private final boolean releaseContinuationPoints;
        private final int noOfNodesToRead;
        private final List<ExtensionObjectDefinition> nodesToRead;

        public HistoryReadRequestBuilderImpl(ExtensionObjectDefinition requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, int noOfNodesToRead, List<ExtensionObjectDefinition> nodesToRead) {
            this.requestHeader = requestHeader;
            this.historyReadDetails = historyReadDetails;
            this.timestampsToReturn = timestampsToReturn;
            this.releaseContinuationPoints = releaseContinuationPoints;
            this.noOfNodesToRead = noOfNodesToRead;
            this.nodesToRead = nodesToRead;
        }

        @Override
        public HistoryReadRequest build() {
            HistoryReadRequest historyReadRequest = new HistoryReadRequest(this.requestHeader, this.historyReadDetails, this.timestampsToReturn, this.releaseContinuationPoints, this.noOfNodesToRead, this.nodesToRead);
            return historyReadRequest;
        }
    }
}

