/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BuildInfo
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString productUri;
    protected final PascalString manufacturerName;
    protected final PascalString productName;
    protected final PascalString softwareVersion;
    protected final PascalString buildNumber;
    protected final long buildDate;

    @Override
    public String getIdentifier() {
        return "340";
    }

    public BuildInfo(PascalString productUri, PascalString manufacturerName, PascalString productName, PascalString softwareVersion, PascalString buildNumber, long buildDate) {
        this.productUri = productUri;
        this.manufacturerName = manufacturerName;
        this.productName = productName;
        this.softwareVersion = softwareVersion;
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
    }

    public PascalString getProductUri() {
        return this.productUri;
    }

    public PascalString getManufacturerName() {
        return this.manufacturerName;
    }

    public PascalString getProductName() {
        return this.productName;
    }

    public PascalString getSoftwareVersion() {
        return this.softwareVersion;
    }

    public PascalString getBuildNumber() {
        return this.buildNumber;
    }

    public long getBuildDate() {
        return this.buildDate;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BuildInfo", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"productUri", (Object)this.productUri, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"manufacturerName", (Object)this.manufacturerName, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"productName", (Object)this.productName, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"softwareVersion", (Object)this.softwareVersion, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"buildNumber", (Object)this.buildNumber, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"buildDate", (Object)this.buildDate, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BuildInfo", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BuildInfo _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.productUri.getLengthInBits();
        lengthInBits += this.manufacturerName.getLengthInBits();
        lengthInBits += this.productName.getLengthInBits();
        lengthInBits += this.softwareVersion.getLengthInBits();
        lengthInBits += this.buildNumber.getLengthInBits();
        return lengthInBits += 64;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("BuildInfo", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString productUri = (PascalString)FieldReaderFactory.readSimpleField((String)"productUri", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString manufacturerName = (PascalString)FieldReaderFactory.readSimpleField((String)"manufacturerName", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString productName = (PascalString)FieldReaderFactory.readSimpleField((String)"productName", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString softwareVersion = (PascalString)FieldReaderFactory.readSimpleField((String)"softwareVersion", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString buildNumber = (PascalString)FieldReaderFactory.readSimpleField((String)"buildNumber", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long buildDate = (Long)FieldReaderFactory.readSimpleField((String)"buildDate", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BuildInfo", new WithReaderArgs[0]);
        return new BuildInfoBuilderImpl(productUri, manufacturerName, productName, softwareVersion, buildNumber, buildDate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildInfo)) {
            return false;
        }
        BuildInfo that = (BuildInfo)o;
        return this.getProductUri() == that.getProductUri() && this.getManufacturerName() == that.getManufacturerName() && this.getProductName() == that.getProductName() && this.getSoftwareVersion() == that.getSoftwareVersion() && this.getBuildNumber() == that.getBuildNumber() && this.getBuildDate() == that.getBuildDate() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getProductUri(), this.getManufacturerName(), this.getProductName(), this.getSoftwareVersion(), this.getBuildNumber(), this.getBuildDate());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BuildInfoBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString productUri;
        private final PascalString manufacturerName;
        private final PascalString productName;
        private final PascalString softwareVersion;
        private final PascalString buildNumber;
        private final long buildDate;

        public BuildInfoBuilderImpl(PascalString productUri, PascalString manufacturerName, PascalString productName, PascalString softwareVersion, PascalString buildNumber, long buildDate) {
            this.productUri = productUri;
            this.manufacturerName = manufacturerName;
            this.productName = productName;
            this.softwareVersion = softwareVersion;
            this.buildNumber = buildNumber;
            this.buildDate = buildDate;
        }

        @Override
        public BuildInfo build() {
            BuildInfo buildInfo = new BuildInfo(this.productUri, this.manufacturerName, this.productName, this.softwareVersion, this.buildNumber, this.buildDate);
            return buildInfo;
        }
    }
}

