/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.plc4x.java.opcua.protocol.chunk.ChunkStorage;

public class MemoryChunkStorage
implements ChunkStorage {
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private long size = 0L;

    @Override
    public void append(byte[] frame) {
        this.chunks.add(frame);
        this.size += (long)this.chunks.get(this.chunks.size() - 1).length;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public byte[] get() {
        Optional collect = this.chunks.stream().reduce((b1, b2) -> {
            byte[] combined = new byte[((byte[])b1).length + ((byte[])b2).length];
            System.arraycopy(b1, 0, combined, 0, ((byte[])b1).length);
            System.arraycopy(b2, 0, combined, ((byte[])b1).length, ((byte[])b2).length);
            return combined;
        });
        return collect.orElse(new byte[0]);
    }

    @Override
    public void reset() {
        this.chunks.clear();
        this.size = 0L;
    }
}

