/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol.chunk;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.plc4x.java.opcua.context.Conversation;
import org.apache.plc4x.java.opcua.protocol.chunk.Chunk;
import org.apache.plc4x.java.opcua.readwrite.OpcuaProtocolLimits;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;

public class ChunkFactory {
    public static int SYMMETRIC_SECURITY_HEADER_SIZE = 4;

    public Chunk create(boolean asymmetric, Conversation conversation) {
        return this.create(asymmetric, conversation.isSymmetricEncryptionEnabled(), conversation.isSymmetricSigningEnabled(), conversation.getSecurityPolicy(), conversation.getLimits(), conversation.getLocalCertificate(), conversation.getRemoteCertificate());
    }

    public Chunk create(boolean asymmetric, boolean encrypted, boolean signed, SecurityPolicy securityPolicy, OpcuaProtocolLimits limits, X509Certificate localCertificate, X509Certificate remoteCertificate) {
        int cipherTextBlockSize;
        int plainTextTextBlockSize;
        if (securityPolicy == SecurityPolicy.NONE) {
            return new Chunk(asymmetric ? 59 : SYMMETRIC_SECURITY_HEADER_SIZE, 1, 1, securityPolicy.getSymmetricSignatureSize(), (int)limits.getSendBufferSize(), asymmetric, false, false);
        }
        boolean encryption = asymmetric || encrypted;
        boolean signing = asymmetric || signed;
        int localAsymmetricKeyLength = asymmetric ? ChunkFactory.keySize(localCertificate) : 0;
        int remoteAsymmetricKeyLength = asymmetric ? ChunkFactory.keySize(remoteCertificate) : 0;
        int localCertificateSize = asymmetric ? ChunkFactory.certificateBytes(localCertificate).length : 0;
        int serverCertificateThumbprint = asymmetric ? ChunkFactory.certificateThumbprint(remoteCertificate).length : 0;
        int asymmetricSecurityHarderSize = 12 + securityPolicy.getSecurityPolicyUri().length() + localCertificateSize + serverCertificateThumbprint;
        int asymmetricCipherTextBlockSize = asymmetric ? (localAsymmetricKeyLength + 7) / 8 : 0;
        int n = plainTextTextBlockSize = asymmetric ? (localAsymmetricKeyLength + 7) / 8 : 0;
        int n2 = asymmetric ? asymmetricCipherTextBlockSize : (cipherTextBlockSize = encrypted ? securityPolicy.getEncryptionBlockSize() : 1);
        if (securityPolicy == SecurityPolicy.Basic128Rsa15) {
            return new Chunk(asymmetric ? asymmetricSecurityHarderSize : SYMMETRIC_SECURITY_HEADER_SIZE, cipherTextBlockSize, asymmetric ? plainTextTextBlockSize - 11 : (encrypted ? securityPolicy.getEncryptionBlockSize() : 1), asymmetric ? (remoteAsymmetricKeyLength + 7) / 8 : securityPolicy.getSymmetricSignatureSize(), (int)limits.getSendBufferSize(), asymmetric, encryption, signing);
        }
        if (securityPolicy == SecurityPolicy.Basic256) {
            return new Chunk(asymmetric ? asymmetricSecurityHarderSize : SYMMETRIC_SECURITY_HEADER_SIZE, cipherTextBlockSize, asymmetric ? plainTextTextBlockSize - 42 : (encrypted ? securityPolicy.getEncryptionBlockSize() : 1), asymmetric ? (remoteAsymmetricKeyLength + 7) / 8 : securityPolicy.getSymmetricSignatureSize(), (int)limits.getSendBufferSize(), asymmetric, encryption, signing);
        }
        if (securityPolicy == SecurityPolicy.Basic256Sha256) {
            return new Chunk(asymmetric ? asymmetricSecurityHarderSize : SYMMETRIC_SECURITY_HEADER_SIZE, cipherTextBlockSize, asymmetric ? plainTextTextBlockSize - 42 : (encrypted ? securityPolicy.getEncryptionBlockSize() : 1), asymmetric ? (remoteAsymmetricKeyLength + 7) / 8 : securityPolicy.getSymmetricSignatureSize(), (int)limits.getSendBufferSize(), asymmetric, encryption, signing);
        }
        if (securityPolicy == SecurityPolicy.Aes128_Sha256_RsaOaep) {
            return new Chunk(asymmetric ? asymmetricSecurityHarderSize : SYMMETRIC_SECURITY_HEADER_SIZE, cipherTextBlockSize, asymmetric ? plainTextTextBlockSize - 42 : (encrypted ? securityPolicy.getEncryptionBlockSize() : 1), asymmetric ? (remoteAsymmetricKeyLength + 7) / 8 : securityPolicy.getSymmetricSignatureSize(), (int)limits.getSendBufferSize(), asymmetric, encryption, signing);
        }
        if (securityPolicy == SecurityPolicy.Aes256_Sha256_RsaPss) {
            return new Chunk(asymmetric ? asymmetricSecurityHarderSize : SYMMETRIC_SECURITY_HEADER_SIZE, cipherTextBlockSize, asymmetric ? plainTextTextBlockSize - 66 : (encrypted ? securityPolicy.getEncryptionBlockSize() : 1), asymmetric ? (remoteAsymmetricKeyLength + 7) / 8 : securityPolicy.getSymmetricSignatureSize(), (int)limits.getSendBufferSize(), asymmetric, encryption, signing);
        }
        throw new IllegalArgumentException("Unsupported security policy " + securityPolicy.name() + "[" + securityPolicy.getSecurityPolicyUri() + "]");
    }

    private static int keySize(X509Certificate certificate) {
        PublicKey publicKey = certificate != null ? certificate.getPublicKey() : null;
        return publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : 0;
    }

    private static byte[] certificateThumbprint(X509Certificate certificate) {
        return DigestUtils.sha1((byte[])ChunkFactory.certificateBytes(certificate));
    }

    private static byte[] certificateBytes(X509Certificate certificate) {
        return (byte[])Try.of((CheckedFunction0 & Serializable)() -> certificate.getEncoded()).getOrElse((Object)new byte[0]);
    }
}

