/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol.chunk;

import java.util.Objects;

public class Chunk {
    private final int securityHeaderSize;
    private final int cipherTextBlockSize;
    private final int plainTextBlockSize;
    private final int signatureSize;
    private final int maxChunkSize;
    private final int paddingOverhead;
    private final int maxCipherTextSize;
    private final int maxCipherTextBlocks;
    private final int maxPlainTextSize;
    private final int maxBodySize;
    private boolean asymmetric;
    private boolean encrypted;
    private boolean signed;

    public Chunk(int securityHeaderSize, int cipherTextBlockSize, int plainTextBlockSize, int signatureSize, int maxChunkSize) {
        this(securityHeaderSize, cipherTextBlockSize, plainTextBlockSize, signatureSize, maxChunkSize, false, false, false);
    }

    public Chunk(int securityHeaderSize, int cipherTextBlockSize, int plainTextBlockSize, int signatureSize, int maxChunkSize, boolean asymmetric, boolean encrypted, boolean signed) {
        this.securityHeaderSize = securityHeaderSize;
        this.cipherTextBlockSize = cipherTextBlockSize;
        this.plainTextBlockSize = plainTextBlockSize;
        this.signatureSize = signatureSize;
        this.maxChunkSize = maxChunkSize;
        this.asymmetric = asymmetric;
        this.encrypted = encrypted;
        this.signed = signed;
        this.maxCipherTextSize = maxChunkSize - 12 - securityHeaderSize;
        this.maxCipherTextBlocks = this.maxCipherTextSize / cipherTextBlockSize;
        this.paddingOverhead = cipherTextBlockSize > 256 ? 2 : (cipherTextBlockSize < 16 ? 0 : 1);
        this.maxPlainTextSize = this.maxCipherTextBlocks * plainTextBlockSize;
        this.maxBodySize = this.maxPlainTextSize - 8 - this.paddingOverhead - signatureSize;
    }

    public int getSecurityHeaderSize() {
        return this.securityHeaderSize;
    }

    public int getCipherTextBlockSize() {
        return this.cipherTextBlockSize;
    }

    public int getPlainTextBlockSize() {
        return this.plainTextBlockSize;
    }

    public int getSignatureSize() {
        return this.signatureSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getPaddingOverhead() {
        return this.paddingOverhead;
    }

    public int getMaxCipherTextSize() {
        return this.maxCipherTextSize;
    }

    public int getMaxCipherTextBlocks() {
        return this.maxCipherTextBlocks;
    }

    public int getMaxPlainTextSize() {
        return this.maxPlainTextSize;
    }

    public int getMaxBodySize() {
        return this.maxBodySize;
    }

    public boolean isAsymmetric() {
        return this.asymmetric;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Chunk)) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        return this.getSecurityHeaderSize() == chunk.getSecurityHeaderSize() && this.getCipherTextBlockSize() == chunk.getCipherTextBlockSize() && this.getPlainTextBlockSize() == chunk.getPlainTextBlockSize() && this.getSignatureSize() == chunk.getSignatureSize() && this.getMaxChunkSize() == chunk.getMaxChunkSize() && this.getPaddingOverhead() == chunk.getPaddingOverhead() && this.getMaxCipherTextSize() == chunk.getMaxCipherTextSize() && this.getMaxCipherTextBlocks() == chunk.getMaxCipherTextBlocks() && this.getMaxPlainTextSize() == chunk.getMaxPlainTextSize() && this.getMaxBodySize() == chunk.getMaxBodySize();
    }

    public int hashCode() {
        return Objects.hash(this.getSecurityHeaderSize(), this.getCipherTextBlockSize(), this.getPlainTextBlockSize(), this.getSignatureSize(), this.getMaxChunkSize(), this.getPaddingOverhead(), this.getMaxCipherTextSize(), this.getMaxCipherTextBlocks(), this.getMaxPlainTextSize(), this.getMaxBodySize());
    }

    public String toString() {
        return "Chunk{ securityHeaderSize=" + this.securityHeaderSize + ", cipherTextBlockSize=" + this.cipherTextBlockSize + ", plainTextBlockSize=" + this.plainTextBlockSize + ", signatureSize=" + this.signatureSize + ", maxChunkSize=" + this.maxChunkSize + ", paddingOverhead=" + this.paddingOverhead + ", maxCipherTextSize=" + this.maxCipherTextSize + ", maxCipherTextBlocks=" + this.maxCipherTextBlocks + ", maxPlainTextSize=" + this.maxPlainTextSize + ", maxBodySize=" + this.maxBodySize + '}';
    }
}

