/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class UserIdentityToken extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "316";
  }

  // Properties.
  protected final PascalString policyId;
  protected final UserIdentityTokenDefinition userIdentityTokenDefinition;

  public UserIdentityToken(
      PascalString policyId, UserIdentityTokenDefinition userIdentityTokenDefinition) {
    super();
    this.policyId = policyId;
    this.userIdentityTokenDefinition = userIdentityTokenDefinition;
  }

  public PascalString getPolicyId() {
    return policyId;
  }

  public UserIdentityTokenDefinition getUserIdentityTokenDefinition() {
    return userIdentityTokenDefinition;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("UserIdentityToken");

    // Implicit Field (policyLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int policyLength =
        (int)
            ((getPolicyId().getLengthInBytes())
                + (getUserIdentityTokenDefinition().getLengthInBytes()));
    writeImplicitField("policyLength", policyLength, writeSignedInt(writeBuffer, 32));

    // Simple Field (policyId)
    writeSimpleField("policyId", policyId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (userIdentityTokenDefinition)
    writeSimpleField(
        "userIdentityTokenDefinition",
        userIdentityTokenDefinition,
        new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("UserIdentityToken");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    UserIdentityToken _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (policyLength)
    lengthInBits += 32;

    // Simple field (policyId)
    lengthInBits += policyId.getLengthInBits();

    // Simple field (userIdentityTokenDefinition)
    lengthInBits += userIdentityTokenDefinition.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("UserIdentityToken");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int policyLength = readImplicitField("policyLength", readSignedInt(readBuffer, 32));

    PascalString policyId =
        readSimpleField(
            "policyId",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    UserIdentityTokenDefinition userIdentityTokenDefinition =
        readSimpleField(
            "userIdentityTokenDefinition",
            new DataReaderComplexDefault<>(
                () ->
                    UserIdentityTokenDefinition.staticParse(
                        readBuffer, (String) (policyId.getStringValue())),
                readBuffer));

    readBuffer.closeContext("UserIdentityToken");
    // Create the instance
    return new UserIdentityTokenBuilderImpl(policyId, userIdentityTokenDefinition);
  }

  public static class UserIdentityTokenBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString policyId;
    private final UserIdentityTokenDefinition userIdentityTokenDefinition;

    public UserIdentityTokenBuilderImpl(
        PascalString policyId, UserIdentityTokenDefinition userIdentityTokenDefinition) {
      this.policyId = policyId;
      this.userIdentityTokenDefinition = userIdentityTokenDefinition;
    }

    public UserIdentityToken build() {
      UserIdentityToken userIdentityToken =
          new UserIdentityToken(policyId, userIdentityTokenDefinition);
      return userIdentityToken;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof UserIdentityToken)) {
      return false;
    }
    UserIdentityToken that = (UserIdentityToken) o;
    return (getPolicyId() == that.getPolicyId())
        && (getUserIdentityTokenDefinition() == that.getUserIdentityTokenDefinition())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPolicyId(), getUserIdentityTokenDefinition());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
