/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecurityHeader implements Message {

  // Properties.
  protected final long secureChannelId;
  protected final long secureTokenId;

  public SecurityHeader(long secureChannelId, long secureTokenId) {
    super();
    this.secureChannelId = secureChannelId;
    this.secureTokenId = secureTokenId;
  }

  public long getSecureChannelId() {
    return secureChannelId;
  }

  public long getSecureTokenId() {
    return secureTokenId;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecurityHeader");

    // Simple Field (secureChannelId)
    writeSimpleField("secureChannelId", secureChannelId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (secureTokenId)
    writeSimpleField("secureTokenId", secureTokenId, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("SecurityHeader");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SecurityHeader _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (secureChannelId)
    lengthInBits += 32;

    // Simple field (secureTokenId)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static SecurityHeader staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static SecurityHeader staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SecurityHeader");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long secureChannelId = readSimpleField("secureChannelId", readUnsignedLong(readBuffer, 32));

    long secureTokenId = readSimpleField("secureTokenId", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("SecurityHeader");
    // Create the instance
    SecurityHeader _securityHeader;
    _securityHeader = new SecurityHeader(secureChannelId, secureTokenId);
    return _securityHeader;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecurityHeader)) {
      return false;
    }
    SecurityHeader that = (SecurityHeader) o;
    return (getSecureChannelId() == that.getSecureChannelId())
        && (getSecureTokenId() == that.getSecureTokenId())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSecureChannelId(), getSecureTokenId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
