/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class QueryNextResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "624";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final int noOfQueryDataSets;
  protected final List<ExtensionObjectDefinition> queryDataSets;
  protected final PascalByteString revisedContinuationPoint;

  public QueryNextResponse(
      ExtensionObjectDefinition responseHeader,
      int noOfQueryDataSets,
      List<ExtensionObjectDefinition> queryDataSets,
      PascalByteString revisedContinuationPoint) {
    super();
    this.responseHeader = responseHeader;
    this.noOfQueryDataSets = noOfQueryDataSets;
    this.queryDataSets = queryDataSets;
    this.revisedContinuationPoint = revisedContinuationPoint;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public int getNoOfQueryDataSets() {
    return noOfQueryDataSets;
  }

  public List<ExtensionObjectDefinition> getQueryDataSets() {
    return queryDataSets;
  }

  public PascalByteString getRevisedContinuationPoint() {
    return revisedContinuationPoint;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("QueryNextResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfQueryDataSets)
    writeSimpleField("noOfQueryDataSets", noOfQueryDataSets, writeSignedInt(writeBuffer, 32));

    // Array Field (queryDataSets)
    writeComplexTypeArrayField("queryDataSets", queryDataSets, writeBuffer);

    // Simple Field (revisedContinuationPoint)
    writeSimpleField(
        "revisedContinuationPoint",
        revisedContinuationPoint,
        new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("QueryNextResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    QueryNextResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (noOfQueryDataSets)
    lengthInBits += 32;

    // Array field
    if (queryDataSets != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : queryDataSets) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= queryDataSets.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (revisedContinuationPoint)
    lengthInBits += revisedContinuationPoint.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("QueryNextResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    int noOfQueryDataSets = readSimpleField("noOfQueryDataSets", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> queryDataSets =
        readCountArrayField(
            "queryDataSets",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("579")),
                readBuffer),
            noOfQueryDataSets);

    PascalByteString revisedContinuationPoint =
        readSimpleField(
            "revisedContinuationPoint",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("QueryNextResponse");
    // Create the instance
    return new QueryNextResponseBuilderImpl(
        responseHeader, noOfQueryDataSets, queryDataSets, revisedContinuationPoint);
  }

  public static class QueryNextResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final int noOfQueryDataSets;
    private final List<ExtensionObjectDefinition> queryDataSets;
    private final PascalByteString revisedContinuationPoint;

    public QueryNextResponseBuilderImpl(
        ExtensionObjectDefinition responseHeader,
        int noOfQueryDataSets,
        List<ExtensionObjectDefinition> queryDataSets,
        PascalByteString revisedContinuationPoint) {
      this.responseHeader = responseHeader;
      this.noOfQueryDataSets = noOfQueryDataSets;
      this.queryDataSets = queryDataSets;
      this.revisedContinuationPoint = revisedContinuationPoint;
    }

    public QueryNextResponse build() {
      QueryNextResponse queryNextResponse =
          new QueryNextResponse(
              responseHeader, noOfQueryDataSets, queryDataSets, revisedContinuationPoint);
      return queryNextResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof QueryNextResponse)) {
      return false;
    }
    QueryNextResponse that = (QueryNextResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getNoOfQueryDataSets() == that.getNoOfQueryDataSets())
        && (getQueryDataSets() == that.getQueryDataSets())
        && (getRevisedContinuationPoint() == that.getRevisedContinuationPoint())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getNoOfQueryDataSets(),
        getQueryDataSets(),
        getRevisedContinuationPoint());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
